/*
 * Decompiled with CFR 0.152.
 */
package com.orangevolt.tools.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class KDEShortcutTask
extends Task {
    Properties p = new Properties();
    File file = null;
    ArrayList customProperties = new ArrayList();

    public void setName(String s) {
        this.p.put("Name", s);
    }

    public void setExecute(String s) {
        this.p.put("Exec", s);
    }

    public Execute createExecute() {
        return new Execute();
    }

    public Property createProperty() {
        Property prop = new Property();
        this.customProperties.add(prop);
        return prop;
    }

    public WorkingDirectory createWorkingDirectory() {
        return new WorkingDirectory();
    }

    public void setWorkingDirectory(File f) {
        this.p.put("Path", f.getAbsolutePath());
    }

    public void setIcon(String s) {
        this.p.put("Icon", s);
    }

    public void setIconFile(File f) {
        this.p.put("Icon", f.getAbsolutePath());
    }

    public void setComment(String s) {
        this.p.put("Comment", s);
    }

    public void setTerminal(boolean b) {
        this.p.put("Terminal", b ? "1" : "0");
    }

    public void setTerminalOptions(String s) {
        this.p.put("TerminalOptions", s);
    }

    public void setType(String s) {
        if (s.equalsIgnoreCase("application")) {
            this.p.put("Type", "Application");
        } else if (s.equalsIgnoreCase("link")) {
            this.p.put("Type", "Link");
        } else {
            throw new BuildException("Only \"Application\" and \"Link\" are valid values for attribute \"Type\".");
        }
    }

    public void execute() throws BuildException {
        if (!this.file.getName().endsWith(".desktop")) {
            this.log("kde shortcut files should have name suffix \".desktop\"", 1);
        }
        if (!this.file.getParentFile().exists() && !this.file.getParentFile().mkdirs()) {
            throw new BuildException("Creating kde shortcut directory " + this.file.getParentFile().getAbsolutePath() + " failed.");
        }
        Iterator iter = this.customProperties.iterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            prop.run();
        }
        try {
            this.log("Writing kde shortcut file " + this.file.getAbsolutePath());
            PrintWriter pw = new PrintWriter(new FileWriter(this.file));
            pw.println("[Desktop Entry]");
            Enumeration<Object> e = this.p.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                pw.println(key + "=" + this.p.getProperty(key));
            }
            pw.println("Type=" + this.p.getProperty("Type", "Application"));
            pw.close();
        }
        catch (IOException ex) {
            throw new BuildException("Writing kde shortcut file " + this.file.getAbsolutePath() + "failed : " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void setUrl(URL url) {
        this.p.put("URL", url.toString());
    }

    public void setFile(File file) {
        this.file = file;
    }

    public class WorkingDirectory {
        public void addText(String s) {
            if (s.trim().length() > 0) {
                KDEShortcutTask.this.setWorkingDirectory(new File(KDEShortcutTask.this.getProject().replaceProperties(s.trim())));
            }
        }
    }

    public class Execute {
        public void addText(String s) {
            if (s.trim().length() > 0) {
                KDEShortcutTask.this.setExecute(KDEShortcutTask.this.getProject().replaceProperties(s.trim()));
            }
        }
    }

    public class Property
    implements Runnable {
        String name = null;
        String value = null;

        public void setName(String s) {
            this.name = s;
        }

        public void setValue(String s) {
            this.value = s;
        }

        public void addText(String s) {
            if (s.trim().length() > 0) {
                this.value = KDEShortcutTask.this.getProject().replaceProperties(s.trim());
            }
        }

        public void run() {
            if (this.name == null || this.value == null) {
                throw new BuildException("Attribute \"name\" and \"value\" are required for shortcut properties");
            }
            KDEShortcutTask.this.p.put(this.name, this.value);
        }
    }
}

