/*
 * Decompiled with CFR 0.152.
 */
package com.orangevolt.tools.ant;

import com.orangevolt.tools.ant.JStubTask;
import com.orangevolt.tools.ant.pe.PEFile;
import com.orangevolt.tools.ant.pe.res.ResIcon;
import com.orangevolt.tools.ant.pe.res.util.IcoCodec;
import com.orangevolt.tools.ant.stub;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.ImageIcon;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class SFXTask
extends Task {
    File archive = null;
    File output = null;
    String workingDirectory = "";
    String mode = null;
    String execute = null;
    File iconFile = null;
    static final int TOKEN_LENGTH = "__EXECUTABLE__NAME__".length();
    static byte[] buffer = new byte[8192];

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public void setIcon(File iconFile) {
        this.iconFile = iconFile;
    }

    public Execute createExecute() {
        if (this.execute != null) {
            throw new BuildException("Property \"execute\" is always defined. You have to use either <execute> or the property attribute of task sfx");
        }
        return new Execute();
    }

    public void setExecute(String string) {
        if (this.execute != null) {
            throw new BuildException("Property \"execute\" is always defined. You have to use either <execute> or the property attribute of task sfx");
        }
        this.execute = string;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public void setOutput(File file) {
        this.output = file;
    }

    public WorkingDirectory createWorkingDirectory() {
        if (this.workingDirectory.length() > 0) {
            throw new BuildException("Property \"workingdirectory\" is always defined. You have to use either <workdingdirectory> or the property attribute of task sfx");
        }
        return new WorkingDirectory();
    }

    public void setWorkingDirectory(String string) {
        if (this.workingDirectory.length() > 0) {
            throw new BuildException("Property \"workingdirectory\" is always defined. You have to use either <workdingdirectory> or the property attribute of task jstub");
        }
        this.workingDirectory = string;
    }

    public void execute() throws BuildException {
        if (this.archive == null) {
            throw new BuildException("archive attribute not set");
        }
        if (this.execute == null) {
            throw new BuildException("execute attribute not set");
        }
        if (this.mode == null) {
            throw new BuildException("mode attribute not set");
        }
        if (this.output == null) {
            throw new BuildException("output attribute not set");
        }
        Properties p = new Properties();
        p.put("__EXECUTABLE__PATH__", this.workingDirectory);
        p.put("__EXECUTABLE__NAME__", this.execute);
        this.log("Generating " + this.mode + " executable " + this.output);
        if (this.mode.startsWith("java")) {
            try {
                int count;
                InputStream in;
                ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(this.output));
                ZipEntry ze = new ZipEntry(stub.class.getName().replace('.', '/') + "16x16.gif");
                zos.putNextEntry(ze);
                InputStream inputStream = this.iconFile != null ? new FileInputStream(this.iconFile) : (in = stub.class.getResourceAsStream("stub16x16.gif"));
                while ((count = in.read(buffer)) != -1) {
                    zos.write(buffer, 0, count);
                }
                ze = new ZipEntry(stub.class.getName().replace('.', '/') + ".class");
                zos.putNextEntry(ze);
                in = stub.class.getResourceAsStream("stub.class");
                while ((count = in.read(buffer)) != -1) {
                    zos.write(buffer, 0, count);
                }
                ze = new ZipEntry(stub.class.getName().replace('.', '/') + ".properties");
                zos.putNextEntry(ze);
                Properties stubProperties = new Properties();
                stubProperties.put("__MODE__", this.mode.equals("java-console") ? "console" : "gui");
                stubProperties.put("__EXEC_NAME__", this.execute);
                stubProperties.put("__EXEC_PATH__", this.workingDirectory);
                stubProperties.store((OutputStream)zos, "ORANGEVOLT stub 1.0 properties");
                zos.close();
            }
            catch (Exception e) {
                throw new BuildException("Unable to copy jar stub", (Throwable)e);
            }
            Jar jar = new Jar();
            jar.setCompress(true);
            jar.setUpdate(true);
            ZipFileSet zfs = new ZipFileSet();
            zfs.setSrc(this.archive);
            jar.addZipfileset(zfs);
            jar.setDestFile(this.output);
            try {
                Manifest manifest = Manifest.getDefaultManifest();
                Manifest.Section section = manifest.getMainSection();
                section.addConfiguredAttribute(new Manifest.Attribute("Main-Class", "com.orangevolt.tools.ant.stub"));
                jar.addConfiguredManifest(manifest);
                jar.setOwningTarget(this.getOwningTarget());
                jar.setProject(this.getProject());
                jar.setTaskName(this.getTaskName());
                jar.execute();
            }
            catch (ManifestException ex) {
                throw new BuildException("ManifestException occured.", (Throwable)ex);
            }
        }
        try {
            FileOutputStream out = new FileOutputStream(this.output);
            byte[] scanBuffer = new byte[TOKEN_LENGTH];
            if (this.mode.startsWith("win32")) {
                File tmpExe = null;
                if (this.iconFile != null) {
                    try {
                        int read;
                        tmpExe = File.createTempFile(this.output.getName(), "tmp");
                        tmpExe.deleteOnExit();
                        FileOutputStream _out = new FileOutputStream(tmpExe);
                        long count = 0L;
                        InputStream in = stub.class.getResourceAsStream(this.mode.indexOf("console") != -1 ? "stub-console.exe" : "stub.exe");
                        while ((read = in.read(buffer)) > -1) {
                            _out.write(buffer, 0, read);
                            count += (long)read;
                        }
                        _out.close();
                        PEFile peFile = new PEFile(tmpExe);
                        peFile.open();
                        ImageIcon ii = null;
                        ii = this.iconFile.getName().toLowerCase().endsWith(".ico") ? new ImageIcon(IcoCodec.loadImages(this.iconFile)[0]) : new ImageIcon(this.iconFile.toURL());
                        Image img = ii.getImage().getScaledInstance(32, 32, 1);
                        while (img.getHeight(null) == -1) {
                            Thread.sleep(50L);
                        }
                        ResIcon resIcon = new ResIcon(img);
                        peFile.replaceDefaultIcon(resIcon);
                        tmpExe = File.createTempFile(this.output.getName(), "tmp.patched");
                        tmpExe.deleteOnExit();
                        peFile.dumpTo(tmpExe);
                        peFile.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new BuildException("Replacing the default icon on executable " + this.output + " failed", (Throwable)ex);
                    }
                }
                try {
                    FileInputStream in = tmpExe != null ? new FileInputStream(tmpExe) : stub.class.getResourceAsStream(this.mode.indexOf("console") != -1 ? "stub-console.exe" : "stub.exe");
                    ((InputStream)in).read(scanBuffer, 0, scanBuffer.length);
                    long position = 1L;
                    while (p.size() > 0) {
                        while (!p.containsKey(new String(scanBuffer))) {
                            out.write(scanBuffer[0]);
                            int nextb = ((InputStream)in).read();
                            ++position;
                            SFXTask.shiftArray(scanBuffer);
                            scanBuffer[scanBuffer.length - 1] = (byte)nextb;
                        }
                        String value = p.getProperty(new String(scanBuffer));
                        p.remove(new String(scanBuffer));
                        this.log(new String(scanBuffer) + " at " + (position - 1L) + " replaced by " + value);
                        out.write(value.getBytes());
                        for (int j = value.getBytes().length; j < 128; ++j) {
                            out.write(0);
                        }
                        ((InputStream)in).skip(128 - TOKEN_LENGTH);
                        position += (long)(128 - TOKEN_LENGTH);
                        ((InputStream)in).read(scanBuffer, 0, scanBuffer.length);
                    }
                    out.write(scanBuffer);
                    int read = 0;
                    while ((read = ((InputStream)in).read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                    }
                    ((InputStream)in).close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (this.mode.equals("unix")) {
                p.put("__EXECUTABLE__NAME__", JStubTask.prepareUnixCommand(this.execute));
                p.put("__EXECUTABLE__PATH__", JStubTask.prepareUnixCommand(this.workingDirectory));
                InputStream in = SFXTask.class.getResourceAsStream("stub.sh");
                in.read(scanBuffer, 0, scanBuffer.length);
                long position = 1L;
                while (p.size() > 0) {
                    while (!p.containsKey(new String(scanBuffer))) {
                        out.write(scanBuffer[0]);
                        int nextb = in.read();
                        ++position;
                        SFXTask.shiftArray(scanBuffer);
                        scanBuffer[scanBuffer.length - 1] = (byte)nextb;
                    }
                    String value = p.getProperty(new String(scanBuffer));
                    p.remove(new String(scanBuffer));
                    this.log(new String(scanBuffer) + " at " + (position - 1L) + " replaced by " + value);
                    out.write(value.getBytes());
                    in.read(scanBuffer, 0, scanBuffer.length);
                }
                out.write(scanBuffer);
                int read = 0;
                while ((read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                in.close();
                if (this.iconFile != null) {
                    this.log("Setting the Icon for unix executables is not supported.", 2);
                }
            } else {
                throw new BuildException("Unknown mode " + this.mode);
            }
            SFXTask.copy(this.archive, out);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Cannot open archive", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("IO Problem occured", (Throwable)e);
        }
    }

    public static void copy(File file, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(file);
        int read = 0;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        in.close();
    }

    private static void shiftArray(byte[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            array[i] = array[i + 1];
        }
        array[array.length - 1] = 0;
    }

    public class WorkingDirectory {
        public void addText(String s) {
            SFXTask.this.workingDirectory = SFXTask.this.getProject().replaceProperties(s.trim());
        }
    }

    public class Execute {
        public void addText(String s) {
            SFXTask.this.execute = SFXTask.this.getProject().replaceProperties(s.trim());
        }
    }
}

