/*
 * Decompiled with CFR 0.152.
 */
package com.orangevolt.tools.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;

public class UnixLinkTask
extends Task {
    File file = null;
    File target = null;

    public void execute() throws BuildException {
        if (this.file == null || this.target == null) {
            throw new BuildException("Attribute \"file\" and \"target\" are required.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)out);
        try {
            this.log("Creating symbolic link " + this.file.getName() + " in directory " + this.file.getParent() + " targeting " + this.target.getAbsolutePath());
            Execute execute = new Execute((ExecuteStreamHandler)psh);
            execute.setCommandline(new String[]{"/bin/ln", "--backup=numbered", "-s", this.target.getAbsolutePath(), this.file.getAbsolutePath()});
            int i = execute.execute();
            if (i != 0) {
                throw new BuildException("Unable to execute /bin/ln " + Execute.toString((ByteArrayOutputStream)out));
            }
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)((Object)ex);
            }
            throw new BuildException("Unable to execute /bin/ln " + ex.getMessage());
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setTarget(File target) {
        this.target = target;
    }
}

