/*
 * Decompiled with CFR 0.152.
 */
package com.orangevolt.tools.ant;

import com.roxes.win32.LnkFile;
import com.roxes.win32.UrlFile;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Win32ShortcutTask
extends Task {
    String workingDirectory = null;
    String iconFile = null;
    int iconIndex = -1;
    URL url = null;
    String execute = null;
    int showCommand = -1;
    int hotKey = -1;
    String modified = null;
    File file = null;
    String comment = null;

    public void setHotKey(int i) {
        this.hotKey = i;
    }

    public void setFile(File file) {
        if (!file.getName().endsWith(".url") && !file.getName().endsWith(".lnk")) {
            throw new BuildException("Attribute file can only have suffix \".lnk\" or \".url\"");
        }
        this.file = file;
    }

    public void setIconFile(String string) {
        this.iconFile = string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setIconIndex(int i) {
        this.iconIndex = i;
    }

    public void setModified(String string) {
        this.modified = string;
    }

    public void setShowCommand(String showCommand) {
        if ((showCommand = showCommand.toLowerCase().trim()).equals("normal")) {
            this.showCommand = -1;
        } else if (showCommand.equals("minimized")) {
            this.showCommand = 7;
        } else if (showCommand.equals("maximized")) {
            this.showCommand = 3;
        } else {
            throw new BuildException("Invalid Attribute showCommand value " + showCommand + " : Valid values are normal, minimized or maximized.");
        }
    }

    public Url createUrl() {
        if (this.url != null) {
            throw new BuildException("Property \"url\" is always defined. You have to use either <url> or the attribute \"url\" of task win32.shortcut");
        }
        return new Url();
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public Execute createExecute() {
        if (this.execute != null) {
            throw new BuildException("Property \"execute\" is always defined. You have to use either <execute> or the attribute \"execute\" of task win32.shortcut");
        }
        return new Execute();
    }

    public void setExecute(String string) {
        if (this.execute != null) {
            throw new BuildException("Property \"execute\" is always defined. You have to use either <execute> or the attribute \"execute\" of task win32.shortcut");
        }
        this.execute = this.getProject().replaceProperties(string);
    }

    public WorkingDirectory createWorkingDirectory() {
        if (this.workingDirectory != null) {
            throw new BuildException("Property \"workingdirectory\" is always defined. You have to use either <workingdirectory> or the \"workingdirectory\"attribute of task win32.shortcut");
        }
        return new WorkingDirectory();
    }

    public void setWorkingDirectory(String string) {
        if (this.workingDirectory != null) {
            throw new BuildException("Property \"workingdirectory\" is always defined. You have to use either <workingdirectory> or the \"workingdirectory\"attribute of task win32.shortcut");
        }
        this.workingDirectory = string;
    }

    public void execute() throws BuildException {
        if (this.file == null) {
            throw new BuildException("Attribute \"file\" is required by task win23.shortcut");
        }
        this.log("Creating shortcut " + this.file.getAbsolutePath(), 2);
        if (this.url != null == (this.execute != null)) {
            throw new BuildException("Either attribute \"url\" or \"execute\" has to be set in win23.shortcut");
        }
        try {
            if (this.url != null) {
                UrlFile shortcut = new UrlFile(this.file);
                shortcut.setHotKey(this.hotKey);
                shortcut.setIconFile(this.iconFile);
                shortcut.setIconIndex(this.iconIndex);
                shortcut.setModified(this.modified);
                shortcut.setShowCommand(this.showCommand);
                if (this.comment != null) {
                    this.log("Defined \"comment\" will be ignored for .url shortcuts", 1);
                }
                shortcut.setUrl(this.url);
                shortcut.setWorkingDirectory(this.workingDirectory);
                shortcut.save();
            } else {
                boolean success;
                File parent = this.file.getParentFile();
                if (parent.exists() && !parent.isDirectory()) {
                    throw new BuildException("parent file " + parent.getAbsolutePath() + " is not a directory !");
                }
                if (!parent.exists() && !(success = parent.mkdirs())) {
                    throw new BuildException("Creating parent directory " + parent.getAbsolutePath() + " failed.");
                }
                LnkFile shortcut = new LnkFile(parent.getAbsolutePath(), this.file.getName().substring(0, this.file.getName().length() - 4));
                if (this.hotKey != -1) {
                    this.log("Defined \"hotkey\" will be ignored for .lnk shortcuts", 1);
                }
                shortcut.setIconLocation(this.iconFile);
                shortcut.setIconIndex(this.iconIndex);
                if (this.modified != null) {
                    this.log("Defined \"modified\" will be ignored for .lnk shortcuts", 1);
                }
                if (this.showCommand != -1) {
                    this.log("Defined \"showcommand\" will be ignored for .lnk shortcuts", 1);
                }
                shortcut.setPath(this.execute);
                shortcut.setWorkingDirectory(this.workingDirectory);
                shortcut.setDescription(this.comment);
                shortcut.save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BuildException("Error writing shortcut " + this.file.getAbsolutePath() + " : " + ex.getMessage(), (Throwable)ex);
        }
    }

    public class WorkingDirectory {
        public void addText(String s) {
            Win32ShortcutTask.this.execute = Win32ShortcutTask.this.getProject().replaceProperties(s.trim());
        }
    }

    public class Execute {
        public void addText(String s) {
            Win32ShortcutTask.this.execute = Win32ShortcutTask.this.getProject().replaceProperties(s.trim());
        }
    }

    public class Url {
        public void addText(String s) {
            if (Win32ShortcutTask.this.url != null) {
                throw new BuildException("Property \"url\" is always defined. You have to use either <url> or the attribute \"url\" of task win32.shortcut");
            }
            try {
                Win32ShortcutTask.this.url = new URL(Win32ShortcutTask.this.getProject().replaceProperties(s.trim()));
            }
            catch (MalformedURLException ex) {
                throw new BuildException("url is not valid : " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

