/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.process;

import java.io.IOException;
import org.artofsolving.jodconverter.process.ProcessManager;
import org.artofsolving.jodconverter.process.ProcessQuery;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.ProcessFinder;

public class SigarProcessManager
implements ProcessManager {
    public long findPid(ProcessQuery query) throws IOException {
        Sigar sigar = new Sigar();
        try {
            long[] pids = ProcessFinder.find((Sigar)sigar, (String)("State.Name.eq=" + query.getCommand()));
            int i = 0;
            while (i < pids.length) {
                String[] arguments = sigar.getProcArgs(pids[i]);
                if (arguments != null && this.argumentMatches(arguments, query.getArgument())) {
                    long l = pids[i];
                    return l;
                }
                ++i;
            }
            return -2L;
        }
        catch (SigarException sigarException) {
            throw new IOException("findPid failed (jdk 1.5 compatibility changes): " + sigarException.getMessage());
        }
        finally {
            sigar.close();
        }
    }

    public void kill(Process process, long pid) throws IOException {
        Sigar sigar = new Sigar();
        try {
            try {
                sigar.kill(pid, Sigar.getSigNum((String)"KILL"));
            }
            catch (SigarException sigarException) {
                throw new IOException("kill failed (jdk 1.5 compatibility changes): " + sigarException.getMessage());
            }
        }
        finally {
            sigar.close();
        }
    }

    private boolean argumentMatches(String[] arguments, String expected) {
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            if (argument.contains(expected)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

