/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.anttasks.eartask;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.zip.ZipOutputStream;

public class EarTask
extends Jar {
    private static final String APPXML_NAME = "META-INF/application.xml";
    private String displayName;
    private String smallIcon;
    private String largeIcon;
    private List modules = new ArrayList();
    private List roles = new ArrayList();
    private static final String xmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE application PUBLIC \"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN\" \"http://java.sun.com/dtd/application_1_3.dtd\">";

    public EarTask() {
        ((Zip)this).archiveType = "eartask";
        ((Zip)this).emptyBehavior = "create";
        ((Zip)this).duplicate = "preserve";
    }

    public void execute() throws BuildException {
        if (this.displayName == null) {
            throw new BuildException("The 'displayName' must be specified, according to the J2EE/EAR spec.");
        }
        for (int i = 0; i < this.modules.size(); ++i) {
            this.addZipfileset((Module)((Object)this.modules.get(i)));
        }
        super.execute();
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        super.initZipOutputStream(zOut);
        this.writeAppXML(zOut, this.mkApplicationXML());
    }

    private void writeAppXML(ZipOutputStream zOut, String appXML) throws IOException {
        this.zipDir(null, zOut, "META-INF/", 16877);
        ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bufOut, "UTF-8");
        PrintWriter writer = new PrintWriter(out);
        writer.println(appXML);
        writer.flush();
        ByteArrayInputStream bufIn = new ByteArrayInputStream(bufOut.toByteArray());
        super.zipFile((InputStream)bufIn, zOut, APPXML_NAME, System.currentTimeMillis(), null, 33188);
        super.initZipOutputStream(zOut);
    }

    public void addMetainf(ZipFileSet fs) {
        fs.setPrefix("META-INF/");
        super.addFileset((FileSet)fs);
    }

    public void addModule(Module m) {
        this.modules.add(m);
    }

    public void addSecurityRole(SecurityRole r) {
        this.roles.add(r);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    protected String mkApplicationXML() {
        StringBuffer buf = new StringBuffer(1000);
        buf.append(xmlHeader).append("\n");
        buf.append("<application>\n");
        if (this.getSmallIcon() != null || this.getLargeIcon() != null) {
            buf.append("  <icon>");
            EarTask.mkSimpleTag(buf, "small-icon", this.getLargeIcon());
            EarTask.mkSimpleTag(buf, "large-icon", this.getLargeIcon());
            buf.append("</icon>\n");
        }
        EarTask.mkSimpleTag(buf, "display-name", this.getDisplayName(), "  ").append("\n");
        EarTask.mkSimpleTag(buf, "description", this.getDescription(), "  ").append("\n");
        EarTask.mkTagList(buf, this.modules, "  ");
        EarTask.mkTagList(buf, this.roles, "  ");
        buf.append("</application>\n");
        return buf.toString();
    }

    protected static void mkTagList(StringBuffer buf, List lst, String indent) {
        for (int i = 0; i < lst.size(); ++i) {
            buf.append(indent).append(lst.get(i));
        }
    }

    protected static StringBuffer mkSimpleTag(StringBuffer buf, String tag, String value) {
        return EarTask.mkSimpleTag(buf, tag, value, "");
    }

    protected static StringBuffer mkSimpleTag(StringBuffer buf, String tag, String value, String indent) {
        if (value == null || value.trim().length() == 0) {
            return buf;
        }
        return buf.append(indent).append("<").append(tag).append(">").append(value).append("</").append(tag).append(">");
    }

    public static class SecurityRole {
        private String name;
        private String description;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(100);
            buf.append("<security-role>");
            EarTask.mkSimpleTag(buf, "description", this.getDescription());
            EarTask.mkSimpleTag(buf, "role-name", this.getName());
            buf.append("</security-role>\n");
            return buf.toString();
        }
    }

    public static class Types
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"java", "ejb", "web", "connector"};
        }
    }

    public static class Module
    extends ZipFileSet {
        private Types type = new Types();
        private String context = null;

        public Module() {
            super.setPrefix("");
            this.type.setValue("java");
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(100);
            String[] fileNames = this.getDirectoryScanner(this.getProject()).getIncludedFiles();
            this.validate(fileNames);
            for (int i = 0; i < fileNames.length; ++i) {
                this.mkModule(buf, new File(fileNames[i]));
            }
            return buf.toString();
        }

        protected void validate(String[] fileNames) throws BuildException {
            if (this.type == null || this.type.getValue() == null) {
                throw new BuildException("Missing type attribute for module");
            }
            if (fileNames == null || fileNames.length == 0) {
                throw new BuildException((Object)((Object)this.type) + " module FileSet was empty");
            }
            if (this.type.getValue().equals("web") && this.context != null && fileNames.length != 1) {
                throw new BuildException("Web module with context=" + this.context + " has more than 1 file: " + Arrays.asList(fileNames));
            }
        }

        protected StringBuffer mkModule(StringBuffer buf, File file) {
            buf.append("<module>");
            buf.append("<").append((Object)this.getType()).append(">");
            if (this.type.getValue().equals("web")) {
                EarTask.mkSimpleTag(buf, "web-uri", file.getName());
                EarTask.mkSimpleTag(buf, "context-root", Module.mkContext(file, this.getContext()));
            } else {
                buf.append(file.getName());
            }
            buf.append("</").append((Object)this.getType()).append(">");
            buf.append("</module>\n");
            return buf;
        }

        protected static String mkContext(File file, String appName) {
            if (appName != null) {
                return appName;
            }
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            return "/" + fileName;
        }

        public Types getType() {
            return this.type;
        }

        public void setType(Types type) {
            this.type = type;
        }

        public String getContext() {
            return this.context;
        }

        public void setContext(String context) {
            this.context = context;
        }
    }
}

