/*
 * Decompiled with CFR 0.152.
 */
package ooo.connector.server;

import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.lib.util.NativeLibraryLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class OOoServer {
    private Process oooProcess = null;
    private String oooExecFolder;
    private List oooOptions;

    public OOoServer(String oooExecFolder) {
        this.oooExecFolder = oooExecFolder;
        this.oooOptions = OOoServer.getDefaultOOoOptions();
    }

    public OOoServer(String oooExecFolder, List oooOptions) {
        this.oooExecFolder = oooExecFolder;
        this.oooOptions = oooOptions;
    }

    public void start(String oooAcceptOption) throws BootstrapException, IOException, MalformedURLException {
        int arguments;
        String sOffice = System.getProperty("os.name").startsWith("Windows") ? "soffice.exe" : "soffice";
        URL[] oooExecFolderURL = new URL[]{new File(this.oooExecFolder).toURI().toURL()};
        URLClassLoader loader = new URLClassLoader(oooExecFolderURL);
        File fOffice = NativeLibraryLoader.getResource((ClassLoader)loader, (String)sOffice);
        if (fOffice == null) {
            throw new BootstrapException("no office executable found!");
        }
        int n = arguments = this.oooOptions != null ? this.oooOptions.size() + 1 : 1;
        if (oooAcceptOption != null) {
            ++arguments;
        }
        String[] oooCommand = new String[arguments];
        oooCommand[0] = fOffice.getPath();
        int i = 0;
        while (i < this.oooOptions.size()) {
            oooCommand[i + 1] = (String)this.oooOptions.get(i);
            ++i;
        }
        if (oooAcceptOption != null) {
            oooCommand[arguments - 1] = oooAcceptOption;
        }
        this.oooProcess = Runtime.getRuntime().exec(oooCommand);
        OOoServer.pipe(this.oooProcess.getInputStream(), System.out, "CO> ");
        OOoServer.pipe(this.oooProcess.getErrorStream(), System.err, "CE> ");
    }

    public void kill() {
        if (this.oooProcess != null) {
            this.oooProcess.destroy();
            this.oooProcess = null;
        }
    }

    private static void pipe(final InputStream in, final PrintStream out, final String prefix) {
        new Thread("Pipe: " + prefix){

            public void run() {
                BufferedReader r = new BufferedReader(new InputStreamReader(in));
                try {
                    String s;
                    while ((s = r.readLine()) != null) {
                        out.println(String.valueOf(prefix) + s);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }.start();
    }

    public static List getDefaultOOoOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-nologo");
        options.add("-nodefault");
        options.add("-norestore");
        options.add("-nocrashreport");
        options.add("-nolockcheck");
        return options;
    }
}

