/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.windows;

import com.l2fprod.common.swing.JDirectoryChooser;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.plaf.DirectoryChooserUI;
import com.l2fprod.common.swing.tree.LazyMutableTreeNode;
import com.l2fprod.common.util.OS;
import com.l2fprod.common.util.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WindowsDirectoryChooserUI
extends BasicFileChooserUI
implements DirectoryChooserUI {
    private static Queue nodeQueue;
    private JDirectoryChooser chooser;
    private JTree tree;
    private JScrollPane treeScroll;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private BasicFileChooserUI.BasicFileView fileView = new WindowsFileView();
    private Action approveSelectionAction = new ApproveSelectionAction();
    private boolean useNodeQueue;
    static /* synthetic */ Class class$com$l2fprod$common$swing$plaf$DirectoryChooserUI;

    public WindowsDirectoryChooserUI(JDirectoryChooser chooser) {
        super(chooser);
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        super.rescanCurrentDirectory(fc);
        this.findFile(this.chooser.getSelectedFile() == null ? this.chooser.getCurrentDirectory() : this.chooser.getSelectedFile(), true, true);
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
        super.ensureFileIsVisible(fc, f);
        this.findFile(f, false, false);
    }

    protected String getToolTipText(MouseEvent event) {
        TreePath path = this.tree.getPathForLocation(event.getX(), event.getY());
        if (path != null && path.getLastPathComponent() instanceof FileTreeNode) {
            FileTreeNode node = (FileTreeNode)path.getLastPathComponent();
            String typeDescription = this.getFileView(this.chooser).getTypeDescription(node.getFile());
            if (typeDescription == null || typeDescription.length() == 0) {
                return node.toString();
            }
            return node.toString() + " - " + typeDescription;
        }
        return null;
    }

    public void installComponents(JFileChooser chooser) {
        this.chooser = (JDirectoryChooser)chooser;
        chooser.setLayout(LookAndFeelTweaks.createBorderLayout());
        chooser.setFileSelectionMode(1);
        JComponent accessory = chooser.getAccessory();
        if (accessory != null) {
            chooser.add("North", chooser.getAccessory());
        }
        this.tree = new JTree(){

            public String getToolTipText(MouseEvent event) {
                String tip = WindowsDirectoryChooserUI.this.getToolTipText(event);
                if (tip == null) {
                    return super.getToolTipText(event);
                }
                return tip;
            }
        };
        this.tree.addTreeExpansionListener(new TreeExpansion());
        this.tree.setModel(new FileSystemTreeModel(chooser.getFileSystemView()));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(false);
        this.tree.setCellRenderer(new FileSystemTreeRenderer());
        this.tree.setToolTipText("");
        this.treeScroll = new JScrollPane(this.tree);
        chooser.add("Center", this.treeScroll);
        this.treeScroll.setPreferredSize(new Dimension(300, 300));
        this.approveButton = new JButton();
        this.approveButton.setAction(this.getApproveSelectionAction());
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.buttonPanel = new JPanel(LookAndFeelTweaks.createButtonAreaLayout());
        this.buttonPanel.add(this.approveButton);
        this.buttonPanel.add(this.cancelButton);
        chooser.add("South", this.buttonPanel);
        this.updateView(chooser);
    }

    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        this.saveButtonToolTipText = ResourceManager.get(class$com$l2fprod$common$swing$plaf$DirectoryChooserUI == null ? (class$com$l2fprod$common$swing$plaf$DirectoryChooserUI = WindowsDirectoryChooserUI.class$("com.l2fprod.common.swing.plaf.DirectoryChooserUI")) : class$com$l2fprod$common$swing$plaf$DirectoryChooserUI).getString("DirectoryChooser.saveButtonToolTipText");
        this.openButtonToolTipText = ResourceManager.get(class$com$l2fprod$common$swing$plaf$DirectoryChooserUI == null ? (class$com$l2fprod$common$swing$plaf$DirectoryChooserUI = WindowsDirectoryChooserUI.class$("com.l2fprod.common.swing.plaf.DirectoryChooserUI")) : class$com$l2fprod$common$swing$plaf$DirectoryChooserUI).getString("DirectoryChooser.openButtonToolTipText");
        this.cancelButtonToolTipText = ResourceManager.get(class$com$l2fprod$common$swing$plaf$DirectoryChooserUI == null ? (class$com$l2fprod$common$swing$plaf$DirectoryChooserUI = WindowsDirectoryChooserUI.class$("com.l2fprod.common.swing.plaf.DirectoryChooserUI")) : class$com$l2fprod$common$swing$plaf$DirectoryChooserUI).getString("DirectoryChooser.cancelButtonToolTipText");
    }

    public void uninstallComponents(JFileChooser chooser) {
        chooser.remove(this.treeScroll);
        chooser.remove(this.buttonPanel);
    }

    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        this.tree.addTreeSelectionListener(new SelectionListener());
    }

    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new ChangeListener();
    }

    private void updateView(JFileChooser chooser) {
        if (chooser.getApproveButtonText() != null) {
            this.approveButton.setText(chooser.getApproveButtonText());
            this.approveButton.setMnemonic(chooser.getApproveButtonMnemonic());
        } else if (0 == chooser.getDialogType()) {
            this.approveButton.setText(this.openButtonText);
            this.approveButton.setToolTipText(this.openButtonToolTipText);
            this.approveButton.setMnemonic(this.openButtonMnemonic);
        } else {
            this.approveButton.setText(this.saveButtonText);
            this.approveButton.setToolTipText(this.saveButtonToolTipText);
            this.approveButton.setMnemonic(this.saveButtonMnemonic);
        }
        this.cancelButton.setText(this.cancelButtonText);
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.buttonPanel.setVisible(chooser.getControlButtonsAreShown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findFile(File fileToLocate, boolean selectFile, boolean reload) {
        if (fileToLocate == null || !fileToLocate.isDirectory()) {
            return;
        }
        File file = null;
        try {
            file = fileToLocate.getCanonicalFile();
        }
        catch (Exception e) {
            return;
        }
        this.useNodeQueue = false;
        try {
            ArrayList<File> files = new ArrayList<File>();
            files.add(file);
            while ((file = this.chooser.getFileSystemView().getParentDirectory(file)) != null) {
                files.add(0, file);
            }
            ArrayList<DefaultMutableTreeNode> path = new ArrayList<DefaultMutableTreeNode>();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            path.add(node);
            boolean found = true;
            block6: while (files.size() > 0 && found) {
                found = false;
                int c = node.getChildCount();
                for (int i = 0; i < c; ++i) {
                    DefaultMutableTreeNode current = (DefaultMutableTreeNode)node.getChildAt(i);
                    File f = ((FileTreeNode)current).getFile();
                    if (!files.get(0).equals(f)) continue;
                    path.add(current);
                    files.remove(0);
                    node = current;
                    found = true;
                    continue block6;
                }
            }
            TreePath pathToSelect = new TreePath(path.toArray());
            if (pathToSelect.getLastPathComponent() instanceof FileTreeNode && reload) {
                ((FileTreeNode)pathToSelect.getLastPathComponent()).clear();
            }
            if (selectFile) {
                this.tree.expandPath(pathToSelect);
                this.tree.setSelectionPath(pathToSelect);
            }
            this.tree.scrollPathToVisible(pathToSelect);
        }
        finally {
            this.useNodeQueue = true;
        }
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    private void setSelectedFiles() {
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (selectedPaths == null || selectedPaths.length == 0) {
            this.chooser.setSelectedFile(null);
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        int c = selectedPaths.length;
        for (int i = 0; i < c; ++i) {
            LazyMutableTreeNode node = (LazyMutableTreeNode)selectedPaths[i].getLastPathComponent();
            if (!(node instanceof FileTreeNode)) continue;
            File f = ((FileTreeNode)node).getFile();
            files.add(f);
        }
        this.chooser.setSelectedFiles(files.toArray(new File[0]));
    }

    private static synchronized void addToQueue(FileTreeNode node, JTree tree) {
        if (nodeQueue == null || !nodeQueue.isAlive()) {
            nodeQueue = new Queue();
            nodeQueue.start();
        }
        if (node.canEnqueue()) {
            nodeQueue.add(node, tree);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class QueueItem {
        FileTreeNode node;
        JTree tree;

        public QueueItem(FileTreeNode node, JTree tree) {
            this.node = node;
            this.tree = tree;
        }
    }

    private static final class Queue
    extends Thread {
        private volatile Stack nodes = new Stack();
        private Object lock = new Object();
        private volatile boolean running = true;

        public Queue() {
            super("DirectoryChooser-BackgroundLoader");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(FileTreeNode node, JTree tree) {
            if (!this.isAlive()) {
                throw new IllegalArgumentException("Queue is no longer alive");
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.running) {
                    this.nodes.addElement(new QueueItem(node, tree));
                    this.lock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                Object item;
                while (this.nodes.size() > 0) {
                    item = (QueueItem)this.nodes.pop();
                    FileTreeNode node = ((QueueItem)item).node;
                    JTree tree = ((QueueItem)item).tree;
                    node.getChildCount();
                    Runnable runnable = new Runnable(this, tree, node){
                        private final /* synthetic */ JTree val$tree;
                        private final /* synthetic */ FileTreeNode val$node;
                        private final /* synthetic */ Queue this$0;
                        {
                            this.this$0 = this$0;
                            this.val$tree = val$tree;
                            this.val$node = val$node;
                        }

                        public void run() {
                            ((DefaultTreeModel)this.val$tree.getModel()).nodeChanged(this.val$node);
                            this.val$tree.repaint();
                        }
                    };
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    item = this.lock;
                    synchronized (item) {
                        this.lock.wait(5000L);
                    }
                    if (this.nodes.size() != 0) continue;
                    this.running = false;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected class WindowsFileView
    extends BasicFileChooserUI.BasicFileView {
        protected WindowsFileView() {
            super(WindowsDirectoryChooserUI.this);
        }

        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            if (f != null) {
                icon = WindowsDirectoryChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(f);
            }
            if (icon == null) {
                icon = super.getIcon(f);
            }
            this.cacheIcon(f, icon);
            return icon;
        }
    }

    private class FileTreeNode
    extends LazyMutableTreeNode
    implements Comparable {
        public FileTreeNode(File file) {
            super(file);
        }

        public boolean canEnqueue() {
            return !this.isLoaded() && !WindowsDirectoryChooserUI.this.chooser.getFileSystemView().isFloppyDrive(this.getFile()) && !WindowsDirectoryChooserUI.this.chooser.getFileSystemView().isFileSystemRoot(this.getFile());
        }

        public boolean isLeaf() {
            if (!this.isLoaded()) {
                return false;
            }
            return super.isLeaf();
        }

        protected void loadChildren() {
            FileTreeNode[] nodes = this.getChildren();
            int c = nodes.length;
            for (int i = 0; i < c; ++i) {
                this.add(nodes[i]);
            }
        }

        private FileTreeNode[] getChildren() {
            File[] files = WindowsDirectoryChooserUI.this.chooser.getFileSystemView().getFiles(this.getFile(), WindowsDirectoryChooserUI.this.chooser.isFileHidingEnabled());
            ArrayList<FileTreeNode> nodes = new ArrayList<FileTreeNode>();
            if (files != null) {
                int c = files.length;
                for (int i = 0; i < c; ++i) {
                    if (!files[i].isDirectory()) continue;
                    nodes.add(new FileTreeNode(files[i]));
                }
            }
            Object[] result = nodes.toArray(new FileTreeNode[0]);
            Arrays.sort(result);
            return result;
        }

        public File getFile() {
            return (File)this.getUserObject();
        }

        public String toString() {
            return WindowsDirectoryChooserUI.this.chooser.getFileSystemView().getSystemDisplayName((File)this.getUserObject());
        }

        public int compareTo(Object o) {
            if (!(o instanceof FileTreeNode)) {
                return 1;
            }
            return this.getFile().compareTo(((FileTreeNode)o).getFile());
        }

        public void clear() {
            super.clear();
            ((DefaultTreeModel)WindowsDirectoryChooserUI.this.tree.getModel()).nodeStructureChanged(this);
        }
    }

    private class MyComputerTreeNode
    extends LazyMutableTreeNode {
        public MyComputerTreeNode(FileSystemView fsv) {
            super(fsv);
        }

        protected void loadChildren() {
            FileSystemView fsv = (FileSystemView)this.getUserObject();
            Object[] roots = fsv.getRoots();
            if (roots != null) {
                Arrays.sort(roots);
                int c = roots.length;
                for (int i = 0; i < c; ++i) {
                    this.add(new FileTreeNode((File)roots[i]));
                }
            }
        }

        public String toString() {
            return "/";
        }
    }

    private class FileSystemTreeModel
    extends DefaultTreeModel {
        public FileSystemTreeModel(FileSystemView fsv) {
            super(new MyComputerTreeNode(fsv), false);
        }
    }

    private class FileSystemTreeRenderer
    extends DefaultTreeCellRenderer {
        private FileSystemTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, false, row, hasFocus);
            if (value instanceof FileTreeNode) {
                FileTreeNode node = (FileTreeNode)value;
                this.setText(WindowsDirectoryChooserUI.this.getFileView(WindowsDirectoryChooserUI.this.chooser).getName(node.getFile()));
                if (!OS.isMacOSX() || !UIManager.getLookAndFeel().isNativeLookAndFeel()) {
                    this.setIcon(WindowsDirectoryChooserUI.this.getFileView(WindowsDirectoryChooserUI.this.chooser).getIcon(node.getFile()));
                }
            }
            return this;
        }
    }

    private class TreeExpansion
    implements TreeExpansionListener {
        private TreeExpansion() {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Object lastElement;
            if (event.getPath() != null && (lastElement = event.getPath().getLastPathComponent()) instanceof FileTreeNode && WindowsDirectoryChooserUI.this.useNodeQueue && ((FileTreeNode)lastElement).isLoaded()) {
                Enumeration<TreeNode> e = ((FileTreeNode)lastElement).children();
                while (e.hasMoreElements()) {
                    WindowsDirectoryChooserUI.addToQueue((FileTreeNode)e.nextElement(), WindowsDirectoryChooserUI.this.tree);
                }
            }
        }
    }

    private class ApproveSelectionAction
    extends AbstractAction {
        public ApproveSelectionAction() {
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            WindowsDirectoryChooserUI.this.setSelectedFiles();
            WindowsDirectoryChooserUI.this.chooser.approveSelection();
        }
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            WindowsDirectoryChooserUI.this.getApproveSelectionAction().setEnabled(WindowsDirectoryChooserUI.this.tree.getSelectionCount() > 0);
            WindowsDirectoryChooserUI.this.setSelectedFiles();
        }
    }

    private class ChangeListener
    implements PropertyChangeListener {
        private ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("ApproveButtonTextChangedProperty".equals(evt.getPropertyName())) {
                WindowsDirectoryChooserUI.this.updateView(WindowsDirectoryChooserUI.this.chooser);
            }
            if ("MultiSelectionEnabledChangedProperty".equals(evt.getPropertyName())) {
                if (WindowsDirectoryChooserUI.this.chooser.isMultiSelectionEnabled()) {
                    WindowsDirectoryChooserUI.this.tree.getSelectionModel().setSelectionMode(4);
                } else {
                    WindowsDirectoryChooserUI.this.tree.getSelectionModel().setSelectionMode(1);
                }
            }
            if ("directoryChanged".equals(evt.getPropertyName())) {
                WindowsDirectoryChooserUI.this.findFile(WindowsDirectoryChooserUI.this.chooser.getCurrentDirectory(), false, false);
            }
            if ("AccessoryChangedProperty".equals(evt.getPropertyName())) {
                Component oldValue = (Component)evt.getOldValue();
                Component newValue = (Component)evt.getNewValue();
                if (oldValue != null) {
                    WindowsDirectoryChooserUI.this.chooser.remove(oldValue);
                }
                if (newValue != null) {
                    WindowsDirectoryChooserUI.this.chooser.add("North", newValue);
                }
                WindowsDirectoryChooserUI.this.chooser.revalidate();
                WindowsDirectoryChooserUI.this.chooser.repaint();
            }
            if ("ControlButtonsAreShownChangedProperty".equals(evt.getPropertyName())) {
                WindowsDirectoryChooserUI.this.updateView(WindowsDirectoryChooserUI.this.chooser);
            }
        }
    }
}

