/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERUtil;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

interface Any {
    public DER asDER();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Atomic<T>
    implements Any,
    Serializable {
        public static final Factory<Atomic<int[]>> OID_FACTORY = new Factory<Atomic<int[]>>(){

            @Override
            public Atomic<int[]> cast(DER der) {
                return Atomic.createOID(der);
            }
        };
        public static final Factory<Atomic<String>> UT8STRING_FACTORY = new Factory<Atomic<String>>(){

            @Override
            public Atomic<String> cast(DER der) {
                return Atomic.createUT8String(der);
            }
        };
        public static final Factory<Atomic<String>> IA5STRING_FACTORY = new Factory<Atomic<String>>(){

            @Override
            public Atomic<String> cast(DER der) {
                return Atomic.createIA5String(der);
            }
        };
        public static final Factory<Atomic<byte[]>> OCTET_STRING_FACTORY = new Factory<Atomic<byte[]>>(){

            @Override
            public Atomic<byte[]> cast(DER der) {
                return Atomic.createOctetString(der);
            }
        };

        public static Atomic<int[]> createOID(int[] b) {
            return Atomic.createOID(new DER(b));
        }

        public static Atomic<int[]> createOID(final DER der) {
            DERUtil.checkType(der, -6);
            return new Atomic<int[]>(){

                @Override
                public DER asDER() {
                    return der;
                }

                @Override
                public int[] get() {
                    return (int[])der.getContent();
                }
            };
        }

        public static Atomic<String> createUT8String(String str) {
            return Atomic.createUT8String(new DER(str));
        }

        public static Atomic<String> createUT8String(final DER der) {
            DERUtil.checkType(der, -12);
            return new Atomic<String>(){

                @Override
                public DER asDER() {
                    return der;
                }

                @Override
                public String get() {
                    return (String)((Object)der.getContent());
                }
            };
        }

        public static Atomic<String> createIA5String(String str) {
            return Atomic.createIA5String(new DER(-22, str));
        }

        public static Atomic<String> createIA5String(final DER der) {
            DERUtil.checkType(der, -22);
            return new Atomic<String>(){

                @Override
                public DER asDER() {
                    return der;
                }

                @Override
                public String get() {
                    return (String)((Object)der.getContent());
                }
            };
        }

        public static Atomic<byte[]> createOctetString(byte[] b) {
            return Atomic.createOctetString(new DER(b));
        }

        public static Atomic<byte[]> createOctetString(final DER der) {
            DERUtil.checkType(der, -4);
            return new Atomic<byte[]>(){

                @Override
                public DER asDER() {
                    return der;
                }

                @Override
                public byte[] get() {
                    return (byte[])der.getContent();
                }
            };
        }

        public abstract T get();

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof Atomic) {
                return this.asDER().equals(((Atomic)obj).asDER());
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.asDER().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory<T extends Any> {
        public T cast(DER var1);
    }

    public static class Null
    implements Any,
    Serializable {
        public static final Null INSTANCE = new Null();
        private static final DER NULL = new DER();
        public static final Factory<Null> FACTORY = new Factory<Null>(){

            @Override
            public Null cast(DER der) {
                if (der.getType() != -5) {
                    throw new TypeMismatchException("DER " + der + " is not a NULL DER");
                }
                return INSTANCE;
            }
        };

        private Null() {
        }

        public DER asDER() {
            return NULL;
        }
    }
}

