/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.AnyCollection;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERUtil;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnySequence<T extends Any>
extends AbstractList<T>
implements AnyCollection<T>,
List<T>,
Serializable {
    private final DER der;
    private final List<T> list;

    public AnySequence(T ... members) {
        this(members != null ? Arrays.asList(members) : null);
    }

    public AnySequence(List<? extends T> members) {
        int count = members != null ? members.size() : 0;
        ArrayList<DER> derlist = new ArrayList<DER>(count);
        int i = 0;
        while (i < count) {
            derlist.add(((Any)members.get(i)).asDER());
            ++i;
        }
        this.list = Collections.unmodifiableList(new ArrayList<T>(members));
        this.der = new DER(derlist);
    }

    private AnySequence(List<T> members, DER der) {
        this.list = members;
        this.der = der;
    }

    @Override
    public final T get(int i) {
        return (T)((Any)this.list.get(i));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public final DER asDER() {
        return this.der;
    }

    @Override
    public boolean equals(Object obj) {
        return DERUtil.equals(this, obj);
    }

    @Override
    public int hashCode() {
        return DERUtil.hashCode(this);
    }

    public static final <T extends Any> AnySequence<T> cast(DER der, Any.Factory<? extends T> factory, int min, int max) {
        DERUtil.checkType(der, -16);
        List ders = (List)((Object)der.getContent());
        if (ders.size() < min || max >= 0 && ders.size() > max) {
            throw new TypeMismatchException("The sequence DER " + der + " is not of the required size.");
        }
        ArrayList<T> list = new ArrayList<T>(ders.size());
        int i = 0;
        while (i < ders.size()) {
            try {
                list.add(factory.cast((DER)ders.get(i)));
            }
            catch (TypeMismatchException ex) {
                TypeMismatchException sub = new TypeMismatchException("The component " + i + " of the sequence is not of the expected type.");
                sub.initCause(ex);
                throw sub;
            }
            ++i;
        }
        return new AnySequence(Collections.unmodifiableList(list), der);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<T extends Any>
    implements Serializable {
        private final List<T> list;

        public Builder() {
            this.list = new ArrayList<T>();
        }

        public Builder(Builder<? extends T> builder) {
            this.list = new ArrayList<T>((Collection)builder.list);
        }

        public Builder<T> add(T obj) {
            this.list.add(obj);
            return this;
        }

        public int size() {
            return this.list.size();
        }

        public AnySequence<T> build() {
            return new AnySequence<T>(this.list);
        }
    }
}

