/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.SortedSet;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.Sequence;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Attribute
extends AbstractAny
implements Serializable {
    public static final Any.Factory<Attribute> FACTORY = new Any.Factory<Attribute>(){

        @Override
        public Attribute cast(DER der) {
            return Attribute.cast(der);
        }
    };
    private final DER type;
    private final DER value;
    protected DER der;

    public int[] getType() {
        return (int[])this.type.getContent();
    }

    public SortedSet<DER> getValue() {
        return (SortedSet)((Object)this.value.getContent());
    }

    public DER getDERValue() {
        return this.value;
    }

    public Attribute(int[] type, SortedSet<DER> values) {
        this(new DER(type), values);
    }

    public Attribute(DER type, SortedSet<DER> values) {
        this(type, new DER(values));
    }

    public Attribute(DER type, DER values) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        if (type.getType() != -6) {
            throw new IllegalArgumentException("type must not be an OID");
        }
        if (values.getType() != -17) {
            throw new IllegalArgumentException("values must be a SET");
        }
        if (((Set)((Object)values.getContent())).isEmpty()) {
            throw new IllegalArgumentException("values must not be empty");
        }
        this.type = type;
        this.value = values;
    }

    private DER createDER() {
        ArrayList<DER> list = new ArrayList<DER>();
        list.add(this.type);
        list.add(this.value);
        return new DER(list);
    }

    @Override
    public final DER asDER() {
        if (this.der == null) {
            this.der = this.createDER();
        }
        return this.der;
    }

    public static Attribute cast(DER der) {
        Sequence seq = Sequence.cast(der, 2, 2);
        if (seq != null && seq.get(0).getType() == -6 && seq.get(1).getType() == -17 && ((SortedSet)((Object)seq.get(1).getContent())).size() != 0) {
            return new Attribute(seq.get(0), seq.get(1));
        }
        throw new TypeMismatchException("The " + der + " der is not an Attribute.");
    }
}

