/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.Sequence;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

class AttributeTypeAndValue
extends AbstractAny
implements Serializable {
    public static final Any.Factory<AttributeTypeAndValue> FACTORY = new Any.Factory<AttributeTypeAndValue>(){

        @Override
        public AttributeTypeAndValue cast(DER der) {
            return AttributeTypeAndValue.cast(der);
        }
    };
    private final DER type;
    private final DER value;
    private Sequence sequence;

    public AttributeTypeAndValue(DER type, DER value) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (type.getType() != -6) {
            throw new IllegalArgumentException("type");
        }
        this.type = type;
        this.value = value;
    }

    public AttributeTypeAndValue(int[] type, DER value) {
        this(new DER(type), value);
    }

    public DER getType() {
        return this.type;
    }

    public DER getValue() {
        return this.value;
    }

    public DER asDER() {
        if (this.sequence == null) {
            this.sequence = new Sequence(this.type, this.value);
        }
        return this.sequence.asDER();
    }

    public static final AttributeTypeAndValue cast(DER der) {
        Sequence seq = Sequence.cast(der, 2, 2);
        if (seq != null && seq.get(0).getType() == -6) {
            AttributeTypeAndValue a = new AttributeTypeAndValue(seq.get(0), seq.get(1));
            a.sequence = seq;
            return a;
        }
        throw new TypeMismatchException("The " + der + " der is not an AttributeTypeAndValue.");
    }
}

