/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.AlgorithmIdentifier;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.AnyCollection;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERException;
import lu.luxtrust.pkix.pkcs.p7.Sequence;
import lu.luxtrust.pkix.pkcs.p7.TBSCertificate;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

class Certificate
extends AbstractAny
implements Serializable {
    public static final AnyCollection.Converter<Certificate, X509Certificate> CONVERTER = new CertificateConverter();
    public static final Any.Factory<Certificate> FACTORY = new Any.Factory<Certificate>(){

        @Override
        public Certificate cast(DER der) {
            return Certificate.cast(der);
        }
    };
    private final TBSCertificate tbsCertificate;
    private final AlgorithmIdentifier signatureAlgorithm;
    private final DER signature;
    private Sequence sequence;

    private Certificate(TBSCertificate tbsCertificate, DER signatureValue) {
        if (tbsCertificate == null) {
            throw new NullPointerException("The tbs certificate must not be null.");
        }
        if (signatureValue == null) {
            throw new NullPointerException("signatureValue");
        }
        this.tbsCertificate = tbsCertificate;
        this.signatureAlgorithm = tbsCertificate.getSignature();
        this.signature = signatureValue;
    }

    public DER asDER() {
        if (this.sequence == null) {
            this.sequence = new Sequence(this.tbsCertificate.asDER(), this.signatureAlgorithm.asDER(), this.signature);
        }
        return this.sequence.asDER();
    }

    public String toString() {
        return this.getTBSCertificate().getSubject().toString();
    }

    public Certificate(TBSCertificate tbsCertificate, byte[] signatureValue) throws DERException {
        this(tbsCertificate, new DER(DER.binaryToBitString(signatureValue), signatureValue.length << 3));
    }

    public TBSCertificate getTBSCertificate() {
        return this.tbsCertificate;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public DER getSignatureValue() {
        return this.signature;
    }

    public X509Certificate toX509Certificate() {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream stream = new ByteArrayInputStream(this.asDER().encode());
            return (X509Certificate)cf.generateCertificate(stream);
        }
        catch (CertificateException ex) {
            UnsupportedOperationException sub = new UnsupportedOperationException("No factory support for the X.509 cerificates available.");
            sub.initCause(ex);
            throw sub;
        }
        catch (TypeMismatchException ex) {
            UnsupportedOperationException sub = new UnsupportedOperationException("No suitable factory support for the X.509 cerificates available.");
            sub.initCause(ex);
            throw sub;
        }
        catch (IOException ex) {
            UnsupportedOperationException sub = new UnsupportedOperationException("Problem during encoding the " + this + " Certificate.");
            sub.initCause(ex);
            throw sub;
        }
    }

    public static final Certificate fromX509Certificate(X509Certificate certificate) {
        if (certificate != null) {
            try {
                byte[] encoded = certificate.getEncoded();
                return Certificate.cast(DER.decode(encoded));
            }
            catch (CertificateEncodingException ex) {
                UnsupportedOperationException sub = new UnsupportedOperationException("No encoding support for the " + certificate + " x509 certificate available.");
                sub.initCause(ex);
                throw sub;
            }
            catch (IOException ex) {
                UnsupportedOperationException sub = new UnsupportedOperationException("No encoding support for the " + certificate + " x509 certificate available.");
                sub.initCause(ex);
                throw sub;
            }
            catch (TypeMismatchException ex) {
                UnsupportedOperationException sub = new UnsupportedOperationException("No encoding support for the " + certificate + " x509 certificate available.");
                sub.initCause(ex);
                throw sub;
            }
        }
        return null;
    }

    public static final Certificate cast(DER der) {
        Sequence seq = Sequence.cast(der, 3, 3);
        if (seq.get(2).getType() == -3) {
            TBSCertificate tbsCertificate = TBSCertificate.cast(seq.get(0));
            AlgorithmIdentifier signature = AlgorithmIdentifier.cast(seq.get(1));
            if (signature.asDER().equals(tbsCertificate.getSignature().asDER())) {
                Certificate cert = new Certificate(tbsCertificate, seq.get(2));
                cert.sequence = seq;
                return cert;
            }
            throw new TypeMismatchException("The " + der + " der Certificate siganture algorithm does si not equal the signature of its TBSCertificate.");
        }
        throw new TypeMismatchException("The " + der + " der is not a suppported Certificate.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CertificateConverter
    implements AnyCollection.Converter<Certificate, X509Certificate>,
    Serializable {
        private CertificateConverter() {
        }

        @Override
        public X509Certificate convert(Certificate any) {
            return any.toX509Certificate();
        }
    }
}

