/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import lu.luxtrust.pkix.pkcs.p7.BER;
import lu.luxtrust.pkix.pkcs.p7.BERException;
import lu.luxtrust.pkix.pkcs.p7.DERException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DER
implements Comparable<DER> {
    public static final int BOOLEAN = -1;
    public static final int INTEGER = -2;
    public static final int BIT_STRING = -3;
    public static final int OCTET_STRING = -4;
    public static final int NULL = -5;
    public static final int OBJECT_IDENTIFIER = -6;
    public static final int ENUMERATED = -10;
    public static final int UT8_STRING = -12;
    public static final int RELATIVE_OBJECT_IDENTIFIER = -13;
    public static final int SEQUENCE = -16;
    public static final int SET = -17;
    public static final int NUMERIC_STRING = -18;
    public static final int PRINTABLE_STRING = -19;
    public static final int T61_STRING = -20;
    public static final int IA5_STRING = -22;
    public static final int UTC_TIME = -23;
    public static final int GENERALIZED_TIME = -24;
    public static final int VISIBLE_STRING = -26;
    public static final int GENERAL_STRING = -27;
    public static final int UNIVERSAL_STRING = -28;
    public static final int BMP_STRING = -30;
    private static final String ISO = "ISO-8859-1";
    private static final String UT8 = "UTF-8";
    private static final String BMP = "UTF-16";
    private static final int ANY = -1;
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Date GENERAL;
    private final int type;
    private final Serializable content;
    private final boolean strict;

    static {
        Calendar gmt = Calendar.getInstance(new SimpleTimeZone(0, "Z"));
        gmt.set(2050, 0, 1, 0, 0, 0);
        GENERAL = gmt.getTime();
    }

    public static BitSet binaryToBitString(byte[] binary) {
        MemoSet bs = new MemoSet(binary.length, 0);
        int i = 0;
        while (i < binary.length) {
            byte b = binary[i];
            int p = 128;
            int k = i << 3;
            int j = 0;
            while (j < 8) {
                if ((b & p) != 0) {
                    bs.set(k + j);
                }
                p >>= 1;
                ++j;
            }
            ++i;
        }
        return bs;
    }

    public static byte[] bitStringToBinary(BitSet string) {
        int size = string.size() << 3;
        if (string instanceof MemoSet) {
            size = ((MemoSet)string).size;
        }
        byte[] binary = new byte[size];
        int i = 0;
        while (i < binary.length) {
            int p = 128;
            int k = i << 3;
            int j = 0;
            while (j < 8) {
                if (string.get(k + j)) {
                    int n = i;
                    binary[n] = (byte)(binary[n] | p);
                }
                p >>= 1;
                ++j;
            }
            ++i;
        }
        return binary;
    }

    private static final void checkPrimitive(BER ber, int type, boolean strict) throws DERException {
        if (strict && ber.isConstructed()) {
            throw new DERException("A " + type + " DER type must be primitive.");
        }
    }

    private static final void checkConstructed(BER ber, int type, boolean strict) throws DERException {
        if (strict && !ber.isConstructed()) {
            throw new DERException("A " + type + " DER type must be constructed.");
        }
    }

    private static Date checkUtc(Date date) throws DERException {
        int millis = DER.millisOf(date);
        if (GENERAL.after(date) && millis == 0) {
            return date;
        }
        throw new DERException("The date cannot be represented as UTC.");
    }

    private static final String nameOf(Object object) {
        return object != null ? "a " + object.getClass().getName() : "null";
    }

    private static final int millisOf(Date date) {
        int m = (int)(date.getTime() % 1000L);
        return m < 0 ? m + 1000 : m;
    }

    private static final byte[] contentBytesOf(BER ber, int length) throws IOException {
        BigInteger len = ber.getLength();
        if (len.signum() < 0) {
            throw new DERException("Illegal indefinite length format detected.");
        }
        if (length < 0) {
            if (len.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                throw new DERException("Unsupported huge length detected.");
            }
            length = len.intValue();
        } else if (len.compareTo(BigInteger.valueOf(length)) != 0) {
            throw new DERException("Incorrect " + len + " length instead of " + length + " detected.");
        }
        byte[] b = new byte[length];
        if (length > 0) {
            InputStream encoded = ber.getContent();
            int p = 0;
            while (p < length) {
                int k = encoded.read(b, p, length - p);
                if (k < 1) {
                    throw new DERException("Premature end of content detected after " + p + " of " + length + " octets read.");
                }
                p += k;
            }
        }
        return b;
    }

    private static final byte[] contentBytesOf(BER ber) throws IOException {
        return DER.contentBytesOf(ber, -1);
    }

    private static final BitSet copyOf(BitSet content, int length) {
        if (content.length() > length) {
            throw new IllegalArgumentException("BIT STRING length must be at least the length of the bit set");
        }
        int size = (length + 7) / 8;
        int pad = (size << 3) - length;
        if (content instanceof MemoSet) {
            size = ((MemoSet)content).size;
            pad = ((MemoSet)content).pad;
        }
        MemoSet argument = new MemoSet(size, pad);
        argument.or(content);
        return argument;
    }

    private static final char[] copyOf(char[] content) {
        char[] argument = (char[])content.clone();
        int count = argument.length >> 1;
        if (count << 1 != argument.length) {
            throw new IllegalArgumentException("Invalid universal string length detected.");
        }
        return argument;
    }

    private static final boolean isTagged(int type) {
        return type >= 0;
    }

    private static final byte[] asCheckedOctet(Serializable content) throws DERException {
        if (!(content instanceof byte[])) {
            throw new DERException("Octet string required for reverting a primitive tagged type instead of " + DER.nameOf(content) + ".");
        }
        return (byte[])content;
    }

    private static int[] asCheckedOid(int[] oid, boolean relative) {
        if (oid.length == 0) {
            throw new IllegalArgumentException("OID must have at least one subidentifier");
        }
        int start = 0;
        if (!relative) {
            if (oid[0] < 0 || oid[0] > 2) {
                throw new IllegalArgumentException("First subidentifier must be 0, 1 or 2");
            }
            if (oid.length > 1 && (oid[1] < 0 || oid[1] > 39)) {
                throw new IllegalArgumentException("Second subidentifier must be between 0 and 39 (inclusive)");
            }
            start = 2;
        }
        int i = start;
        while (i < oid.length) {
            if (oid[i] < 0) {
                throw new IllegalArgumentException("Subidentifier " + (i - 1) + " must be non-negative");
            }
            ++i;
        }
        return oid;
    }

    private static final Object asCheckedNonNull(Object content) throws NullPointerException {
        if (content == null) {
            throw new NullPointerException("Content must not be null.");
        }
        return content;
    }

    private static final String asCheckeddString(String content, int type, boolean strict) {
        switch (type) {
            case -12: {
                return content;
            }
            case -18: {
                if (strict) {
                    int i = 0;
                    while (i < content.length()) {
                        if ("01234567890 ".indexOf(content.charAt(i)) < 0) {
                            throw new IllegalArgumentException("Invalid character in numeric string detected.");
                        }
                        ++i;
                    }
                }
                return content;
            }
            case -19: {
                if (strict) {
                    int i = 0;
                    while (i < content.length()) {
                        char c = content.charAt(i);
                        if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz01234567890 '()+,-./:=?".indexOf(c) < 0) {
                            throw new IllegalArgumentException("Invalid 0x" + Integer.toString(c, 16) + " character in printable string detected.");
                        }
                        ++i;
                    }
                }
                return content;
            }
            case -20: {
                return content;
            }
            case -22: {
                if (strict) {
                    int i = 0;
                    while (i < content.length()) {
                        char c = content.charAt(i);
                        if (c > '\u007f') {
                            throw new IllegalArgumentException("Invalid 0x" + Integer.toString(c, 16) + " character in ia5 string detected.");
                        }
                        ++i;
                    }
                }
                return content;
            }
            case -26: {
                int i = 0;
                while (i < content.length()) {
                    char c = content.charAt(i);
                    if (c < ' ' || c > '~') {
                        throw new IllegalArgumentException("Invalid 0x" + Integer.toString(c, 16) + " character in visible string detected.");
                    }
                    ++i;
                }
                return content;
            }
            case -27: {
                return content;
            }
            case -30: {
                return content;
            }
        }
        throw new IllegalArgumentException("Supported string type argument required instead of " + type + ".");
    }

    private static final Serializable asSortedSet(Collection<?> content, boolean checked) {
        TreeSet<DER> argument = new TreeSet<DER>();
        for (Object element : content) {
            if (checked && !(element instanceof DER)) {
                throw new IllegalArgumentException("Set component must be a DER instead of " + DER.nameOf(element) + ".");
            }
            argument.add((DER)element);
        }
        return (Serializable)((Object)Collections.unmodifiableSortedSet(argument));
    }

    private static final Serializable asList(Collection<?> content, boolean checked) {
        ArrayList<DER> argument = new ArrayList<DER>(content.size());
        for (Object element : content) {
            if (checked && !(element instanceof DER)) {
                throw new IllegalArgumentException("List component must be a DER instead of " + DER.nameOf(element) + ".");
            }
            argument.add((DER)element);
        }
        return (Serializable)((Object)Collections.unmodifiableList(argument));
    }

    private DER(int type, Serializable content, boolean strict) {
        this.type = type;
        this.content = content;
        this.strict = strict;
    }

    public DER() {
        this(-5, null, true);
    }

    private DER(Date content, boolean isUtcTime, boolean strict) {
        this(isUtcTime ? -23 : -24, content, strict);
    }

    public DER(Date content) {
        this(new Date(((Date)DER.asCheckedNonNull(content)).getTime()), GENERAL.after(content) && DER.millisOf(content) == 0, true);
    }

    public DER(Date content, boolean utc) throws DERException {
        this(utc ? DER.checkUtc(new Date(((Date)DER.asCheckedNonNull(content)).getTime())) : new Date(((Date)DER.asCheckedNonNull(content)).getTime()), utc, true);
    }

    public DER(Boolean content) {
        this(-1, (Boolean)DER.asCheckedNonNull(content), true);
    }

    public DER(boolean content) {
        this((Boolean)content);
    }

    public DER(BigInteger content, boolean enumerated) {
        this(enumerated ? -10 : -2, new BigInteger(((BigInteger)DER.asCheckedNonNull(content)).toByteArray()), true);
    }

    public DER(BigInteger content) {
        this(content, false);
    }

    public DER(int content, boolean enumerated) {
        this(enumerated ? -10 : -2, BigInteger.valueOf(content), true);
    }

    public DER(int content) {
        this(content, false);
    }

    public DER(BitSet content) {
        this(content, content.length());
    }

    public DER(BitSet content, int length) {
        this(-3, DER.copyOf((BitSet)DER.asCheckedNonNull(content), length), true);
    }

    public DER(byte[] content) {
        this(-4, (Serializable)((byte[])((byte[])DER.asCheckedNonNull(content)).clone()), true);
    }

    public DER(DER content) throws IOException {
        this(-4, (Serializable)content.encode(), true);
    }

    public DER(List<? extends DER> content) {
        this(-16, DER.asList((List)DER.asCheckedNonNull(content), true), true);
    }

    public DER(SortedSet<? extends DER> content) {
        this(-17, DER.asSortedSet((SortedSet)DER.asCheckedNonNull(content), true), true);
    }

    public DER(int type, boolean explicit, DER content) throws DERException {
        this(type, DER.isTagged(type) ? (explicit ? DER.asExplicite(content) : DER.asImplicite(content)) : DER.asUntagged(type, content), content.strict);
    }

    public DER(int type, DER content) throws DERException {
        this(type, true, content);
    }

    public DER(int type, String content) {
        this(type, (Serializable)((Object)DER.asCheckeddString((String)DER.asCheckedNonNull(content), type, true)), true);
    }

    public DER(String content) {
        this(-12, content);
    }

    public DER(char[] content) {
        this(-28, (Serializable)DER.copyOf((char[])DER.asCheckedNonNull(content)), true);
    }

    public DER(int[] content, boolean relative) {
        this(relative ? -13 : -6, (Serializable)DER.asCheckedOid((int[])((int[])DER.asCheckedNonNull(content)).clone(), relative), true);
    }

    public DER(int[] content) {
        this(content, false);
    }

    public final int getType() {
        return this.type;
    }

    public final Serializable getContent() {
        switch (this.type) {
            case -5: 
            case -2: 
            case -1: {
                return this.content;
            }
            case -3: {
                return (BitSet)((BitSet)this.content).clone();
            }
            case -24: 
            case -23: {
                return (Date)((Date)this.content).clone();
            }
            case -4: {
                return (byte[])((byte[])this.content).clone();
            }
            case -13: 
            case -6: {
                return (int[])((int[])this.content).clone();
            }
            case -30: 
            case -27: 
            case -26: 
            case -22: 
            case -20: 
            case -19: 
            case -18: 
            case -17: 
            case -16: 
            case -12: {
                return this.content;
            }
            case -28: {
                return (char[])((char[])this.content).clone();
            }
        }
        if (this.content instanceof byte[]) {
            return (byte[])((byte[])this.content).clone();
        }
        return this.content;
    }

    public String toString() {
        if (this.content != null) {
            if (this.content instanceof int[]) {
                int[] id = (int[])this.content;
                StringBuffer oid = new StringBuffer();
                int i = 0;
                while (i < id.length) {
                    if (i > 0) {
                        oid.append('.');
                    }
                    oid.append(String.valueOf(id[i]));
                    ++i;
                }
                return oid.toString();
            }
            if (this.content instanceof byte[]) {
                byte[] b = (byte[])this.content;
                StringBuffer octets = new StringBuffer(b.length * 3);
                int i = 0;
                while (i < b.length) {
                    if (i > 0) {
                        octets.append(' ');
                    }
                    String hex = Integer.toHexString(b[i] & 0xFF).toUpperCase();
                    int k = 0;
                    while (k < 2 - hex.length()) {
                        octets.append('0');
                        ++k;
                    }
                    octets.append(hex);
                    ++i;
                }
                return octets.toString();
            }
            if (this.content instanceof char[]) {
                char[] c = (char[])this.content;
                StringBuffer hextets = new StringBuffer(c.length * 5);
                int i = 0;
                while (i < c.length) {
                    if (i > 0) {
                        hextets.append(' ');
                    }
                    String hex = Long.toHexString(c[i] & 0xFFFF).toUpperCase();
                    int k = 0;
                    while (k < 2 - hex.length()) {
                        hextets.append('0');
                        ++k;
                    }
                    hextets.append(hex);
                    ++i;
                }
                return hextets.toString();
            }
            return this.content.toString();
        }
        return null;
    }

    private static final void printTo(PrintStream out, int indentation) {
        int i = 0;
        while (i < indentation) {
            out.print(' ');
            ++i;
        }
    }

    private static final void printTo(DER element, PrintStream out, int indentation) {
        DER.printTo(out, indentation);
        if (DER.isTagged(element.type)) {
            out.print('[');
            out.print(element.type);
            out.print(']');
        } else {
            switch (element.type) {
                case -1: {
                    out.print("BOOLEAN");
                    break;
                }
                case -2: {
                    out.print("INTEGER");
                    break;
                }
                case -3: {
                    out.print("BIT STRING");
                    break;
                }
                case -4: {
                    out.print("OCTET STRING");
                    break;
                }
                case -5: {
                    out.print("NULL");
                    break;
                }
                case -6: {
                    out.print("OBJECT IDENTIFIER");
                    break;
                }
                case -10: {
                    out.print("ENUMERATED");
                    break;
                }
                case -12: {
                    out.print("UT8String");
                    break;
                }
                case -13: {
                    out.print("RELATIVE-OID");
                    break;
                }
                case -16: {
                    out.print("SEQUENCE");
                    break;
                }
                case -17: {
                    out.print("SET");
                    break;
                }
                case -18: {
                    out.print("NumericString");
                    break;
                }
                case -19: {
                    out.print("PrintableString");
                    break;
                }
                case -20: {
                    out.print("T61String");
                    break;
                }
                case -22: {
                    out.print("IA5String");
                    break;
                }
                case -23: {
                    out.print("UTCTime");
                    break;
                }
                case -24: {
                    out.print("GeneralizedTime");
                    break;
                }
                case -26: {
                    out.print("VisibleString");
                    break;
                }
                case -27: {
                    out.print("GeneralString");
                    break;
                }
                case -28: {
                    out.print("UniversalString");
                    break;
                }
                case -30: {
                    out.print("BMPString");
                    break;
                }
                default: {
                    out.print("UNKNOWN");
                }
            }
        }
        out.print(' ');
        Serializable next = element.content;
        if (next instanceof Collection) {
            out.println('{');
            Iterator i = ((Collection)((Object)next)).iterator();
            while (i.hasNext()) {
                DER.printTo((DER)i.next(), out, indentation + 1);
            }
            DER.printTo(out, indentation);
            out.println('}');
        } else {
            out.println(element.toString());
        }
    }

    public void printTo(PrintStream out) {
        if (out != null) {
            DER.printTo(this, out, 0);
        }
    }

    private static final Serializable asUntagged(int type, DER der) throws DERException {
        if (!DER.isTagged(((DER)DER.asCheckedNonNull((Object)der)).type)) {
            throw new DERException("Tagged type required for reverting tagging instead of a " + der.type + " DER.");
        }
        switch (type) {
            case -1: {
                byte[] a = DER.asCheckedOctet(der.content);
                return Boolean.valueOf(a.length > 0 && a[0] != 0);
            }
            case -10: 
            case -2: {
                return new BigInteger(DER.asCheckedOctet(der.content));
            }
            case -3: {
                return DER.fromBitString(DER.asCheckedOctet(der.content));
            }
            case -4: {
                return DER.asCheckedOctet(der.content);
            }
            case -5: {
                int len = DER.asCheckedOctet(der.content).length;
                if (len > 0) {
                    throw new DERException("Inccorect length " + len + " detected for null type.");
                }
                return null;
            }
            case -6: {
                return DER.fromOIDString(DER.asCheckedOctet(der.content), true);
            }
            case -12: {
                try {
                    return DER.asCheckeddString(new String(DER.asCheckedOctet(der.content), UT8), type, der.strict);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new DERException("Missing support for the UTF-8 character encoding", ex);
                }
            }
            case -13: {
                return DER.fromOIDString(DER.asCheckedOctet(der.content), false);
            }
            case -16: {
                if (!(der.content instanceof Collection)) {
                    throw new DERException("Coletcion required for reverting a constructed tagged type (SEQUENCE) instead of " + DER.nameOf(der.content) + ".");
                }
                return DER.asList((Collection)((Object)der.content), false);
            }
            case -17: {
                if (!(der.content instanceof Collection)) {
                    throw new DERException("Coletcion required for reverting a constructed tagged type (SET) instead of " + DER.nameOf(der.content) + ".");
                }
                return DER.asSortedSet((Collection)((Object)der.content), false);
            }
            case -27: 
            case -26: 
            case -22: 
            case -20: 
            case -19: 
            case -18: {
                try {
                    return DER.asCheckeddString(new String(DER.asCheckedOctet(der.content), ISO), type, der.strict);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new DERException("Missing support for the ISO-8859-1 character encoding", ex);
                }
            }
            case -28: {
                return DER.fromUniversalString(DER.asCheckedOctet(der.content));
            }
            case -23: {
                byte[] b = DER.asCheckedOctet(der.content);
                if (der.strict && b.length != 13) {
                    throw new DERException("Inccorect length " + b.length + " detected for utc time type.");
                }
                return DER.fromDateString(b, false, der.strict);
            }
            case -24: {
                return DER.fromDateString(DER.asCheckedOctet(der.content), true, der.strict);
            }
            case -30: {
                try {
                    return DER.asCheckeddString(new String(DER.asCheckedOctet(der.content), BMP), type, der.strict);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new DERException("Missing support for the UTF-16 character encoding", ex);
                }
            }
        }
        throw new DERException("Unsupported tag number " + type + " detected.");
    }

    private static final Serializable asExplicite(DER der) {
        DER entry = (DER)DER.asCheckedNonNull(der);
        return new TaggedCollection(Collections.singletonList(entry));
    }

    private static final Serializable asImplicite(DER der) throws DERException {
        if (DER.isTagged(((DER)DER.asCheckedNonNull((Object)der)).type)) {
            return der.content;
        }
        switch (der.type) {
            case -17: 
            case -16: {
                Collection collection = (Collection)((Object)der.content);
                return new TaggedCollection(collection);
            }
        }
        try {
            return DER.contentBytesOf(BER.decode(der.encode()));
        }
        catch (DERException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new DERException(ex);
        }
    }

    private static final void writeTo(int part, OutputStream out) throws IOException {
        if (part >= 128) {
            if (part >= 16384) {
                if (part >= 0x200000) {
                    if (part >= 0x10000000) {
                        out.write(part >> 28 | 0x80);
                    }
                    out.write(part >> 21 | 0x80);
                }
                out.write(part >> 14 | 0x80);
            }
            out.write(part >> 7 | 0x80);
        }
        out.write(part & 0x7F);
    }

    private static final byte[] toOIDString(int[] oid, boolean absolute) throws IOException {
        ByteArrayOutputStream buffer;
        block5: {
            block4: {
                buffer = new ByteArrayOutputStream();
                if (!absolute) break block4;
                if (oid.length <= 0) break block5;
                int start = oid[0] * 40;
                if (oid.length > 1) {
                    DER.writeTo(start + oid[1], buffer);
                    int i = 2;
                    while (i < oid.length) {
                        DER.writeTo(oid[i], buffer);
                        ++i;
                    }
                } else {
                    DER.writeTo(start, buffer);
                }
                break block5;
            }
            int i = 0;
            while (i < oid.length) {
                DER.writeTo(oid[i], buffer);
                ++i;
            }
        }
        return buffer.toByteArray();
    }

    private static final int[] fromOIDString(byte[] string, boolean absolute) {
        ArrayList<Integer> oid = new ArrayList<Integer>();
        int value = 0;
        boolean start = absolute;
        int i = 0;
        while (i < string.length) {
            int b = string[i] & 0xFF;
            value = value * 128 + (b & 0x7F);
            if ((b & 0x80) == 0) {
                if (start) {
                    switch (value / 40) {
                        case 0: {
                            oid.add(new Integer(0));
                            break;
                        }
                        case 1: {
                            oid.add(new Integer(1));
                            value -= 40;
                            break;
                        }
                        default: {
                            oid.add(new Integer(2));
                            value -= 80;
                        }
                    }
                    start = false;
                }
                oid.add(new Integer(value));
                value = 0;
            }
            ++i;
        }
        int[] result = new int[oid.size()];
        int j = 0;
        while (j < result.length) {
            result[j] = (Integer)oid.get(j);
            ++j;
        }
        return result;
    }

    private static final byte[] toBitString(BitSet bs) {
        int size = (bs.length() + 7) / 8;
        int pad = (size << 3) - bs.length();
        if (bs instanceof MemoSet) {
            MemoSet bx = (MemoSet)bs;
            int count = bx.size;
            if (count > size) {
                size = count;
                pad = bx.pad;
            } else if (count == size) {
                pad = Math.min(bx.pad, pad);
            }
        }
        byte[] result = new byte[1 + size];
        result[0] = (byte)pad;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            int j = i / 8;
            int n = j + 1;
            result[n] = (byte)(result[n] | (byte)(128 >> i - (j << 3)));
            i = bs.nextSetBit(i + 1);
        }
        return result;
    }

    private static final BitSet fromBitString(byte[] string) throws DERException {
        if (string.length > 0) {
            int pad = string[0] & 0xFF;
            if (pad < 0 || pad > 7) {
                throw new DERException("Incorrect initial bitstring octet detected.");
            }
            int count = string.length - 1;
            MemoSet bs = new MemoSet(count, pad);
            int i = 1;
            while (i < string.length) {
                int c = string[i] & 0xFF;
                if (c != 0) {
                    int k = i - 1 << 3;
                    int j = 0;
                    while (j < (i < count ? 8 : 8 - pad)) {
                        if ((c & 0x80) != 0) {
                            bs.set(k + j);
                        }
                        c <<= 1;
                        ++j;
                    }
                }
                ++i;
            }
            return bs;
        }
        throw new DERException("Missing initial bitsring octet detected.");
    }

    private static final byte[] toUniversalString(char[] string) {
        int j = 0;
        byte[] result = new byte[string.length << 1];
        int i = 0;
        while (i < string.length) {
            result[j] = (byte)(string[i] >> 8);
            result[j + 1] = (byte)string[i];
            j += 2;
            ++i;
        }
        return result;
    }

    private static final char[] fromUniversalString(byte[] string) throws DERException {
        int count = string.length >> 1;
        if (count >> 1 << 2 != string.length) {
            throw new DERException("Invalid universal string length detected.");
        }
        int j = 0;
        char[] result = new char[count];
        int i = 0;
        while (i < count) {
            result[i] = (char)(string[j] << 8 | string[j + 1] & 0xFF);
            j += 2;
            ++i;
        }
        return result;
    }

    private static final SimpleDateFormat createFormat(boolean general, TimeZone timezone) {
        boolean standard = timezone == null;
        SimpleDateFormat format = new SimpleDateFormat(String.valueOf(general ? "yy" : "") + "yyMMddHHmmss" + (standard ? "'Z'" : "Z"));
        format.setLenient(false);
        format.setTimeZone(standard ? GMT : timezone);
        return format;
    }

    private static final byte[] toDateString(Date date, boolean general) throws DERException {
        String string;
        if (date instanceof MemoDate) {
            MemoDate memo = (MemoDate)date;
            SimpleDateFormat format = DER.createFormat(general, memo.timezone);
            if (memo.fractal != null) {
                int millis = DER.millisOf(date);
                String essential = format.format(millis > 0 ? new Date(date.getTime() - (long)millis) : date);
                int insert = essential.length() - (memo.timezone != null ? 5 : 1);
                string = String.valueOf(essential.substring(0, insert)) + '.' + memo.fractal + essential.substring(insert);
            } else {
                string = format.format(date);
            }
        } else {
            int millis;
            SimpleDateFormat format = DER.createFormat(general, null);
            int n = millis = general ? DER.millisOf(date) : 0;
            if (millis > 0) {
                String essential = format.format(new Date(date.getTime() - (long)millis));
                String fractal = Integer.toString(millis);
                int length = fractal.length();
                if (length < 3) {
                    fractal = length < 2 ? "00" + fractal : "0" + fractal;
                }
                int insert = essential.length() - 1;
                string = String.valueOf(essential.substring(0, insert)) + '.' + fractal + essential.substring(insert);
            } else {
                string = format.format(date);
            }
        }
        try {
            return string.getBytes(ISO);
        }
        catch (UnsupportedEncodingException ex) {
            throw new DERException("Missing support for the ISO-8859-1 character encoding", ex);
        }
    }

    private static final Date fromDateString(byte[] string, boolean general, boolean strict) throws DERException {
        try {
            String essential;
            int extra;
            String iso = new String(string, ISO);
            String fractal = null;
            int n = extra = general ? iso.indexOf(46) : -1;
            if (extra < 0) {
                essential = iso;
            } else {
                essential = iso.substring(0, extra++);
                int position = iso.length();
                int i = extra;
                while (i < position) {
                    int digit = "0123456789".indexOf(iso.charAt(i));
                    if (digit < 0) {
                        essential = String.valueOf(essential) + iso.substring(i);
                        position = i;
                        break;
                    }
                    ++i;
                }
                fractal = iso.substring(extra, position);
                if (fractal.equals("") || strict && fractal.endsWith("0")) {
                    throw new DERException("Invalid date format '" + iso + "' with empty or zero padded fractal part detected at position " + position + ".");
                }
            }
            TimeZone timezone = null;
            SimpleDateFormat format = DER.createFormat(general, timezone);
            ParsePosition marker = new ParsePosition(0);
            Date date = format.parse(essential, marker);
            if (date == null && !strict) {
                int trailer = essential.length() - 5;
                String zone = trailer < 0 ? null : String.valueOf(essential.substring(trailer, trailer + 3)) + ':' + essential.substring(trailer + 3);
                format = DER.createFormat(general, TimeZone.getTimeZone("GMT" + zone));
                marker = new ParsePosition(0);
                date = format.parse(essential, marker);
                timezone = format.getTimeZone();
            }
            if (date != null) {
                if (fractal == null && timezone == null) {
                    return date;
                }
                return new MemoDate(date, fractal, timezone);
            }
            int length = essential.length();
            int position = marker.getErrorIndex();
            if (position >= length) {
                position += iso.length() - length;
            }
            throw new DERException("Invalid date format '" + iso + "' detected at position " + position + ".");
        }
        catch (UnsupportedEncodingException ex) {
            throw new DERException("Missing support for the ISO-8859-1 character encoding", ex);
        }
    }

    private static final byte[] toCollectionString(Serializable content) throws IOException {
        Collection elements = (Collection)((Object)content);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            ((DER)i.next()).encode(buffer);
        }
        return buffer.toByteArray();
    }

    private static final DER decode(BER ber, boolean strict) throws IOException {
        try {
            BigInteger number = ber.getTag();
            if (number.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                throw new DERException("Unsupported huge tag number detected.");
            }
            int type = number.intValue();
            switch (ber.getType()) {
                case 0: {
                    type = -type;
                    switch (type) {
                        case -1: {
                            DER.checkPrimitive(ber, type, strict);
                            byte[] b = DER.contentBytesOf(ber, strict ? 1 : -1);
                            return new DER(type, Boolean.valueOf(b.length > 0 && b[0] != 0), strict);
                        }
                        case -10: 
                        case -2: {
                            DER.checkPrimitive(ber, type, strict);
                            return new DER(type, new BigInteger(DER.contentBytesOf(ber)), strict);
                        }
                        case -3: {
                            DER.checkPrimitive(ber, type, strict);
                            return new DER(type, DER.fromBitString(DER.contentBytesOf(ber)), strict);
                        }
                        case -4: {
                            DER.checkPrimitive(ber, type, strict);
                            return new DER(type, (Serializable)DER.contentBytesOf(ber), strict);
                        }
                        case -5: {
                            DER.checkPrimitive(ber, type, strict);
                            DER.contentBytesOf(ber, 0);
                            return new DER(type, null, strict);
                        }
                        case -6: {
                            DER.checkPrimitive(ber, type, strict);
                            return new DER(type, (Serializable)DER.fromOIDString(DER.contentBytesOf(ber), true), strict);
                        }
                        case -12: {
                            DER.checkPrimitive(ber, type, strict);
                            return new DER(type, (Serializable)((Object)DER.asCheckeddString(new String(DER.contentBytesOf(ber), UT8), type, strict)), strict);
                        }
                        case -13: {
                            DER.checkPrimitive(ber, type, strict);
                            return new DER(type, (Serializable)DER.fromOIDString(DER.contentBytesOf(ber), false), strict);
                        }
                        case -16: {
                            DER.checkConstructed(ber, type, strict);
                            ByteArrayInputStream seq = new ByteArrayInputStream(DER.contentBytesOf(ber));
                            ArrayList<DER> list = new ArrayList<DER>();
                            while (((InputStream)seq).available() > 0) {
                                try {
                                    list.add(DER.decode(seq, strict));
                                }
                                catch (DERException ex) {
                                    throw new DERException("Problem when decoding the element " + list.size() + " of a DER sequence with the parsed " + new DER(type, list, strict) + " elements.", ex);
                                }
                            }
                            return new DER(type, list, strict);
                        }
                        case -17: {
                            DER.checkConstructed(ber, type, strict);
                            ByteArrayInputStream run = new ByteArrayInputStream(DER.contentBytesOf(ber));
                            TreeSet<DER> set = new TreeSet<DER>();
                            while (((InputStream)run).available() > 0) {
                                try {
                                    set.add(DER.decode(run, strict));
                                }
                                catch (DERException ex) {
                                    throw new DERException("Problem when decoding the element " + set.size() + " of a DER set with the parsed " + new DER(type, set, strict) + " elements.", ex);
                                }
                            }
                            return new DER(type, set, strict);
                        }
                        case -27: 
                        case -26: 
                        case -22: 
                        case -20: 
                        case -19: 
                        case -18: {
                            DER.checkPrimitive(ber, type, strict);
                            return new DER(type, (Serializable)((Object)DER.asCheckeddString(new String(DER.contentBytesOf(ber), ISO), type, strict)), strict);
                        }
                        case -28: {
                            DER.checkPrimitive(ber, type, strict);
                            return new DER(type, (Serializable)DER.fromUniversalString(DER.contentBytesOf(ber)), strict);
                        }
                        case -23: {
                            DER.checkPrimitive(ber, type, strict);
                            return new DER(type, DER.fromDateString(DER.contentBytesOf(ber, strict ? 13 : -1), false, strict), strict);
                        }
                        case -24: {
                            DER.checkPrimitive(ber, type, strict);
                            return new DER(type, DER.fromDateString(DER.contentBytesOf(ber), true, strict), strict);
                        }
                        case -30: {
                            DER.checkPrimitive(ber, type, strict);
                            return new DER(type, (Serializable)((Object)DER.asCheckeddString(new String(DER.contentBytesOf(ber), BMP), type, strict)), strict);
                        }
                    }
                    throw new DERException("Unsupported tag number " + type + " detected.");
                }
                case 2: {
                    byte[] b = DER.contentBytesOf(ber);
                    if (ber.isConstructed()) {
                        ByteArrayInputStream seq = new ByteArrayInputStream(b);
                        ArrayList<DER> collection = new ArrayList<DER>();
                        while (((InputStream)seq).available() > 0) {
                            try {
                                collection.add(DER.decode(seq, strict));
                            }
                            catch (DERException ex) {
                                throw new DERException("Problem when decoding the element " + collection.size() + " of a DER collection with the parsed " + new DER(type, (Serializable)((Object)Collections.unmodifiableCollection(collection)), strict) + " elements.", ex);
                            }
                        }
                        TaggedCollection tagged = new TaggedCollection(collection);
                        return new DER(type, tagged, strict);
                    }
                    return new DER(type, (Serializable)b, strict);
                }
            }
            throw new DERException("Unsupported class id detected.");
        }
        catch (BERException ex) {
            throw new DERException(ex);
        }
    }

    public static DER decode(InputStream encoded, boolean strict) throws IOException {
        try {
            return DER.decode(BER.decode(encoded), strict);
        }
        catch (BERException ex) {
            throw new DERException(ex);
        }
    }

    public static DER decode(byte[] encoded, boolean strict) throws IOException {
        if (encoded == null) {
            throw new NullPointerException("No input data supplied for decoding DER.");
        }
        return DER.decode(new ByteArrayInputStream(encoded), strict);
    }

    public static DER decode(InputStream encoded) throws IOException {
        return DER.decode(encoded, false);
    }

    public static DER decode(byte[] encoded) throws IOException {
        return DER.decode(encoded, false);
    }

    public void encode(OutputStream encoded) throws IOException {
        if (encoded != null) {
            boolean constructed = false;
            if (DER.isTagged(this.type)) {
                byte[] x;
                if (this.content instanceof byte[]) {
                    x = (byte[])this.content;
                } else {
                    constructed = true;
                    x = DER.toCollectionString(this.content);
                }
                new BER(2, constructed, this.type, x).encode(encoded);
            } else {
                byte[] x;
                switch (this.type) {
                    case -1: {
                        x = new byte[]{(byte)((Boolean)this.content != false ? 255 : 0)};
                        break;
                    }
                    case -10: 
                    case -2: {
                        x = ((BigInteger)this.content).toByteArray();
                        break;
                    }
                    case -3: {
                        x = DER.toBitString((BitSet)this.content);
                        break;
                    }
                    case -5: {
                        x = new byte[]{};
                        break;
                    }
                    case -6: {
                        x = DER.toOIDString((int[])this.content, true);
                        break;
                    }
                    case -4: {
                        x = (byte[])this.content;
                        break;
                    }
                    case -17: 
                    case -16: {
                        constructed = true;
                        x = DER.toCollectionString(this.content);
                        break;
                    }
                    case -12: {
                        x = ((String)((Object)this.content)).getBytes(UT8);
                        break;
                    }
                    case -13: {
                        x = DER.toOIDString((int[])this.content, false);
                        break;
                    }
                    case -27: 
                    case -26: 
                    case -22: 
                    case -20: 
                    case -19: 
                    case -18: {
                        x = ((String)((Object)this.content)).getBytes(ISO);
                        break;
                    }
                    case -28: {
                        x = DER.toUniversalString((char[])this.content);
                        break;
                    }
                    case -23: {
                        x = DER.toDateString((Date)this.content, false);
                        break;
                    }
                    case -24: {
                        x = DER.toDateString((Date)this.content, true);
                        break;
                    }
                    case -30: {
                        x = ((String)((Object)this.content)).getBytes(BMP);
                        break;
                    }
                    default: {
                        throw new DERException("Unsupported tag number " + this.type + " detected.");
                    }
                }
                new BER(0, constructed, -this.type, x).encode(encoded);
            }
        } else {
            throw new NullPointerException("No output stream supplied.");
        }
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encode(buffer);
        return buffer.toByteArray();
    }

    public boolean equals(Object other) {
        if (other instanceof DER) {
            DER x = (DER)other;
            if (this.type != x.type) {
                return false;
            }
            if (this.content instanceof int[]) {
                return Arrays.equals((int[])this.content, (int[])x.content);
            }
            if (this.content instanceof byte[]) {
                return Arrays.equals((byte[])this.content, (byte[])x.content);
            }
            if (this.content instanceof char[]) {
                return Arrays.equals((char[])this.content, (char[])x.content);
            }
            if (this.content != null) {
                return this.content.equals(x.content);
            }
            return x.content == null;
        }
        return false;
    }

    public int hashCode() {
        if (this.content instanceof int[]) {
            int base = 1;
            int[] array = (int[])this.content;
            int i = 0;
            while (i < array.length) {
                base = 31 * base + array[i];
                ++i;
            }
            return this.type ^ base;
        }
        if (this.content instanceof byte[]) {
            int base = 1;
            byte[] array = (byte[])this.content;
            int i = 0;
            while (i < array.length) {
                base = 31 * base + (array[i] & 0xFF);
                ++i;
            }
            return this.type ^ base;
        }
        if (this.content instanceof char[]) {
            int base = 1;
            char[] array = (char[])this.content;
            int i = 0;
            while (i < array.length) {
                base = 31 * base + array[i];
                ++i;
            }
            return this.type ^ base;
        }
        return this.type ^ (this.content != null ? this.content.hashCode() : 0);
    }

    private static final int compare(Serializable left, Serializable right) {
        Iterator i = ((Collection)((Object)left)).iterator();
        Iterator j = ((Collection)((Object)right)).iterator();
        while (i.hasNext() && j.hasNext()) {
            DER q;
            DER p = (DER)i.next();
            int e = p.compareTo(q = (DER)j.next());
            if (e == 0) continue;
            return e;
        }
        return i.hasNext() ? 1 : -1;
    }

    @Override
    public int compareTo(DER other) {
        DER y = other;
        int signum = this.type - y.type;
        if (signum != 0) {
            return signum;
        }
        if (this.equals(other)) {
            return 0;
        }
        try {
            Serializable x = y.content;
            if (DER.isTagged(this.type)) {
                if (this.content instanceof byte[]) {
                    byte[] u = (byte[])this.content;
                    byte[] v = (byte[])x;
                    return new BigInteger(1, u).compareTo(new BigInteger(1, v));
                }
                return DER.compare(this.content, x);
            }
            switch (this.type) {
                case -1: {
                    return (Boolean)this.content != false ? 1 : -1;
                }
                case -10: 
                case -2: {
                    return ((BigInteger)this.content).compareTo((BigInteger)x);
                }
                case -3: {
                    int d = ((BitSet)this.content).length() - ((BitSet)x).length();
                    if (d != 0) {
                        return d;
                    }
                    byte[] a = DER.toBitString((BitSet)this.content);
                    byte[] b = DER.toBitString((BitSet)x);
                    return new BigInteger(1, a).compareTo(new BigInteger(1, b));
                }
                case -5: {
                    throw new ClassCastException("Type mismatch during null comparizon.");
                }
                case -6: {
                    byte[] a = DER.toOIDString((int[])this.content, true);
                    byte[] b = DER.toOIDString((int[])x, true);
                    return new BigInteger(1, a).compareTo(new BigInteger(1, b));
                }
                case -4: {
                    byte[] u = (byte[])this.content;
                    byte[] v = (byte[])x;
                    return new BigInteger(1, u).compareTo(new BigInteger(1, v));
                }
                case -17: 
                case -16: {
                    return DER.compare(this.content, x);
                }
                case -13: {
                    byte[] g = DER.toOIDString((int[])this.content, false);
                    byte[] h = DER.toOIDString((int[])x, false);
                    return new BigInteger(1, g).compareTo(new BigInteger(1, h));
                }
                case -30: 
                case -27: 
                case -26: 
                case -22: 
                case -20: 
                case -19: 
                case -18: 
                case -12: {
                    return ((String)((Object)x)).compareTo((String)((Object)this.content));
                }
                case -28: {
                    byte[] s = DER.toUniversalString((char[])this.content);
                    byte[] t = DER.toUniversalString((char[])x);
                    return new BigInteger(1, s).compareTo(new BigInteger(1, t));
                }
                case -24: 
                case -23: {
                    return ((Date)this.content).compareTo((Date)x);
                }
            }
            throw new ClassCastException("Unsupported tag number " + this.type + " during comparizon detected.");
        }
        catch (DERException ex) {
            throw new ClassCastException("Syntax problem during comparizeon detected", ex){
                {
                    this.initCause(dERException);
                }
            };
        }
        catch (IOException ex) {
            throw new RuntimeException("Conversion problem during comparizeon detected", ex){
                {
                    this.initCause(iOException);
                }
            };
        }
    }

    private static final class MemoDate
    extends Date {
        private final String fractal;
        private final TimeZone timezone;

        private static final int millisOf(String fractal) {
            if (fractal != null) {
                int length = fractal.length();
                String normalized = length < 4 ? (length < 3 ? (length < 2 ? String.valueOf(fractal) + "00" : String.valueOf(fractal) + "0") : fractal) : fractal.substring(0, 4);
                int millis = Integer.parseInt(normalized);
                if (millis > 1000) {
                    millis = (millis + 5) / 10;
                }
                return millis;
            }
            return 0;
        }

        private MemoDate(Date date, String fractal, TimeZone timezone) {
            super(date.getTime() + (long)MemoDate.millisOf(fractal));
            this.fractal = fractal;
            this.timezone = timezone;
        }
    }

    private static final class MemoSet
    extends BitSet {
        private final int size;
        private final int pad;

        private MemoSet(int size, int pad) {
            super(size << 3);
            this.size = size;
            this.pad = pad;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MemoSet) {
                MemoSet memo = (MemoSet)obj;
                if (memo.size != this.size || memo.pad != this.pad) {
                    return false;
                }
                return super.equals(obj);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TaggedCollection
    extends AbstractCollection<DER>
    implements Serializable {
        private final Collection<DER> data;

        private TaggedCollection(Collection<DER> data) {
            this.data = data;
        }

        @Override
        public Iterator<DER> iterator() {
            return this.data.iterator();
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof TaggedCollection) {
                TaggedCollection tc = (TaggedCollection)obj;
                if (this.size() != tc.size()) {
                    return false;
                }
                Iterator<DER> it1 = this.iterator();
                Iterator<DER> it2 = tc.iterator();
                while (it1.hasNext()) {
                    DER d2;
                    DER d1 = it1.next();
                    if (d1.equals(d2 = it2.next())) continue;
                    return false;
                }
                return true;
            }
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (DER obj : this) {
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            return this.data.hashCode();
        }
    }
}

