/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.AnyCollection;
import lu.luxtrust.pkix.pkcs.p7.AnySequence;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.RelativeDistinguishedName;
import lu.luxtrust.pkix.pkcs.p7.Sequence;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DistinguishedName
extends AnySequence<RelativeDistinguishedName>
implements Serializable {
    public static final AnyCollection.Converter<DistinguishedName, X500Principal> CONVERTER = new NameConverter();
    public static final Any.Factory<DistinguishedName> FACTORY = new Any.Factory<DistinguishedName>(){

        @Override
        public DistinguishedName cast(DER der) {
            return DistinguishedName.cast(der);
        }
    };

    public X500Principal toX500Principal() {
        try {
            return new X500Principal(this.asDER().encode());
        }
        catch (IllegalArgumentException ex) {
            UnsupportedOperationException sub = new UnsupportedOperationException("No support for the " + this.asDER() + " distinguished name available.");
            sub.initCause(ex);
            throw sub;
        }
        catch (IOException ex) {
            UnsupportedOperationException sub = new UnsupportedOperationException("Problem during encoding during the " + this.asDER() + " distinguished name.");
            sub.initCause(ex);
            throw sub;
        }
    }

    public DistinguishedName(RelativeDistinguishedName[] rdn) {
        super((Any[])rdn);
    }

    public DistinguishedName(String c, String o, String ou, String cn) {
        super((Any[])DistinguishedName.createDn(c, o, ou, cn));
    }

    @Override
    public String toString() {
        StringBuffer buffy = new StringBuffer();
        for (RelativeDistinguishedName rdn : this) {
            buffy.append(rdn.toString());
            buffy.append(' ');
        }
        return buffy.toString();
    }

    private static RelativeDistinguishedName[] createDn(String c, String o, String ou, String cn) {
        ArrayList<RelativeDistinguishedName> list = new ArrayList<RelativeDistinguishedName>(4);
        if (cn != null) {
            list.add(new RelativeDistinguishedName(RelativeDistinguishedName.CN, cn));
        }
        if (ou != null) {
            list.add(new RelativeDistinguishedName(RelativeDistinguishedName.OU, ou));
        }
        if (o != null) {
            list.add(new RelativeDistinguishedName(RelativeDistinguishedName.O, o));
        }
        if (c != null) {
            list.add(new RelativeDistinguishedName(RelativeDistinguishedName.C, c));
        }
        return list.toArray(new RelativeDistinguishedName[list.size()]);
    }

    public static final DistinguishedName fromX500Principal(X500Principal name) {
        if (name != null) {
            byte[] string = name.getEncoded();
            if (string != null) {
                try {
                    return DistinguishedName.cast(DER.decode(string, true));
                }
                catch (IOException ex) {
                    UnsupportedOperationException sub = new UnsupportedOperationException("The " + name + " x500 principal cannot be converted.");
                    sub.initCause(ex);
                    throw sub;
                }
            }
            throw new UnsupportedOperationException("The " + name + "  x500 principal cannot be converted due to missing encoding support.");
        }
        return null;
    }

    public static final DistinguishedName fromX500Principal(String name) {
        try {
            return DistinguishedName.fromX500Principal(new X500Principal(name));
        }
        catch (UnsupportedOperationException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            UnsupportedOperationException sub = new UnsupportedOperationException("The " + name + " x500 principal cannot be converted.");
            sub.initCause(ex);
            throw sub;
        }
    }

    public static final DistinguishedName cast(DER der) {
        Sequence seq = Sequence.cast(der, 0, -1);
        ArrayList<RelativeDistinguishedName> list = new ArrayList<RelativeDistinguishedName>(seq.size());
        int i = 0;
        while (i < seq.size()) {
            try {
                list.add(RelativeDistinguishedName.cast(seq.get(i)));
            }
            catch (TypeMismatchException ex) {
                TypeMismatchException sub = new TypeMismatchException("The component " + i + " of a DistinguishedName must be a RelativeDistinguishedName.");
                sub.initCause(ex);
                throw sub;
            }
            ++i;
        }
        return new DistinguishedName(list.toArray(new RelativeDistinguishedName[list.size()]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameConverter
    implements AnyCollection.Converter<DistinguishedName, X500Principal>,
    Serializable {
        private NameConverter() {
        }

        @Override
        public X500Principal convert(DistinguishedName any) {
            return any.toX500Principal();
        }
    }
}

