/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERUtil;
import lu.luxtrust.pkix.pkcs.p7.Extension;
import lu.luxtrust.pkix.pkcs.p7.Sequence;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Extensions
extends AbstractCollection<Extension>
implements Collection<Extension>,
Serializable,
Any {
    private final Sequence sequence;

    public Extensions(Extension ... extension) {
        int count = extension != null ? extension.length : 0;
        ArrayList<DER> list = new ArrayList<DER>(count);
        int i = 0;
        while (i < count) {
            list.add(extension[i].asDER());
            ++i;
        }
        this.sequence = new Sequence(list);
    }

    public Extensions(Collection<? extends Extension> extension) {
        int count = extension != null ? extension.size() : 0;
        ArrayList<DER> list = new ArrayList<DER>(count);
        for (Extension extension2 : extension) {
            list.add(extension2.asDER());
        }
        this.sequence = new Sequence(list);
    }

    public final Extension get(int i) {
        return Extension.cast(this.sequence.get(i));
    }

    @Override
    public final int size() {
        return this.sequence.size();
    }

    @Override
    public final DER asDER() {
        return this.sequence.asDER();
    }

    @Override
    public Iterator<Extension> iterator() {
        return new SequenceIterator();
    }

    @Override
    public boolean equals(Object obj) {
        return DERUtil.equals(this, obj);
    }

    @Override
    public int hashCode() {
        return DERUtil.hashCode(this);
    }

    public static final Extensions cast(DER der) {
        Sequence seq = Sequence.cast(der, 0, -1);
        ArrayList<Extension> list = new ArrayList<Extension>(seq.size());
        int i = 0;
        while (i < seq.size()) {
            try {
                list.add(Extension.cast(seq.get(i)));
            }
            catch (TypeMismatchException ex) {
                TypeMismatchException sub = new TypeMismatchException("The component " + i + " of an Extensions sequence must be an Extension.");
                sub.initCause(ex);
                throw sub;
            }
            ++i;
        }
        return new Extensions(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SequenceIterator
    implements Iterator<Extension> {
        private int current = 0;

        private SequenceIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < Extensions.this.sequence.size();
        }

        @Override
        public Extension next() {
            return Extension.FACTORY.cast(Extensions.this.sequence.get(this.current++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

