/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.ByteArrayInputStream;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import lu.luxtrust.pkix.pkcs.p7.Envelope;
import lu.luxtrust.pkix.pkcs.p7.HashAlgorithm;
import lu.luxtrust.pkix.pkcs.p7.exceptions.PKIX_PKCS7_Exception;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

public class PKCS7 {
    private static final String VERSION = "1.2";

    public String getVersion() {
        return VERSION;
    }

    public byte[] createPKCS7(byte[] signature, byte[] encodedSignerCertificate, byte[] data) throws PKIX_PKCS7_Exception {
        return this.createPKCS7(signature, encodedSignerCertificate, HashAlgorithm.SHA1, data);
    }

    public byte[] retrieveSignatureFromPKCS7(byte[] pkcs7Signature) throws PKIX_PKCS7_Exception {
        byte[] signerSignature;
        block7: {
            if (pkcs7Signature == null) {
                throw new PKIX_PKCS7_Exception(196609, "The signature argument cannot be null.");
            }
            signerSignature = null;
            CMSSignedData s = null;
            SignerInformationStore signers = null;
            try {
                try {
                    s = new CMSSignedData(pkcs7Signature);
                    signers = s.getSignerInfos();
                    if (signers == null) break block7;
                    if (signers.getSigners().size() == 1) {
                        SignerInformation signer = (SignerInformation)signers.getSigners().toArray()[0];
                        signerSignature = signer.getSignature();
                        break block7;
                    }
                    throw new PKIX_PKCS7_Exception(196608, "Wrong PKCS7 format: More than one signer information available.");
                }
                catch (CMSException e) {
                    throw new PKIX_PKCS7_Exception(196608, "Error extracting signature from PKCS7 envelope.", e);
                }
            }
            finally {
                s = null;
                signers = null;
            }
        }
        return signerSignature;
    }

    public boolean isAttachedVerified(byte[] sig) {
        try {
            CMSSignedData sp = new CMSSignedData(sig);
            CertStore certs = sp.getCertificatesAndCRLs("Collection", "SUN");
            SignerInformationStore signers = sp.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            boolean result = false;
            while (it.hasNext()) {
                Collection<? extends Certificate> certCollection;
                Iterator<? extends Certificate> certIt;
                X509Certificate cert;
                SignerInformation signer = (SignerInformation)it.next();
                if (!signer.verify(cert = (X509Certificate)(certIt = (certCollection = certs.getCertificates(signer.getSID())).iterator()).next(), "BC")) break;
                result = true;
            }
            return result;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public byte[] createPKCS7(byte[] signature, byte[] encodedSignerCertificate, HashAlgorithm hashAlgorithm, byte[] data) throws PKIX_PKCS7_Exception {
        CertificateFactory factory;
        if (signature == null) {
            throw new PKIX_PKCS7_Exception(196609, "The signature argument cannot be null.");
        }
        if (encodedSignerCertificate == null) {
            throw new PKIX_PKCS7_Exception(196609, "The encoded Signer Certificate cannot be null.");
        }
        if (hashAlgorithm == null) {
            throw new PKIX_PKCS7_Exception(196609, "The hash algorithm cannot be null.");
        }
        try {
            factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new PKIX_PKCS7_Exception(196608, "Certificate Exception occured.", e);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(encodedSignerCertificate);
        X509Certificate certificate = null;
        try {
            certificate = (X509Certificate)factory.generateCertificate(input);
        }
        catch (CertificateException e) {
            throw new PKIX_PKCS7_Exception(196608, "Certificate Exception occured.", e);
        }
        X509Certificate[] listcert = new X509Certificate[]{certificate};
        Envelope envelope = new Envelope(signature, hashAlgorithm, certificate, listcert, data);
        byte[] pkcs7Signature = envelope.toPkcs7();
        return pkcs7Signature;
    }
}

