/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.AlgorithmIdentifier;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.AnySet;
import lu.luxtrust.pkix.pkcs.p7.CertificateChoice;
import lu.luxtrust.pkix.pkcs.p7.ContentInfo;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERException;
import lu.luxtrust.pkix.pkcs.p7.DERUtil;
import lu.luxtrust.pkix.pkcs.p7.Sequence;
import lu.luxtrust.pkix.pkcs.p7.SignerInfo;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SignedData
extends AbstractAny
implements Serializable {
    public static final DER OID_CONTENT_TYPE = new DER(new int[]{1, 2, 840, 113549, 1, 9, 3});
    public static final DER OID_MESSAGE_DIGEST = new DER(new int[]{1, 2, 840, 113549, 1, 9, 4});
    public static final Any.Factory<SignedData> FACTORY = new Any.Factory<SignedData>(){

        @Override
        public SignedData cast(DER der) {
            return SignedData.cast(der);
        }
    };
    public static final DER OID_SIGNED_DATA = new DER(new int[]{1, 2, 840, 113549, 1, 7, 2});
    public static final BigInteger CMS_VERSION_0 = BigInteger.valueOf(0L);
    public static final BigInteger CMS_VERSION_1 = BigInteger.valueOf(1L);
    public static final BigInteger CMS_VERSION_2 = BigInteger.valueOf(2L);
    public static final BigInteger CMS_VERSION_3 = BigInteger.valueOf(3L);
    public static final BigInteger CMS_VERSION_4 = BigInteger.valueOf(4L);
    public static final BigInteger CMS_VERSION_5 = BigInteger.valueOf(5L);
    private final AnySet<AlgorithmIdentifier> digestAlgorithms;
    private final ContentInfo<byte[]> encapsulatedContentInfo;
    private final AnySet<CertificateChoice> certificates;
    private final DER revocationLists;
    private final AnySet<SignerInfo> signerInfos;
    private DER der;

    public SignedData(AnySet<AlgorithmIdentifier> digestAlgorithmIdentifiers, ContentInfo<byte[]> encapsulatedContentInfo, AnySet<CertificateChoice> certificates, DER crls, AnySet<SignerInfo> signerInfos) {
        if (digestAlgorithmIdentifiers == null) {
            throw new NullPointerException();
        }
        if (encapsulatedContentInfo == null) {
            throw new NullPointerException();
        }
        if (signerInfos == null) {
            throw new NullPointerException();
        }
        this.digestAlgorithms = digestAlgorithmIdentifiers;
        this.encapsulatedContentInfo = encapsulatedContentInfo;
        this.certificates = certificates;
        this.revocationLists = crls;
        this.signerInfos = signerInfos;
    }

    private DER createDER() throws DERException {
        ArrayList<DER> list = new ArrayList<DER>();
        int version = 1;
        if (!ContentInfo.OID_DATA.equals(this.encapsulatedContentInfo.getContentType()) || SignedData.containsVersion3(this.signerInfos) || SignedData.containsAttributeCertificate(this.certificates)) {
            version = 3;
        }
        list.add(new DER(version));
        list.add(this.digestAlgorithms.asDER());
        list.add(this.encapsulatedContentInfo.asDER());
        if (this.certificates != null) {
            list.add(new DER(0, false, this.certificates.asDER()));
        }
        if (this.revocationLists != null) {
            list.add(this.revocationLists);
        }
        list.add(this.signerInfos.asDER());
        return new DER(list);
    }

    public BigInteger getCMSVersion() {
        int version = 1;
        if (!ContentInfo.OID_DATA.equals(this.encapsulatedContentInfo.getContentType()) || SignedData.containsVersion3(this.signerInfos) || SignedData.containsAttributeCertificate(this.certificates)) {
            version = 3;
        }
        return BigInteger.valueOf(version);
    }

    public AnySet<AlgorithmIdentifier> getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public ContentInfo<byte[]> getEncapsulatedContentInfo() {
        return this.encapsulatedContentInfo;
    }

    public AnySet<CertificateChoice> getCertificates() {
        return this.certificates;
    }

    public AnySet<SignerInfo> getSignerInfos() {
        return this.signerInfos;
    }

    private static boolean containsAttributeCertificate(AnySet<CertificateChoice> certificates) {
        return false;
    }

    private static boolean containsVersion3(AnySet<SignerInfo> signerInfos) {
        for (SignerInfo info : signerInfos) {
            if (CMS_VERSION_1.equals(info.getCMSVersion())) continue;
            return true;
        }
        return false;
    }

    @Override
    public DER asDER() {
        if (this.der == null) {
            try {
                this.der = this.createDER();
            }
            catch (DERException e) {
                throw new RuntimeException(e);
            }
        }
        return this.der;
    }

    public static SignedData cast(DER der) {
        AnySet<SignerInfo> signerInfos;
        DER crls;
        AnySet<CertificateChoice> certs;
        Sequence seq = Sequence.cast(der, 4, 6);
        DER derCmsVersion = seq.get(0);
        DERUtil.checkType(derCmsVersion, -2);
        AnySet<AlgorithmIdentifier> digestAlgorithms = AnySet.cast(seq.get(1), AlgorithmIdentifier.FACTORY, 0, -1);
        ContentInfo<byte[]> encContentInfo = ContentInfo.Encapsulated.cast(seq.get(2));
        int idx = 3;
        DER d = seq.get(idx);
        DERUtil.checkType(d, 0, 1, -17);
        AnySet<CertificateChoice> anySet = certs = d.getType() == 0 ? AnySet.cast(DERUtil.unpackImplicit(-17, d), CertificateChoice.FACTORY, 0, -1) : null;
        if (certs != null) {
            DER dER = d = idx < seq.size() - 1 ? seq.get(++idx) : null;
            if (d != null) {
                DERUtil.checkType(d, 1, -17);
            }
        }
        DER dER = crls = d != null && d.getType() == 1 ? d : null;
        if (crls != null) {
            d = idx < seq.size() - 1 ? seq.get(++idx) : null;
        }
        AnySet<SignerInfo> anySet2 = signerInfos = d != null ? AnySet.cast(d, SignerInfo.FACTORY, 0, -1) : null;
        if (derCmsVersion == null || digestAlgorithms == null || encContentInfo == null || signerInfos == null) {
            throw new TypeMismatchException("DER " + der + " is not a SignerData");
        }
        SignedData s = new SignedData(digestAlgorithms, encContentInfo, certs, crls, signerInfos);
        s.der = der;
        return s;
    }
}

