/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.AlgorithmIdentifier;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.AnySet;
import lu.luxtrust.pkix.pkcs.p7.Attribute;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERException;
import lu.luxtrust.pkix.pkcs.p7.DERUtil;
import lu.luxtrust.pkix.pkcs.p7.IssuerAndSerialNumber;
import lu.luxtrust.pkix.pkcs.p7.Sequence;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SignerInfo
extends AbstractAny
implements Serializable {
    public static final Any.Factory<SignerInfo> FACTORY = new Any.Factory<SignerInfo>(){

        @Override
        public SignerInfo cast(DER der) {
            return SignerInfo.cast(der);
        }
    };
    private final IssuerAndSerialNumber issuerAndSerialNumber;
    private final DER subjectKeyIdentifier;
    private final AlgorithmIdentifier digestAlgorithm;
    private final AnySet<Attribute> signedAttrs;
    private final AlgorithmIdentifier signatureAlgorithm;
    private final DER signature;
    private final AnySet<Attribute> unsignedAttrs;
    private DER der;

    public SignerInfo(IssuerAndSerialNumber issuerAndSerialNumber, DER subjectKeyIdentifier, AlgorithmIdentifier digestAlgorithm, AnySet<Attribute> signedAttributes, AlgorithmIdentifier signatureAlgorithm, DER signature, AnySet<Attribute> unsignedAttributes) {
        if (digestAlgorithm == null) {
            throw new NullPointerException("digestAlgorithm");
        }
        if (signatureAlgorithm == null) {
            throw new NullPointerException("signatureAlgorithm");
        }
        if (signature == null) {
            throw new NullPointerException("signature");
        }
        if (issuerAndSerialNumber != null && subjectKeyIdentifier != null) {
            throw new IllegalArgumentException("Only one of issuerAndSerialNumber or subjecKeyIdentifier can be non-null");
        }
        if (issuerAndSerialNumber == null && subjectKeyIdentifier == null) {
            throw new NullPointerException("One of issuerAndSerialNumber or subjecKeyIdentifier must be non-null");
        }
        if (subjectKeyIdentifier != null && subjectKeyIdentifier.getType() != -4) {
            throw new IllegalArgumentException("subjectKeyIdentifier");
        }
        if (signature.getType() != -4) {
            throw new IllegalArgumentException("signature");
        }
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.digestAlgorithm = digestAlgorithm;
        this.signedAttrs = signedAttributes;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signature = signature;
        this.unsignedAttrs = unsignedAttributes;
    }

    private DER createDER() throws DERException {
        ArrayList<DER> list = new ArrayList<DER>();
        int version = this.issuerAndSerialNumber != null ? 1 : 3;
        list.add(new DER(version));
        if (this.issuerAndSerialNumber != null) {
            list.add(this.issuerAndSerialNumber.asDER());
        }
        if (this.subjectKeyIdentifier != null) {
            list.add(new DER(0, this.subjectKeyIdentifier));
        }
        list.add(this.digestAlgorithm.asDER());
        if (this.signedAttrs != null) {
            list.add(new DER(0, false, this.signedAttrs.asDER()));
        }
        list.add(this.signatureAlgorithm.asDER());
        list.add(this.signature);
        if (this.unsignedAttrs != null) {
            list.add(new DER(1, false, this.unsignedAttrs.asDER()));
        }
        return new DER(list);
    }

    public BigInteger getCMSVersion() {
        return this.issuerAndSerialNumber != null ? BigInteger.valueOf(1L) : BigInteger.valueOf(3L);
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier != null ? (byte[])this.subjectKeyIdentifier.getContent() : null;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public AnySet<Attribute> getSignedAttributes() {
        return this.signedAttrs;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public byte[] getSignature() {
        return (byte[])this.signature.getContent();
    }

    public AnySet<Attribute> getUnsignedAttributes() {
        return this.unsignedAttrs;
    }

    @Override
    public DER asDER() {
        if (this.der == null) {
            try {
                this.der = this.createDER();
            }
            catch (DERException e) {
                throw new RuntimeException(e);
            }
        }
        return this.der;
    }

    public static SignerInfo cast(DER der) {
        return SignerInfo.cast(der, false);
    }

    public static SignerInfo cast(DER der, boolean strict) {
        AnySet<Attribute> unsignedAttrs;
        AnySet<Attribute> signedAttrs;
        DER derSubjectKeyId;
        Sequence seq = Sequence.cast(der, 5, 7);
        DER derVersion = seq.get(0);
        DERUtil.checkType(derVersion, -2);
        DER derSid = seq.get(1);
        DERUtil.checkType(derSid, -16, 0);
        IssuerAndSerialNumber issuerAndSer = derSid.getType() == -16 ? IssuerAndSerialNumber.cast(derSid) : null;
        DER dER = derSubjectKeyId = derSid.getType() == 0 ? DERUtil.unpackImplicit(-4, derSid) : null;
        if (derSubjectKeyId != null) {
            DERUtil.checkType(derSubjectKeyId, -4);
        }
        AlgorithmIdentifier digestAlg = AlgorithmIdentifier.cast(seq.get(2));
        int idx = 3;
        DER d = seq.get(idx);
        AnySet<Attribute> anySet = signedAttrs = d.getType() == 0 ? AnySet.cast(DERUtil.unpackImplicit(-17, d), Attribute.FACTORY, 0, -1) : null;
        if (signedAttrs != null) {
            // empty if block
        }
        int n = ++idx;
        d = seq.get(n);
        AlgorithmIdentifier sigAlg = AlgorithmIdentifier.cast(d);
        int n2 = ++idx;
        d = seq.get(n2);
        DERUtil.checkType(d, -4);
        DER derSignature = d;
        DER dER2 = d = ++idx < seq.size() ? seq.get(idx) : null;
        if (d != null) {
            DERUtil.checkType(d, 1);
            d = DERUtil.unpackImplicit(-16, d);
        }
        AnySet<Attribute> anySet2 = unsignedAttrs = d != null ? AnySet.cast(d, Attribute.FACTORY, 0, -1) : null;
        if (strict) {
            int v = ((BigInteger)derVersion.getContent()).intValue();
            if (v == 1) {
                if (derSubjectKeyId != null) {
                    throw new TypeMismatchException("DER " + der + " is not a valid SignerInfo v1, sid is a SubjectKeyIdentifier");
                }
            } else if (v == 3) {
                if (issuerAndSer != null) {
                    throw new TypeMismatchException("DER " + der + " is not a valid SignerInfo v3, sid is an IssuerAndSerialNumber");
                }
            } else {
                throw new TypeMismatchException("DER " + der + " is not a valid SignerInfo, only v1 and v3 are supported");
            }
        }
        SignerInfo s = new SignerInfo(issuerAndSer, derSubjectKeyId, digestAlg, signedAttrs, sigAlg, derSignature, unsignedAttrs);
        s.der = der;
        return s;
    }
}

