/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.AlgorithmIdentifier;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERException;
import lu.luxtrust.pkix.pkcs.p7.DERUtil;
import lu.luxtrust.pkix.pkcs.p7.DistinguishedName;
import lu.luxtrust.pkix.pkcs.p7.Extension;
import lu.luxtrust.pkix.pkcs.p7.Extensions;
import lu.luxtrust.pkix.pkcs.p7.Sequence;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

class TBSCertificate
extends AbstractAny
implements Serializable {
    public static final Any.Factory<TBSCertificate> FACTORY = new Any.Factory<TBSCertificate>(){

        @Override
        public TBSCertificate cast(DER der) {
            return TBSCertificate.cast(der);
        }
    };
    private static final DER V3 = new DER(2);
    private static final DER V2 = new DER(1);
    private static final DER V1 = new DER(0);
    private DER version = V3;
    private final DER serial;
    private final AlgorithmIdentifier signature;
    private final DistinguishedName issuer;
    private final DER validity;
    private final DistinguishedName subject;
    private final DER subjectPublicKeyInfo;
    private final Extensions extensions;
    private Sequence sequence;

    public TBSCertificate(BigInteger serialNumber, AlgorithmIdentifier signature, DistinguishedName issuer, DER validity, DistinguishedName subject, DER subjectPublicKeyInfo, Extensions extensions) {
        if (serialNumber == null) {
            throw new NullPointerException("serialNumber");
        }
        if (signature == null) {
            throw new NullPointerException("The certificate signature must not be null.");
        }
        if (issuer == null) {
            throw new NullPointerException("The certificate issuer must not be null.");
        }
        if (validity == null) {
            throw new NullPointerException("The certificate validity must not be null.");
        }
        if (subject == null) {
            throw new NullPointerException("The certificate subject must not be null.");
        }
        if (subjectPublicKeyInfo == null) {
            throw new NullPointerException("The certificate subject public key info must not be null.");
        }
        if (serialNumber.signum() < 0) {
            throw new IllegalArgumentException("The certificate serial number must not be negative.");
        }
        this.serial = new DER(serialNumber);
        this.signature = signature;
        this.issuer = issuer;
        this.validity = validity;
        this.subject = subject;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
        this.extensions = extensions;
    }

    public TBSCertificate(BigInteger serialNumber, DistinguishedName issuer, DER validity, DistinguishedName subject, DER subjectPublicKeyInfo, Extensions extensions) {
        this(serialNumber, AlgorithmIdentifier.SHA1withRSA, issuer, validity, subject, subjectPublicKeyInfo, extensions);
    }

    public DER asDER() {
        if (this.sequence == null) {
            try {
                int listsize = this.version == null ? 6 : 7;
                int extra = this.extensions != null && this.extensions.size() > 0 ? 1 : 0;
                ArrayList<DER> list = new ArrayList<DER>(listsize + extra);
                if (this.version != null) {
                    list.add(new DER(0, this.version));
                }
                list.add(this.serial);
                list.add(this.signature.asDER());
                list.add(this.issuer.asDER());
                list.add(this.validity);
                list.add(this.subject.asDER());
                list.add(this.subjectPublicKeyInfo);
                if (extra > 0) {
                    list.add(new DER(3, new Extensions(this.extensions).asDER()));
                }
                this.sequence = new Sequence(list);
            }
            catch (DERException e) {
                throw new RuntimeException(e);
            }
        }
        return this.sequence.asDER();
    }

    public BigInteger getSerialNumber() {
        return (BigInteger)this.serial.getContent();
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public DistinguishedName getIssuer() {
        return this.issuer;
    }

    public DistinguishedName getSubject() {
        return this.subject;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public final Extension.ExtendedKeyUsage getExtendedKeyUsage() {
        Extensions exts = this.getExtensions();
        if (exts != null) {
            for (Extension extension : exts) {
                if (!Extension.ExtendedKeyUsage.OID.equals(extension.getextnID())) continue;
                return Extension.ExtendedKeyUsage.fromExtension(extension.asDER());
            }
        }
        return null;
    }

    public final Extension.KeyUsage getKeyUsage() {
        Extensions exts = this.getExtensions();
        if (exts != null) {
            for (Extension extension : exts) {
                if (!Extension.KeyUsage.OID.equals(extension.getextnID())) continue;
                return Extension.KeyUsage.fromExtension(extension.asDER());
            }
        }
        return null;
    }

    public static TBSCertificate cast(DER der) {
        DER serial;
        Sequence seq = Sequence.cast(der, 6, 8);
        int offset = 0;
        DER versionDerExplicit = seq.get(offset++);
        DER version = null;
        if (versionDerExplicit.getType() == 0) {
            version = DERUtil.unpackExplicit(versionDerExplicit);
            if (!(version.equals(V1) || version.equals(V2) || version.equals(V3))) {
                throw new TypeMismatchException("The " + version + " der is not a suppported TBSCertificate version.");
            }
            serial = seq.get(offset++);
        } else {
            serial = versionDerExplicit;
        }
        if (serial.getType() == -2) {
            TBSCertificate c;
            DER extra;
            BigInteger serialNumber = (BigInteger)serial.getContent();
            AlgorithmIdentifier signature = AlgorithmIdentifier.cast(seq.get(offset++));
            DistinguishedName issuer = DistinguishedName.cast(seq.get(offset++));
            DER validity = seq.get(offset++);
            DistinguishedName subject = DistinguishedName.cast(seq.get(offset++));
            DER subjectPublicKeyInfo = seq.get(offset++);
            DER dER = extra = seq.size() > 7 ? seq.get(offset) : null;
            if (extra != null && extra.getType() == 3) {
                DER element = DERUtil.unpackExplicit(extra);
                Extensions extensions = seq.size() > 7 ? Extensions.cast(element) : null;
                c = new TBSCertificate(serialNumber, signature, issuer, validity, subject, subjectPublicKeyInfo, extensions);
            } else {
                c = new TBSCertificate(serialNumber, signature, issuer, validity, subject, subjectPublicKeyInfo, null);
            }
            c.sequence = seq;
            c.version = version;
            return c;
        }
        throw new TypeMismatchException("The " + der + " der is not a suppported TBSCertificate.");
    }
}

