/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.Choice;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERException;
import lu.luxtrust.pkix.pkcs.p7.DERUtil;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TypedChoice<C extends Choice<C>>
extends AbstractAny
implements Serializable,
Choice<C> {
    private final TypeRegistry<C> typeRegistry;
    private final DER der;

    public <T extends Any> TypedChoice(TypeRegistry<C> typeRegistry, Choice.Type<C, T> type, T any) {
        if (typeRegistry == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        DER aDer = any.asDER();
        this.typeRegistry = typeRegistry;
        if (type.getType() >= 0) {
            try {
                aDer = type.getRealType() != null ? new DER(type.getType(), false, aDer) : new DER(type.getType(), true, aDer);
            }
            catch (DERException e) {
                throw new RuntimeException(e);
            }
        }
        if (!((TypeRegistry)typeRegistry).accepts(aDer)) {
            throw new TypeMismatchException("DER " + aDer + " is not a " + this.getClass().getName());
        }
        this.der = aDer;
    }

    public TypedChoice(TypeRegistry<C> typeRegistry, DER der) {
        if (typeRegistry == null) {
            throw new NullPointerException();
        }
        if (!((TypeRegistry)typeRegistry).accepts(der)) {
            throw new TypeMismatchException("DER " + der + " is not a " + this.getClass().getName());
        }
        this.typeRegistry = typeRegistry;
        this.der = der;
    }

    @Override
    public DER asDER() {
        return this.der;
    }

    @Override
    public boolean is(Choice.Type<C, ? extends Any> type) {
        TypeAndFactory taf = ((TypeRegistry)this.typeRegistry).getTypeAndFactory(type);
        return taf != null && taf.type.getType() == this.der.getType();
    }

    @Override
    public Choice.Type<C, ?> getType() {
        for (TypeAndFactory taf : ((TypeRegistry)this.typeRegistry).map.values()) {
            if (taf.type.getType() != this.der.getType()) continue;
            return taf.type;
        }
        throw new RuntimeException("Unknown choice type.");
    }

    @Override
    public <T extends Any> T as(Choice.Type<C, T> type) {
        TypeAndFactory taf = ((TypeRegistry)this.typeRegistry).getTypeAndFactory(type);
        if (taf == null) {
            throw new TypeMismatchException("DER " + this.der + " is not a " + type.toString());
        }
        if (taf.type.getType() != this.der.getType()) {
            throw new TypeMismatchException("DER " + this.der + " is not a " + type.toString());
        }
        DER d = this.der;
        if (d.getType() >= 0) {
            d = taf.type.getRealType() != null ? DERUtil.unpackImplicit(taf.type.getRealType(), d) : DERUtil.unpackExplicit(d);
        }
        return taf.factory.cast(d);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeAndFactory<C extends Choice<C>, T extends Any>
    implements Serializable {
        public final Choice.Type<C, T> type;
        public final Any.Factory<? extends T> factory;

        private TypeAndFactory(Choice.Type<C, T> type, Any.Factory<? extends T> factory) {
            this.type = type;
            this.factory = factory;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeRegistry<C extends Choice<C>>
    implements Serializable {
        private final Map<Choice.Type<C, ?>, TypeAndFactory<C, ? extends Any>> map = new HashMap();
        private final Set<Integer> accepted = new HashSet<Integer>();

        private TypeRegistry(Collection<? extends TypeAndFactory<C, ?>> factories) {
            for (TypeAndFactory<C, ?> factory : factories) {
                this.map.put(factory.type, factory);
                if (this.accepted.contains(factory.type.getType())) {
                    throw new IllegalStateException("Type " + factory.type + " cannot be registered more than once");
                }
                this.accepted.add(factory.type.getType());
            }
        }

        private <T extends Any> TypeAndFactory<C, T> getTypeAndFactory(Choice.Type<C, T> cl) {
            return this.map.get(cl);
        }

        private boolean accepts(DER der) {
            return this.accepted.contains(der.getType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeRegistryBuilder<C extends Choice<C>> {
        private final List<TypeAndFactory<C, ?>> types = new ArrayList();

        public <T extends Any> TypeRegistryBuilder<C> registerType(Choice.Type<C, T> type, Any.Factory<? extends T> factory) {
            if (type == null) {
                throw new NullPointerException();
            }
            if (factory == null) {
                throw new NullPointerException();
            }
            this.register(type, factory);
            return this;
        }

        public TypeRegistry<C> build() {
            return new TypeRegistry(this.types);
        }

        private <T extends Any> void register(Choice.Type<C, T> type, Any.Factory<? extends T> factory) {
            this.types.add(new TypeAndFactory(type, factory));
        }
    }
}

