/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cms.CMSAttributeTableGenerator;

public class DefaultSignedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultSignedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultSignedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map parameters) {
        Attribute attr;
        Hashtable std = (Hashtable)this.table.clone();
        if (!std.containsKey(CMSAttributes.contentType)) {
            attr = new Attribute(CMSAttributes.contentType, new DERSet((DERObjectIdentifier)parameters.get("contentType")));
            std.put(attr.getAttrType(), attr);
        }
        if (!std.containsKey(CMSAttributes.signingTime)) {
            attr = new Attribute(CMSAttributes.signingTime, new DERSet(new Time(new Date())));
            std.put(attr.getAttrType(), attr);
        }
        if (!std.containsKey(CMSAttributes.messageDigest)) {
            byte[] hash = (byte[])parameters.get("digest");
            Attribute attr2 = hash != null ? new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hash))) : new Attribute(CMSAttributes.messageDigest, new DERSet(new DERNull()));
            std.put(attr2.getAttrType(), attr2);
        }
        return std;
    }

    public AttributeTable getAttributes(Map parameters) {
        return new AttributeTable(this.createStandardAttributeTable(parameters));
    }
}

