package lu.tudor.santec.numberwriter;
/*******************************************************************************
 *                                                                            
 *   Copyright (c) 2004, 2007 by CRP Henri TUDOR - SANTEC LUXEMBOURG 
 *   check http://santec.tudor.lu for more information
 * 
 *   Contributor(s):                         
 *    Johannes Hermen  johannes.hermen(at)tudor.lu                                                   
 *                                                                            
 *   This library is free software; you can redistribute it and/or modify it  
 *   under the terms of the GNU Lesser General Public License (version 2.1)
 *   as published by the Free Software Foundation.
 *                                                                            
 *   This software is distributed in the hope that it will be useful, but     
 *   WITHOUT ANY WARRANTY; without even the implied warranty of               
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        
 *   Lesser General Public License for more details.                          
 *                                                                            
 *   You should have received a copy of the GNU Lesser General Public         
 *   License along with this library; if not, write to the Free Software      
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  
 *                                                                            
 *     
 *******************************************************************************/
import java.util.Locale;



/**
 * class for converting numbers to written numbers in different languages
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 */
public class NumberWriter {
	
	
	/**
	 * @param number
	 * @return
	 */
	public static String writeNumber(int number) {
		return writeNumber(number, Locale.getDefault());
	}
	
	/**
	 * @param number
	 * @param locale
	 * @return
	 */
	public static String writeNumber(int number, Locale locale) {
		String lang = locale.getLanguage();
		if (lang.equals(Locale.FRANCE.getLanguage())) {
			return FrenchNumberWriter.writeNumber(number);
		} if (lang.equals(Locale.GERMANY.getLanguage())) {
			return GermanNumberWriter.writeNumber(number);
		} else
			return EnglishNumberWriter.writeNumber(number);
	}
	
	
	/**
	 * @param number
	 * @param locale
	 * @return
	 */
	public static String writeNumber(double number, Locale locale, String delimiter, int digits) {
		String lang = locale.getLanguage();
		int multi = 10;
		for (int i = 1; i < digits; i++) {
			multi*=10;
		}
		int beforeDelim = (int) number;
		int afterDelim = (int) (((number - ((int) number - (0.1/multi))) * multi));
		if(afterDelim<0) 
			afterDelim = - afterDelim;
		
		
		if (lang.equals(Locale.FRANCE.getLanguage())) {
			return FrenchNumberWriter.writeNumber(beforeDelim) + delimiter +
				((afterDelim==0) ? "" : FrenchNumberWriter.writeNumber(afterDelim));
		} if (lang.equals(Locale.GERMANY.getLanguage())) {
			return GermanNumberWriter.writeNumber(beforeDelim) + delimiter +
				((afterDelim==0) ? "" : GermanNumberWriter.writeNumber(afterDelim));
		} else
			return EnglishNumberWriter.writeNumber(beforeDelim) + delimiter +
				((afterDelim==0) ? "" : EnglishNumberWriter.writeNumber(afterDelim));
	}

}


