package lu.tudor.santec.numberwriter;
/*******************************************************************************
 *                                                                            
 *   Copyright (c) 2004, 2007 by CRP Henri TUDOR - SANTEC LUXEMBOURG 
 *   check http://santec.tudor.lu for more information
 * 
 *   Contributor(s):                         
 *    Johannes Hermen  johannes.hermen(at)tudor.lu                                                   
 *                                                                            
 *   This library is free software; you can redistribute it and/or modify it  
 *   under the terms of the GNU Lesser General Public License (version 2.1)
 *   as published by the Free Software Foundation.
 *                                                                            
 *   This software is distributed in the hope that it will be useful, but     
 *   WITHOUT ANY WARRANTY; without even the implied warranty of               
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        
 *   Lesser General Public License for more details.                          
 *                                                                            
 *   You should have received a copy of the GNU Lesser General Public         
 *   License along with this library; if not, write to the Free Software      
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  
 *                                                                            
 *     
 *******************************************************************************/
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;


/**
 * a test gui for the number 2 written number classes
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 */
public class NumberWriterTestGui extends JFrame{
	
	private static final long serialVersionUID = 1L;
	private JTextField englishField;
	private JTextField romanField;
	private JTextField frenchField;
	private JTextField germanField;
	private JTextField tf;

	public NumberWriterTestGui() {
		super("NumberWriter Test GUI");
//		this.setLayout();
		
		this.setDefaultCloseOperation(EXIT_ON_CLOSE);
		
		JPanel panel = new JPanel(new GridLayout(0,1, 3,3));
		panel.setBorder(new EmptyBorder(10,10,10,10));
		
		Font f = new Font("Times", Font.BOLD, 20);
		
		tf = new JTextField(40);
		
		tf.setFont(f);
		tf.addKeyListener(new KeyAdapter() {
			public void keyReleased(KeyEvent e) {
				printNumber();
			}
		});
		panel.add(new JLabel("Enter a Number (int or double):", JLabel.LEFT));
		panel.add(tf);
		panel.add(new JLabel("English:", JLabel.LEFT));
		englishField = new JTextField();
		englishField.setEditable(false);
		englishField.setFont(f);
		panel.add(englishField);
		panel.add(new JLabel("German:", JLabel.LEFT));
		germanField = new JTextField();
		germanField.setEditable(false);
		germanField.setFont(f);
		panel.add(germanField);
		panel.add(new JLabel("French:", JLabel.LEFT));
		frenchField = new JTextField();
		frenchField.setEditable(false);
		frenchField.setFont(f);
		panel.add(frenchField);
		panel.add(new JLabel("Roman:", JLabel.LEFT));
		romanField = new JTextField();
		romanField.setEditable(false);
		romanField.setFont(f);
		panel.add(romanField);
		
		this.add(panel);
		
		this.pack();
		Dimension dim = getToolkit().getScreenSize();
		Rectangle abounds = getBounds();
		setLocation((dim.width - abounds.width) / 2,(dim.height - abounds.height) / 2);
		this.setVisible(true);
	}
	
	private void printNumber() {
		try {
			int number = Integer.parseInt(tf.getText());
			englishField.setText(EnglishNumberWriter.writeNumber(number));
			germanField.setText(GermanNumberWriter.writeNumber(number));
			frenchField.setText(FrenchNumberWriter.writeNumber(number));
			romanField.setText(RomanNumberWriter.writeNumber(number));
		} catch (Exception e) {
			System.out.println(e.getCause() + " " +e.getMessage());
			try {
				double number = Double.parseDouble(tf.getText());
				englishField.setText(NumberWriter.writeNumber(number, Locale.ENGLISH, " euro ", 2));
				germanField.setText(NumberWriter.writeNumber(number, Locale.GERMAN, " euro ", 2));
				frenchField.setText(NumberWriter.writeNumber(number, Locale.FRENCH, " euro ", 2));
				romanField.setText("number invalid");
			} catch (Exception e2) {
				englishField.setText("number invalid");
				germanField.setText("number invalid");
				frenchField.setText("number invalid");
				romanField.setText("number invalid");
				System.out.println(e2.getCause() + " " +e2.getMessage());
			}
		}
	}
	
	
	public static void main(String[] args) throws Exception {
		
		new NumberWriterTestGui();
		
//		 double[] numbers = {0, 1, 13, 30, 41, 60, 61, 70, 72, 80, 83, 90, 94, 100, 200, 201, 111, 1032, 12.65};
//		 for (int i = 0; i < numbers.length; i++) {
//			 System.out.println("" + numbers[i] + " " + NumberWriter.writeNumber(numbers[i],Locale.FRENCH, " euro ", 2));			
//		 }
		 
//		 for (int i = 0; i <= 100; i++) {
//			 System.out.println("" + i + "\t " + RomanNumberWriter.writeNumber(i));			
//		 }
		
	}
}
