package lu.tudor.santec.numberwriter;
/*******************************************************************************
 *                                                                            
 *   Copyright (c) 2004, 2007 by CRP Henri TUDOR - SANTEC LUXEMBOURG 
 *   check http://santec.tudor.lu for more information
 * 
 *   Contributor(s):                         
 *    Johannes Hermen  johannes.hermen(at)tudor.lu                                                   
 *                                                                            
 *   This library is free software; you can redistribute it and/or modify it  
 *   under the terms of the GNU Lesser General Public License (version 2.1)
 *   as published by the Free Software Foundation.
 *                                                                            
 *   This software is distributed in the hope that it will be useful, but     
 *   WITHOUT ANY WARRANTY; without even the implied warranty of               
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        
 *   Lesser General Public License for more details.                          
 *                                                                            
 *   You should have received a copy of the GNU Lesser General Public         
 *   License along with this library; if not, write to the Free Software      
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  
 *                                                                            
 *     
 *******************************************************************************/
public class RomanNumberWriter {

	private static final String[] EINER = { "", "I", "II", "III",
			"IV", "V", "VI", "VII", "VIII", "IX" };

	private static final String[] ZEHNER = { 
		"", "X", "XX", "XXX", "XL", "L",
		"LX", "LXX", "LXXX", "XC" };
	
	private static final String[] HUNDERTER = { 
		"", "C", "CC", "CCC", "CD", "D",
		"DC", "DCC", "DCCC", "CM" };
	
	private static final String[] TAUSENDER = { 
		"", "M", "MM", "MMM", "MMMM", "ⅠƆƆ",
		"ⅠƆƆM", "ⅠƆƆMM", "ⅠƆƆMMM", "" };

	public static String writeNumber(int number) {
		if (number == 0)
			return EINER[0];
		else if (number == 1)
			return EINER[1];
		else {
			StringBuffer buf = new StringBuffer();
			less10000(buf, number);
			return buf.toString();
		}
	}

	private static void less100(StringBuffer buf, int number) {
		if (number == 0)
			return;
		else if (number == 1)
			buf.append(EINER[1]);
		else if (number < 10)
			buf.append(EINER[number]);
		else if (number % 10 == 0) {
			buf.append(ZEHNER[number / 10]);
		} else {
			buf.append(ZEHNER[number / 10]);
			buf.append(EINER[number % 10]);
		}
	}

	private static void less1000(StringBuffer buf, int number) {
		if (number < 100) {
			less100(buf, number);
		} else {
			buf.append(HUNDERTER[number / 100]);
			less100(buf, number % 100);
		}
	}

	private static void less10000(StringBuffer buf, int number) {
		if (number<0) {
			buf.append("- ");
			number = -number;
		}
		
		if (number < 1000) {
			less1000(buf, number);
		} else {
			buf.append(TAUSENDER[number / 1000]);
			less1000(buf, number % 1000);
		}
	}
}
