/*
 * FTPFileDescriptor.java
 *
 * Created on March 17, 2004, 2:31 PM
 */

package lu.tudor.santec.ftp;

import java.util.Date;
import java.util.Calendar;

import java.text.SimpleDateFormat;
import java.text.ParseException;


//---------------------------------------------------------------------------
/** Encapsulates relevant aattributes of FTP files
 * @author lu.cprht.santec/Nico MACK
 * @version 1.0
 */
//---------------------------------------------------------------------------

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class FTPFileDescriptor 
    {
    public static final int c_NotSet     = 0;
    public static final int c_File       = 1;
    public static final int c_Directory  = 2;
    public static final int c_Link       = 3;
                
    private int     m_FileType;

    private String  m_FileName;
    private long    m_FileSize;
    private Date    m_FileDate;
    
    private String  m_FileOwner;
    private String  m_FileGroup;
    private String  m_FilePermission;
    
    private static final SimpleDateFormat 
    
    c_ThisYearDateFormat = new SimpleDateFormat ("MMM dd hh:mm");
    
   private static final SimpleDateFormat 
    
    c_PastYearsDateFormat = new SimpleDateFormat ("MMM dd  yyyy");
      
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
    
//---------------------------------------------------------------------------
/** creates an empty instance of this class */    
//---------------------------------------------------------------------------

public FTPFileDescriptor() 
    {
    m_FileType  = c_NotSet;
        
    m_FileName  = new String ("");
    m_FileSize  = 0;
    m_FileDate  = new Date ();
    
    m_FileOwner         = new String ("");
    m_FileGroup         = new String ("");
    m_FilePermission    = new String ("");
    }
 
//---------------------------------------------------------------------------
/** creates a new instance of this class using the provided data to initialize it
 * @param p_Type specifies whether the descriptor should represent a file, a directory or a link.
 * Accepted values are FTPFileDescriptor.c_File, FTPFileDescriptor.c_Directory or
 * FTPFileDescriptor.c_Link
 * @param p_Name specifies the name of the file
 * @param p_Size specifies the size of the file
 * @param p_Date specifies the creation date of the file
 * @param p_Owner specifies the owner of the file
 * @param p_Group specifies the group the file owner belongs to
 * @param p_Permission specifies the file permissions
 */    
//---------------------------------------------------------------------------

public FTPFileDescriptor (int       p_Type,     String  p_Name,
                          long      p_Size,     Date    p_Date,
                          String    p_Owner,    String  p_Group, 
                          String    p_Permission)
    {
    if (   (p_Type == c_File)
        || (p_Type == c_Link)
        || (p_Type == c_Directory)) m_FileType = p_Type;

    if (p_Size > 0) m_FileSize = p_Size;
 
    m_FileName          = p_Name;
    m_FileDate          = p_Date;
    m_FileOwner         = p_Owner; 
    m_FileGroup         = p_Group;
    m_FilePermission    = p_Permission;
    }

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

// == Read Accessor methods =================================================

public int     getFileType () { return m_FileType; }

public String  getFileName () { return m_FileName; }

public long    getFileSize () { return m_FileSize; }

public Date    getFileDate () { return m_FileDate; }

public String  getFileOwner () { return m_FileOwner; }

public String  getFileGroup () { return m_FileGroup; }

public String  getFilePermission () { return m_FilePermission; }

// == Write Accessor methods =================================================

//---------------------------------------------------------------------------
/** sets the file type for this descriptor
 * @param p_Type specifies whether the descriptor should represent a file, a directory or a link.
 * Accepted values are FTPFileDescriptor.c_File, FTPFileDescriptor.c_Directory or
 * FTPFileDescriptor.c_Link
 */
//---------------------------------------------------------------------------

public void setFileType (int p_Type)
    {
    if (   (p_Type == c_File)
        || (p_Type == c_Link)
        || (p_Type == c_Directory)) m_FileType = p_Type;
    }

//---------------------------------------------------------------------------

public void setFileName (String p_Name)
    {
    if (p_Name != null) m_FileName = p_Name;
    }

//---------------------------------------------------------------------------

public void setFileSize (long p_Size)
    {
    if (p_Size > 0) m_FileSize = p_Size;
    }

//---------------------------------------------------------------------------

public void setFileDate (Date p_Date)
    {
    if (p_Date != null) m_FileDate = p_Date;
    }

//---------------------------------------------------------------------------
/** parses the specified String in order to extract file creation date. Two parsing
 * attempts are made 'cause creation date may come in two flavors. Dates in current
 * year will be in the form 'MMM dd hh:mm', e.g. 'Feb 10 16:11'. Dates in past
 * years however, will be in the form 'MMM dd  yyyy', e.g. 'Dec 25 2003'.
 * @param p_String specifies the date string to be parsed
 */
//---------------------------------------------------------------------------

public void setFileDate (String p_DateString)
    {
    Calendar    l_Calendar;
    int         l_ThisYear;
    Date        l_Date;
    boolean     l_SuccessfullyParsed = false;
    
    if (p_DateString != null)
        {    
        l_Calendar = Calendar.getInstance ();   
        l_ThisYear = l_Calendar.get (Calendar.YEAR); 
        
        try {            
            l_Date  = c_ThisYearDateFormat.parse (p_DateString);
            l_Calendar.setTime (l_Date);
            l_Calendar.set (Calendar.YEAR,l_ThisYear);
            m_FileDate = l_Calendar.getTime();
            l_SuccessfullyParsed = true;
            }
        catch (ParseException p_Exception)
            {        
            }
         
        if (l_SuccessfullyParsed) return;
        
        try {
            l_Date = c_PastYearsDateFormat.parse (p_DateString);
            m_FileDate = l_Date;
            }
        catch (ParseException p_Exception)
            {
            m_FileDate = new Date ();
            }
        }    
    }   

//---------------------------------------------------------------------------

public void setFileOwner (String p_Owner)
    {
    if (p_Owner != null) m_FileOwner = p_Owner;
    }

//---------------------------------------------------------------------------

public void setFileGroup (String p_Group)
    {
    if (p_Group != null) m_FileGroup = p_Group;
    }

//---------------------------------------------------------------------------

public void setFilePermission (String p_Permission)
    {
    if (p_Permission != null) m_FilePermission = p_Permission;
    }

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}
