package lu.tudor.santec.org.fife.ui.autocomplete;
import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;


/**
 * @author ferring
 * 
 * This is a demo to show the functionality of the AutoCompletionTextComponent.
 */
public class AutoCompletionTextComponentDemo extends JFrame {

	private static final long serialVersionUID = 1L;


	public AutoCompletionTextComponentDemo() 
	{
		JPanel contentPane = new JPanel(new BorderLayout());
		
		MWCompletionProvider provider = new MWCompletionProvider(null);
		
		AutoCompletionTextComponent textComponent = new AutoCompletionTextComponent(new JTextArea(), provider);
		textComponent.setSearchMode(MWCompletionProvider.SEARCH_MODE_BOTH);
//		textComponent.enableScrollPane(true);
		contentPane.add(new JScrollPane(textComponent));
		
		textComponent.addCompletion("dieser Text soll ganz ersetzt werden", "Dieser Text steht dann nachher da.");
		textComponent.addCompletion("dies das", "dies und das und dies");
		textComponent.addCompletion("dies das", "dies und das");
		textComponent.addCompletion("text ersetzten", "durch diesen Text");
		textComponent.addCompletion("dies und dies", "Dies und dies");
		textComponent.addCompletion("Schreibe diesen Text");
		textComponent.addCompletion("Schreibe auch diesen Text");
		textComponent.addCompletion("Dies und dies");
		textComponent.addCompletion("DIES UND DIES");
		textComponent.addCompletion("das und das");
		textComponent.addCompletion("DAS UND DAS");
		textComponent.addCompletion("DaS UnD dAs");
		textComponent.addCompletion("Text with a\ttab");
		
		
//		textComponent.setEditHotKeysEnabled(false);
//		textComponent.setQuickAddEnabled(false);
//		textComponent.setAddCompletionKey(KeyStroke.getKeyStroke(KeyEvent.VK_W, KeyEvent.ALT_DOWN_MASK));
//		textComponent.setMenuEnabled(false);

		setContentPane(contentPane);
		setTitle("AutoCompletionTextArea Demo");
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setSize(350, 300);
		setLocationRelativeTo(null);
		setVisible(true);
	}


	/**
	 * Create a simple provider that adds some Java-related completions.
	 *
	 * @return The completion provider.
	 */
//	private DefaultCompletionProvider createCompletionProvider() {
//		DefaultCompletionProvider provider = new DefaultCompletionProvider();
//		
//		provider.addCompletion(new BasicCompletion(provider, "Basic replacement Text", "basic description", "<html>This is the <b>summary</b> of this text!"));
//		provider.addCompletion(new BasicCompletion(provider, "abstrac"));
//		provider.addCompletion(new BasicCompletion(provider, "assert"));
//		provider.addCompletion(new BasicCompletion(provider, "break"));
//		provider.addCompletion(new BasicCompletion(provider, "case"));
//		provider.addCompletion(new BasicCompletion(provider, "catch"));
//		provider.addCompletion(new BasicCompletion(provider, "class"));
//		provider.addCompletion(new BasicCompletion(provider, "const"));
//		provider.addCompletion(new BasicCompletion(provider, "continue"));
//		provider.addCompletion(new BasicCompletion(provider, "default"));
//		provider.addCompletion(new BasicCompletion(provider, "do"));
//		provider.addCompletion(new BasicCompletion(provider, "else"));
//		provider.addCompletion(new BasicCompletion(provider, "enum"));
//		provider.addCompletion(new BasicCompletion(provider, "extends"));
//		provider.addCompletion(new BasicCompletion(provider, "final"));
//		provider.addCompletion(new BasicCompletion(provider, "finally"));
//		provider.addCompletion(new BasicCompletion(provider, "for"));
//		provider.addCompletion(new BasicCompletion(provider, "goto"));
//		provider.addCompletion(new BasicCompletion(provider, "if"));
//		provider.addCompletion(new BasicCompletion(provider, "implements"));
//		provider.addCompletion(new BasicCompletion(provider, "import"));
//		provider.addCompletion(new BasicCompletion(provider, "instanceof"));
//		provider.addCompletion(new BasicCompletion(provider, "interface"));
//		provider.addCompletion(new BasicCompletion(provider, "native"));
//		provider.addCompletion(new BasicCompletion(provider, "new"));
//		provider.addCompletion(new BasicCompletion(provider, "package"));
//		provider.addCompletion(new BasicCompletion(provider, "private"));
//		provider.addCompletion(new BasicCompletion(provider, "protected"));
//		provider.addCompletion(new BasicCompletion(provider, "public"));
//		provider.addCompletion(new BasicCompletion(provider, "return"));
//		provider.addCompletion(new BasicCompletion(provider, "static"));
//		provider.addCompletion(new BasicCompletion(provider, "strictfp"));
//		provider.addCompletion(new BasicCompletion(provider, "super"));
//		provider.addCompletion(new BasicCompletion(provider, "switch"));
//		provider.addCompletion(new BasicCompletion(provider, "synchronized"));
//		provider.addCompletion(new BasicCompletion(provider, "this"));
//		provider.addCompletion(new BasicCompletion(provider, "throw"));
//		provider.addCompletion(new BasicCompletion(provider, "throws"));
//		provider.addCompletion(new BasicCompletion(provider, "transient"));
//		provider.addCompletion(new BasicCompletion(provider, "try"));
//		provider.addCompletion(new BasicCompletion(provider, "void"));
//		provider.addCompletion(new BasicCompletion(provider, "volatile"));
//		provider.addCompletion(new BasicCompletion(provider, "while"));
//
//		provider.addCompletion(new ShorthandCompletion(provider, "sysout", "System.out.println(", "System.out.println("));
//		provider.addCompletion(new ShorthandCompletion(provider, "syserr", "System.err.println(", "System.err.println("));
//
//		return provider;
//	}

	public static void main(String[] args) 
	{
		new AutoCompletionTextComponentDemo();
	}

}
