package lu.tudor.santec.org.fife.ui.autocomplete;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;


/**
 * @author ferring
 * 
 * This event is needed by the <code>MWACListener</code>.
 */
public class MWACEvent implements Serializable
{
	/* ======================================== */
	// 		PRIVATE FINAL MEMBERS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	
	/* ======================================== */
	// 		PRIVATE MEMBERS
	/* ======================================== */
	
	private MWCompletionProvider 	source;
	
	private long 					when;
	
	private Completion 				completion;
	
	private Completion 				previousCompletion;
	
	private List<Completion>		completions;
	
	
	/* ======================================== */
	// 		CONSTRUCTOR
	/* ======================================== */

	/**
	 * @param source The completion provider
	 * @param when The time in milliseconds that specifies, when the event happened 
	 * @param completion The completion the event is about
	 */
	public MWACEvent(MWCompletionProvider source, long when, 
			Completion completion)
	{
		this(source, when, completion, 	null, 			null);
	}

	/**
	 * @param source The completion provider
	 * @param when The time in milliseconds that specifies, when the event happened 
	 * @param completions The completions the event is about
	 */
	public MWACEvent(MWCompletionProvider source, long when, 
			List<Completion> completions)
	{
		this(source, when, null, 		completions, 	null);
	}

	/**
	 * @param source The completion provider
	 * @param when The time in milliseconds that specifies, when the event happened 
	 * @param completion The (first of all) completion the event is about
	 * @param previousCompletion The old completion that is set, whenever a completion is changed
	 */
	public MWACEvent(MWCompletionProvider source, long when, 
			Completion completion, Completion previousCompletion)
	{
		this(source, when, completion, 	null, 			previousCompletion);
	}
	
	/**
	 * @param source The completion provider
	 * @param when The time in milliseconds that specifies, when the event happened 
	 * @param completion The (first of all) completion the event is about
	 * @param completions The completions the event is about
	 * @param previousCompletion The old completion that is set, whenever a completion is changed
	 */
	private MWACEvent(MWCompletionProvider source, long when, 
			Completion completion, List<Completion> completions, Completion previousCompletion)
	{
		this.source 			= source;
		this.when 				= when;
		this.previousCompletion = previousCompletion;
		
		// define the list of completions
		if (completions == null)
		{
			// create a new one, if it doesn't exist
			this.completions 	= new LinkedList<Completion>();
			if (completion != null)
				// add the given completion, if it isn't null
				this.completions.add(completion);
		}
		else
			this.completions 	= completions;
		
		// define the completion
		if (completion == null
				&& completions != null
				&& !completions.isEmpty())
			// set the first one of the list as completion, if completion is null
			this.completion 	= completions.get(0);
		else
			this.completion 	= completion;
	}

	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	/**
	 * @return The completion provider
	 */
	public MWCompletionProvider getSource()
	{
		return source;
	}


	/**
	 * @return The time in milliseconds that specifies, when the event happened 
	 */
	public long getWhen()
	{
		return when;
	}


	/**
	 * @return completion The (first of all) completion the event is about
	 */
	public Completion getCompletion()
	{
		return completion;
	}
	
	/**
	 * @return The old completion that is set, whenever a completion is changed
	 */
	public Completion getPreviousCompletion ()
	{
		return previousCompletion;
	}
	
	/**
	 * @return The completions the event is about
	 */
	public List<Completion> getCompletions ()
	{
		return completions;
	}
}
