package lu.tudor.santec.org.fife.ui.autocomplete;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import lu.tudor.santec.org.fife.ui.autocomplete.dialog.BaseDialogImpl;
import lu.tudor.santec.org.fife.ui.autocomplete.dialog.HotKeyDialog;


/**
 * @author ferring
 * 
 * Creates the menu for the auto completion and handles the events of the menu.
 */
public class MWACMenuHandler implements MouseListener
{
	private AutoCompletionTextComponent view;
	
	private MWACHandler handler;
	
	private JPopupMenu menu;
	
	private JMenuItem quickAddCompletionItem;
	private JMenuItem saveCompletionItem;
	private JMenuItem editCompletionItem;
	private JMenuItem editHotKeysItem;
	
	
	/**
	 * @param textComponent the AutoCompletionTextComponent
	 * @param handler The handler most events are delegated to
	 */
	public MWACMenuHandler (AutoCompletionTextComponent textComponent, MWACHandler handler)
	{
		this.view 			= textComponent;
		this.handler		= handler;
		
		// create the popup menu
		menu = new JPopupMenu();
		
		// create the quick add item
		quickAddCompletionItem = new JMenuItem(new AbstractAction(
				"<html><b>" +
				Translator.translate(Translator.ADD_SELECTED_TEXT) +
				"</b> <font size=1><i>" + 
				KeyEvent.getModifiersExText(view.getQuickAddCompletionKey().getModifiers()) + 
				"+" + KeyEvent.getKeyText(view.getQuickAddCompletionKey().getKeyCode()), 
				IconManager.getIcon(IconManager.ADD_ICON_NAME))
		{
			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e)
			{
				MWACMenuHandler.this.handler.quickAdd();
			}
		});
		quickAddCompletionItem.setVisible(view.isQuickAddEnabled());
		
		// create the save completion item
		saveCompletionItem = new JMenuItem(new AbstractAction(
				"<html><b>" +
				Translator.translate(Translator.SAVE_COMPLETION) +
				"</b> <font size=1><i>" +
				KeyEvent.getModifiersExText(view.getSaveCompletionKey().getModifiers()) + 
				"+" + KeyEvent.getKeyText(view.getSaveCompletionKey().getKeyCode()),  
				IconManager.getIcon(IconManager.SAVE_ICON_NAME))
		{
			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e)
			{
				MWACMenuHandler.this.handler.showSaveCompletionDialog();
			}
		});
		saveCompletionItem.setVisible(view.isSaveCompletionEnabled());
		
		// create the edit completion item
		editCompletionItem = new JMenuItem(new AbstractAction(
				"<html><b>" +
				Translator.translate(Translator.EDIT_COMPLETIONS) +
				"</b> <font size=1><i>" +
				KeyEvent.getModifiersExText(view.getEditCompletionKey().getModifiers()) + 
				"+" + KeyEvent.getKeyText(view.getEditCompletionKey().getKeyCode()),  
				IconManager.getIcon(IconManager.EDIT_ICON_NAME))
		{
			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e)
			{
				MWACMenuHandler.this.handler.showEditCompletionDialog();
			}
		});
		editCompletionItem.setVisible(view.isEditCompletionEnabled());
		
		// create the hot keys edit item
		editHotKeysItem = new JMenuItem(new AbstractAction(
				Translator.translate(Translator.HOTKEYS), 
				IconManager.getIcon(IconManager.HOTKEY_ICON_NAME))
		{
			private static final long serialVersionUID = 1L;
			
			public void actionPerformed(ActionEvent e)
			{
				Window owner = BaseDialogImpl.getParentWindow(view);
				if (owner instanceof JDialog)
					new HotKeyDialog((JDialog)owner, view).setVisible(true);
				else
					new HotKeyDialog((JFrame)owner, view).setVisible(true);
			}
		});
		editHotKeysItem.setVisible(view.isEditHotKeysEnabled());
		
		// add the items to the menu
		menu.add(quickAddCompletionItem);
		menu.add(saveCompletionItem);
		menu.add(editCompletionItem);
		if (editHotKeysItem.isVisible())
			menu.addSeparator();
		menu.add(editHotKeysItem);
	}
	
	
	/**
	 * @param show <code>true</code> to show the quick add item, <code>false</code> to disable it.
	 */
	public void showQuickAdd (boolean show)
	{
		quickAddCompletionItem.setVisible(show);
	}
	
	/**
	 * @param show <code>true</code> to show the save completion item, <code>false</code> to disable it.
	 */
	public void showSaveCompletion (boolean show)
	{
		saveCompletionItem.setVisible(show);
	}
	
	/**
	 * @param show <code>true</code> to show the edit completion item, <code>false</code> to disable it.
	 */
	public void showEditCompletion (boolean show)
	{
		editCompletionItem.setVisible(show);
	}
	
	/**
	 * @param show <code>true</code> to show the edit hot keys item, <code>false</code> to disable it.
	 */
	public void showEditHotKeys (boolean show)
	{
		editHotKeysItem.setVisible(show);
	}
	
	/**
	 * @return the handler that handles the events
	 */
	public MWACHandler getHandler ()
	{
		return handler;
	}
	
	/**
	 * @param handler the new handler to handle the events
	 */
	public void setHandler (MWACHandler handler)
	{
		this.handler = handler;
	}
	
	
	public void mouseReleased (MouseEvent e)
	{
		if (view.isMenuEnabled())
			menu.show((JComponent)e.getSource(), 0, 0);
	}

	public void mousePressed (MouseEvent e) {}
	public void mouseClicked (MouseEvent e) {}
	public void mouseEntered (MouseEvent e) {}
	public void mouseExited  (MouseEvent e) {}
}
