/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: GECAMedBaseDialog.java,v $
 * <br>Revision 1.14  2011-03-28 12:33:23  ferring
 * <br>New method added, making it possible to easily change what the actions of the buttons will do.
 * <br>
 * <br>Revision 1.13  2011-02-01 13:14:51  ferring
 * <br>Error messages added for the labo module
 * <br>
 * <br>Revision 1.12  2010-03-30 10:55:46  troth
 * <br>Redesign of the prescription view
 * <br>
 * <br>Revision 1.11  2010-03-23 15:06:16  troth
 * <br>add method addButton to add buttons to the bottom left of the dialog
 * <br>
 * <br>Revision 1.10  2010-02-09 12:07:22  ferring
 * <br>Forms added to PatientTab
 * <br>
 * <br>Revision 1.9  2010-01-25 12:54:24  ferring
 * <br>Yes-No-Cancel-Options added
 * <br>
 * <br>Revision 1.8  2008-12-17 15:23:06  heinemann
 * <br>initial commit after merging of branch new prescription
 * <br>
 * <br>Revision 1.7.2.1  2008-12-15 14:08:21  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.7  2008-11-12 17:16:33  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-09-15 12:06:45  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-08-27 15:34:53  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-05-07 14:39:53  heinemann
 * <br>new waitingroom
 * <br>
 * <br>Revision 1.2  2008-04-29 14:17:38  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-03-11 17:17:11  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2007-12-17 14:59:59  heinemann
 * <br>plugins and file store and open
 * <br>
 * <br>Revision 1.2  2007-10-16 08:23:27  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007/08/09 14:10:34  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
package lu.tudor.santec.org.fife.ui.autocomplete.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;

import lu.tudor.santec.org.fife.ui.autocomplete.IconManager;
import lu.tudor.santec.org.fife.ui.autocomplete.Translator;


import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * A basic dialog with ok and cancel button and a header
 * 
 * @author martin.heinemann@tudor.lu
 * 02.08.2007
 * 15:05:06
 *
 *
 * @version
 * <br>$Log: GECAMedBaseDialog.java,v $
 * <br>Revision 1.14  2011-03-28 12:33:23  ferring
 * <br>New method added, making it possible to easily change what the actions of the buttons will do.
 * <br>
 * <br>Revision 1.13  2011-02-01 13:14:51  ferring
 * <br>Error messages added for the labo module
 * <br>
 * <br>Revision 1.12  2010-03-30 10:55:46  troth
 * <br>Redesign of the prescription view
 * <br>
 * <br>Revision 1.11  2010-03-23 15:06:16  troth
 * <br>add method addButton to add buttons to the bottom left of the dialog
 * <br>
 * <br>Revision 1.10  2010-02-09 12:07:22  ferring
 * <br>Forms added to PatientTab
 * <br>
 * <br>Revision 1.9  2010-01-25 12:54:24  ferring
 * <br>Yes-No-Cancel-Options added
 * <br>
 * <br>Revision 1.8  2008-12-17 15:23:06  heinemann
 * <br>initial commit after merging of branch new prescription
 * <br>
 * <br>Revision 1.7.2.1  2008-12-15 14:08:21  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.7  2008-11-12 17:16:33  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-09-15 12:06:45  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-08-27 15:34:53  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-05-07 14:39:53  heinemann
 * <br>new waitingroom
 * <br>
 * <br>Revision 1.2  2008-04-29 14:17:38  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-03-11 17:17:11  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2007-12-17 14:59:59  heinemann
 * <br>plugins and file store and open
 * <br>
 * <br>Revision 1.2  2007-10-16 08:23:27  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007/08/09 14:10:34  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public abstract class BaseDialog extends JDialog implements DialogActionListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	// Options for the ButtonMode
	public static final int NO_BUTTON_MODE 				= 0;
	public static final int OK_BUTTON_MODE 				= 1;
	public static final int OK_CANCEL_BUTTON_MODE 		= 2;
	public static final int YES_NO_BUTTON_MODE 			= 3;
	public static final int YES_NO_CANCEL_BUTTON_MODE 	= 4;
	
	public static final int RED_CROSS_BUTTON 			= 0;
	public static final int OK_BUTTON 					= 1;
	public static final int CANCEL_BUTTON 				= 2;
	public static final int YES_BUTTON 					= 3;
	public static final int NO_BUTTON 					= 4;
	

    public static final Color BACKGROUND_COLOR = new Color (237,243,254);
		
	private String headerText = "";
	protected JLabel headerLabel;
	protected JButton okButton;
	protected JButton cancelButton;
	protected JButton yesButton;
	protected JButton noButton;
	protected AbstractAction cancelAction;
	protected AbstractAction okAction;
	protected AbstractAction yesAction;
	protected AbstractAction noAction;
	private KeyStroke strokeEnter;
	private KeyStroke strokeEsc;
	private JPanel header;
	private boolean createOkButton;
	private boolean createCancelButton;
	private boolean createYesButton;
	private boolean createNoButton;
	
	private boolean devMode = false;

	private JPanel actionPanel;
	
	protected DialogActionListener dialogActionListener = this;
	
	
	public BaseDialog(String title) {
		/* ================================================== */
		this(title, true);
		/* ================================================== */
	}
	
	/**
	 * @param title
	 * @param createButtons create ok and cancel button
	 */
	public BaseDialog(String title, boolean createButtons) {
		/* ================================================== */
		super();
		setTitle(title);
		setModal(true);
		
		initComponent();
		if (createButtons) {
			/* ------------------------------------------------------- */
			this.createOkButton = true;
			this.createCancelButton = true;
			// add the ok and cancel button
			initButtonPanel();
			initButtonActions(true);
			/* ------------------------------------------------------- */
		}
		/* ================================================== */
	}
	
	
	/**
	 * @param title
	 * @param createButtons create ok and cancel button
	 */
	public BaseDialog(JDialog parent, String title, boolean createButtons) {
		/* ================================================== */
		super(parent,
				title,
				true);
		initComponent();
		if (createButtons) {
			/* ------------------------------------------------------- */
			this.createOkButton = true;
			this.createCancelButton = true;
			// add the ok and cancel button
			initButtonPanel();
			initButtonActions(true);
			/* ------------------------------------------------------- */
		}
		/* ================================================== */
	}
	
	/**
	 * @param title
	 * @param createButtons create ok and cancel button
	 */
	public BaseDialog(JFrame parent, String title, boolean createButtons) {
		/* ================================================== */
		super(parent,
				title,
				true);
		initComponent();
		if (createButtons) {
			/* ------------------------------------------------------- */
			this.createOkButton = true;
			this.createCancelButton = true;
			// add the ok and cancel button
			initButtonPanel();
			initButtonActions(true);
			/* ------------------------------------------------------- */
		}
		/* ================================================== */
	}
	
	
	/**
	 * @param title
	 * @param createOkButton
	 * @param createCancelButton
	 */
	public BaseDialog(String title, boolean createOkButton, boolean createCancelButton) {
		/* ================================================== */
		this(title, createOkButton, createCancelButton, true);
		/* ================================================== */	
	}
	

	/**
	 * @param title
	 * @param createOkButton
	 * @param createCancelButton
	 * @param initButtonAction add actions to the buttons
	 */
	public BaseDialog(String title, boolean createOkButton, boolean createCancelButton, boolean initButtonAction) {
		/* ================================================== */
		super();
		setTitle(title);
		setModal(true);
		
		initComponent();
		this.createOkButton = createOkButton;
		this.createCancelButton = createCancelButton;
		
			/* ------------------------------------------------------- */
			// add the ok and cancel button
			initButtonPanel();
			
			initButtonActions(initButtonAction);
			
			/* ------------------------------------------------------- */
		
		/* ================================================== */
	}
	
	public BaseDialog (String title, int buttonMode)
	{
		super();
		this.setTitle(title);
		initBaseDialogWithButtonMode(buttonMode);
	}
	
	public BaseDialog (JDialog parent, String title, int buttonMode) {
		super(parent, title);
		initBaseDialogWithButtonMode(buttonMode);
	}
	
	public BaseDialog (JFrame parent, String title, int buttonMode) {
		super(parent, title);
		initBaseDialogWithButtonMode(buttonMode);
	}
	
	private void initBaseDialogWithButtonMode (int buttonMode) {

		setModal(true);
		initComponent();
		/* ------------------------------------------------------- */
		if (buttonMode != NO_BUTTON_MODE) {
			// select with buttons shell be added
			setButtonMode(buttonMode);
			// add the selected buttons
			initButtonPanel();
			
			initButtonActions(true);
		}		
		/* ------------------------------------------------------- */
	}
	
	
	/**
	 * Set the text for the header
	 * 
	 * @param headerTitle
	 */
	protected void setHeaderTitle(String headerTitle) {
		/* ================================================== */
		setNoHtmlHeaderTitle("<html>"+headerTitle);
//		this.headerText = headerTitle;
//		headerLabel.setText("<html>"+headerText);
//		headerLabel.updateUI();
		/* ================================================== */
	}
	
	
	protected void setNoHtmlHeaderTitle(String headerTitle) {
		/* ================================================== */
		this.headerText = headerTitle;
		this.headerLabel.setText(headerText);
		this.headerLabel.updateUI();
		/* ================================================== */
	}
	
	
	/**
	 * Replaces the normal JLabels as header with the component of your choice.
	 * The methods setHeaderTitle etc will have no effect anymore.
	 * @param component
	 */
	protected void setHeaderComponent(JComponent component) {
		/* ================================================== */
		// try to remove old label
		/* ------------------------------------------------------- */
		try {
			/* --------------------------------------------- */
			this.header.remove(headerLabel);
			/* --------------------------------------------- */
		} catch (Exception e) {}
		/* ------------------------------------------------------- */
		CellConstraints cc = new CellConstraints();
		header.add(component, cc.xy(2, 2));
		/* ================================================== */
	}
	
	/**
	 * Set the icon for the header
	 * 
	 * @param headerIcon
	 */
	protected void setHeaderIcon(Icon headerIcon) {
		/* ================================================== */
		headerLabel.setIcon(headerIcon);
		headerLabel.updateUI();
		/* ================================================== */
	}
	
	/**
	 * Show the header
	 * 
	 * @param b
	 */
	protected void showHeader(boolean b) {
		/* ================================================== */
		/* ------------------------------------------------------- */
		// header
		this.header = new JPanel(new FormLayout("3dlu, fill:pref:grow, 3dlu" , "3dlu, fill:pref, 3dlu"));
		header.setOpaque(false);
		/* ------------------------------------------------------- */
		this.headerLabel = new JLabel("<html>"+this.headerText);
		headerLabel.setOpaque(true);
		headerLabel.setBackground(Color.WHITE);
		headerLabel.setBorder(BorderFactory.createTitledBorder(""));
		/* ------------------------------------------------------- */
		headerLabel.setVerticalTextPosition(SwingConstants.TOP);
		headerLabel.setHorizontalTextPosition(SwingConstants.RIGHT);
		CellConstraints cc = new CellConstraints();
		header.add(headerLabel, cc.xy(2, 2));
		/* ------------------------------------------------------- */
		
		this.add(header, BorderLayout.NORTH);
		/* ------------------------------------------------------- */
		this.getContentPane().validate();
		/* ================================================== */
	}
	
	/**
	 * Add a panel to the center of the dialog.
	 * 
	 * @param mainPanel
	 */
	public void addMainPanel(JComponent mainPanel) {
		/* ================================================== */
		this.add(mainPanel, BorderLayout.CENTER);
		/* ================================================== */
	}

	/**
	 * Add a button to the bottom left of the dialog.
	 * 
	 * @param action
	 */
	public void addButton(AbstractButton button) {
		/* ================================================== */
		this.actionPanel.add(button);
		/* ================================================== */
	}
	
	/**
	 * 
	 */
	private void initComponent() {
		/* ====================================================== */
		this.setLayout(new BorderLayout());
		this.getContentPane().setBackground(Color.WHITE);
		this.getContentPane().setBackground(BACKGROUND_COLOR);
		/* ------------------------------------------------------- */
		/* ====================================================== */
	}
	
	/**
	 * 
	 */
	private void initButtonPanel() {
		/* ================================================== */
		/* ------------------------------------------------------- */
		// ==========================================================
		// button panel
		// ==========================================================
		this.okButton 		= new JButton();
		this.cancelButton 	= new JButton();
		this.yesButton 		= new JButton();
		this.noButton 		= new JButton();
		ButtonBarBuilder bb = new ButtonBarBuilder();
		/* ------------------------------------------------------- */
		
		this.actionPanel = new JPanel(new FlowLayout(FlowLayout.LEFT, 3,3));
		this.actionPanel.setOpaque(false);
		
		bb.addGlue();
		bb.addRelatedGap();
		if (createOkButton) {
			bb.addGridded(okButton);
			bb.addRelatedGap();
		}
		if (createYesButton) {
			bb.addGridded(yesButton);
			bb.addRelatedGap();
		}
		if (createNoButton) {
			bb.addGridded(noButton);
			bb.addRelatedGap();
		}
		if (createCancelButton) {
			bb.addGridded(cancelButton);
			bb.addRelatedGap();
		}
		/* ------------------------------------------------------- */
		bb.getPanel().setOpaque(false);
		/* ------------------------------------------------------- */
		// a panel to make a gap between the dialog border and the buttons
		JPanel gapPanel = new JPanel(new BorderLayout(5,5));
		gapPanel.setOpaque(true);
		gapPanel.setBackground(Color.WHITE);
		gapPanel.add(this.actionPanel, BorderLayout.WEST);
		gapPanel.add(bb.getPanel(), BorderLayout.CENTER);
		gapPanel.add(new JLabel(""), BorderLayout.SOUTH);
		gapPanel.add(new JLabel(""), BorderLayout.EAST);
		gapPanel.add(new JLabel(""), BorderLayout.NORTH);
		/* ------------------------------------------------------- */

		this.add(gapPanel, BorderLayout.SOUTH);
		/* ================================================== */
	}
	
	
	/**
	 * 
	 */
	public void initButtonActions(boolean b) {
		/* ================================================== */
		if (b) {
			this.cancelAction = new AbstractAction(Translator.translate(Translator.CANCEL),
					IconManager.getIcon(IconManager.CANCEL_BUTTON_ICON_NAME)) {
	
				private static final long serialVersionUID = 1L;
	
				public void actionPerformed(ActionEvent e) {
					/* ====================================================== */
					dialogActionListener.cancelActionCalled();
					/* ====================================================== */
				}
			};
			/* ------------------------------------------------------- */
			this.okAction = new AbstractAction(Translator.translate(Translator.OK),
					IconManager.getIcon(IconManager.OK_BUTTON_ICON_NAME)) {
	
				private static final long serialVersionUID = 1L;
	
				public void actionPerformed(ActionEvent e) {
					/* ====================================================== */
					dialogActionListener.okActionCalled();
					/* ====================================================== */
				}
			};
			this.yesAction = new AbstractAction(Translator.translate(Translator.YES),
					IconManager.getIcon(IconManager.OK_BUTTON_ICON_NAME)) {
				
				private static final long serialVersionUID = 1L;

				public void actionPerformed(ActionEvent e) {
					/* ====================================================== */
					dialogActionListener.yesActionCalled();
					/* ====================================================== */
				}
			};
			this.noAction = new AbstractAction(Translator.translate(Translator.NO),
					IconManager.getIcon(IconManager.NO_BUTTON_ICON_NAME)) {
				
				private static final long serialVersionUID = 1L;

				public void actionPerformed(ActionEvent e) {
					/* ====================================================== */
					dialogActionListener.noActionCalled();
					/* ====================================================== */
				}
			};
	
			this.okButton.setAction(okAction);
			this.cancelButton.setAction(cancelAction);
			this.yesButton.setAction(yesAction);
			this.noButton.setAction(noAction);
			
			this.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
			this.addWindowListener(new WindowListener() 
			{
				public void windowClosing(WindowEvent e) 
				{
					dialogActionListener.closeActionCalled();
				}
				
				public void windowOpened(WindowEvent e) {}
				public void windowIconified(WindowEvent e) {}
				public void windowDeiconified(WindowEvent e) {}
				public void windowDeactivated(WindowEvent e) {}
				public void windowClosed(WindowEvent e) {}
				public void windowActivated(WindowEvent e) {}
			});
		} else {
			// just set the icon and the text
			okButton.setText(Translator.translate(Translator.OK));
			cancelButton.setText(Translator.translate(Translator.CANCEL));
			yesButton.setText(Translator.translate(Translator.YES));
			noButton.setText(Translator.translate(Translator.NO));
			
			okButton.setIcon(IconManager.getIcon(IconManager.OK_BUTTON_ICON_NAME));
			cancelButton.setIcon(IconManager.getIcon(IconManager.CANCEL_BUTTON_ICON_NAME));
			yesButton.setIcon(IconManager.getIcon(IconManager.OK_BUTTON_ICON_NAME));
			noButton.setIcon(IconManager.getIcon(IconManager.NO_BUTTON_ICON_NAME));
		}
		// =================================================================


		// =================================================================
		// define dialog wide key mappings
		// =================================================================
		// ESC will close the dialog
		this.strokeEsc = KeyStroke.getKeyStroke("ESCAPE");
		enableCancelKeyMapping(true);
		/* ------------------------------------------------------- */
		// Enter will close the dialog and confirm something
		this.strokeEnter = KeyStroke.getKeyStroke("ENTER");
		enableOkKeyMapping(true);
		/* ================================================== */
	}
	
	
	/**
	 * Enabled the okButton action when ENTER is pressed
	 * 
	 * @param b
	 */
	protected void enableOkKeyMapping(boolean b) {
		/* ================================================== */
		if (b) {
			/* ------------------------------------------------------- */
			// add keymapping
			((JPanel) this.getContentPane()).getInputMap(
					JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
					.put(this.strokeEnter, "ok");
			((JPanel) this.getContentPane()).getActionMap().put("ok", okAction);
			/* ------------------------------------------------------- */
		} else {
			/* ------------------------------------------------------- */
			// remove keymapping
			((JPanel) this.getContentPane()).getInputMap(
					JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
					.remove(this.strokeEnter);
			((JPanel) this.getContentPane()).getActionMap().remove("ok");
			/* ------------------------------------------------------- */
		}
		/* ================================================== */
	}
	
	/**
	 * Enabled the cancelButton action when ESC is pressed
	 * 
	 * @param b
	 */
	protected void enableCancelKeyMapping(boolean b) {
		/* ================================================== */
		if (b) {
			/* ------------------------------------------------------- */
			// add keymapping
			((JPanel) this.getContentPane()).getInputMap(
					JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
					.put(this.strokeEsc, "cancel");
			((JPanel) this.getContentPane()).getActionMap().put("cancel", cancelAction);
			/* ------------------------------------------------------- */
		} else {
			/* ------------------------------------------------------- */
			// remove keymapping
			((JPanel) this.getContentPane()).getInputMap(
					JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
					.remove(this.strokeEsc);
			((JPanel) this.getContentPane()).getActionMap().remove("cancel");
			/* ------------------------------------------------------- */
		}
		/* ================================================== */
	}
	
	
	/**
	 * enables dev mode
	 * 
	 * @param b
	 */
	public void enableDevMode(boolean b) {
		/* ================================================== */
		this.devMode = b;
		if (devMode) {
			/* ------------------------------------------------------- */
			this.addComponentListener(new ComponentListener() {

				public void componentHidden(ComponentEvent e) {
					/* ====================================================== */
					// TODO Auto-generated method stub
					/* ====================================================== */
				}

				public void componentMoved(ComponentEvent e) {
					/* ====================================================== */
					System.out.println("Dialog position: [" + BaseDialog.this.getX()
							+", "+BaseDialog.this.getY()+"]");
					/* ====================================================== */
				}

				public void componentResized(ComponentEvent e) {
					/* ====================================================== */
					System.out.println("Dialog size: " + BaseDialog.this.getSize().width+"x"+
							BaseDialog.this.getSize().height);
					/* ====================================================== */
				}

				public void componentShown(ComponentEvent e) {
					/* ====================================================== */
					// TODO Auto-generated method stub
					/* ====================================================== */
				}
				
			});
			/* ------------------------------------------------------- */
		}
		/* ================================================== */
	}
	
	/**
	 * sets the create-button values to true or false, depending on the chosen mode
	 * @param mode
	 */
	public void setButtonMode (int mode) {
		
		// reset buttons
		createOkButton = false;
		createCancelButton = false;
		createYesButton = false;
		createNoButton = false;
		
		// activate buttons depending on case
		switch (mode) {
		case NO_BUTTON_MODE:
			break;
		case OK_CANCEL_BUTTON_MODE:
			createCancelButton = true;
		case OK_BUTTON_MODE:
			createOkButton = true;
			break;
		case YES_NO_CANCEL_BUTTON_MODE:
			createCancelButton = true;
		case YES_NO_BUTTON_MODE:
			createYesButton = true;
			createNoButton = true;
			break;
		}
	}
	
	
	public void setDialogActionListener (DialogActionListener l)
	{
		if (l == null)
			dialogActionListener = this;
		else
			dialogActionListener = l;
	}

	
	public void yesActionCalled() 
	{
		setVisible(false);
	}
	
	public void okActionCalled() 
	{
		setVisible(false);
	}
	
	public void noActionCalled() 
	{
		setVisible(false);
	}
	
	public void closeActionCalled() 
	{
		setVisible(false);
	}
	
	public void cancelActionCalled() 
	{
		setVisible(false);
	}
}
