package lu.tudor.santec.org.fife.ui.autocomplete.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.font.TextAttribute;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class BaseDialogImpl extends BaseDialog {

	private static final long serialVersionUID = 1L;

	private static final String NEW_LINE = System.getProperty("line.separator");
	
	protected int buttonOption = -1;
	
	protected JPanel mainPanel = new JPanel();
	
	
//	@Deprecated
//	public GECAMedBaseDialogImpl(String title) {
//		/* ================================================== */
//		super(title, false);
//		/* ================================================== */
//	}
	
//	public BaseDialogImpl (String title, int buttonMode, JPanel mainPanel)
//	{
//		super(title, buttonMode);
//		init(buttonMode, mainPanel);
//	}
	
	public BaseDialogImpl (JDialog parent, String title, int buttonMode, JPanel mainPanel)
	{
		super (parent, title, buttonMode);
		init(buttonMode, mainPanel);
	}
	
	public BaseDialogImpl (JFrame parent, String title, int buttonMode, JPanel mainPanel)
	{
		super (parent, title, buttonMode);
		init(buttonMode, mainPanel);
	}
	
	private void init (int buttonMode, JPanel mainPanel)
	{
		this.setDialogActionListener(this);
		
		this.mainPanel = mainPanel;
		this.mainPanel.setBackground(BACKGROUND_COLOR);
		super.addMainPanel(mainPanel);
	} 
	
	
	public static int showMessageDialog (Component parentComponent, String title, String message, int buttonMode)
	{
		return showMessageDialog(parentComponent, title, message, buttonMode, null);
	}
	
	@SuppressWarnings("unchecked")
	public static int showMessageDialog (Component parentComponent, String title, String message, int buttonMode, Icon icon)
	{
		Map<TextAttribute, Object> 	attributes;
		JLabel 						label;
		JScrollPane 				scroller;
		JPanel 						mainPanel 	= new JPanel();
		Window 						window 		= getParentWindow(parentComponent);
		CellConstraints				cc 			= new CellConstraints();
		BaseDialogImpl 				dialog;
		
		// define the panel and add the message
//		mainPanel.setBackground(BACKGROUND_COLOR);
		mainPanel.setLayout(new FormLayout(
				"10px, f:p, 5px, f:p:g, 10px",
				"10px, f:min(p; 400px):g, 10px"));
		
		// format message
		message = "<html>" + message.replaceAll("<br>"+NEW_LINE, "<br>")
				.replaceAll(NEW_LINE+"<br>", "<br>")
				.replaceAll(NEW_LINE, "<br>");
		
		label = new JLabel(message);
		label.setOpaque(false);
		attributes = (Map<TextAttribute, Object>) label.getFont().getAttributes();
		attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
		label.setFont(new Font(attributes));
		scroller = new JScrollPane(label);
		scroller.setOpaque(false);
//		scroller.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		scroller.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		scroller.getViewport().setOpaque(false);
		scroller.setBorder(BorderFactory.createEmptyBorder());
		if (icon == null)
		{
			mainPanel.add(scroller, cc.xyw(2, 2, 3));
		} 
		else
		{
			mainPanel.add(scroller, cc.xy(4, 2));
			
			label = new JLabel(icon);
			label.setOpaque(false);
			mainPanel.add(label, cc.xy(2, 2));
		}
		
		// create the dialog
		if (window instanceof JDialog)
			dialog = new BaseDialogImpl((JDialog)parentComponent, title, buttonMode, mainPanel);
		else // if (window instanceof JFrame)
			dialog = new BaseDialogImpl((JFrame)parentComponent, title, buttonMode, mainPanel);
		
		// show the dialog
		dialog.pack();
		dialog.setLocationRelativeTo(dialog.getOwner());
		
		return dialog.getButtonOption();
	}
	
	public static Window getParentWindow (Component component)
	{
		if (component == null)
			return null;
		
		while (component != null && !(component instanceof Window))
			component = component.getParent();
		
		return (Window)component;
	}
	

	@Override
	public void yesActionCalled() 
	{
		buttonOption = YES_BUTTON;
		setVisible(false);
	}

	@Override
	public void okActionCalled() 
	{
		buttonOption = OK_BUTTON;
		setVisible(false);
	}

	@Override
	public void noActionCalled() 
	{
		buttonOption = NO_BUTTON;
		setVisible(false);
	}

	@Override
	public void closeActionCalled() 
	{
		buttonOption = RED_CROSS_BUTTON;
		setVisible(false);
	}

	@Override
	public void cancelActionCalled() 
	{
		buttonOption = CANCEL_BUTTON;
		setVisible(false);
	}

	public int getButtonOption ()
	{
		return this.buttonOption;
	}
	
//	private void addButtonOptionListener (JButton button, final int option)
//	{
//		button.addActionListener(new ActionListener()
//		{
//			public void actionPerformed(ActionEvent e)
//			{
//				buttonOption = option;
//			}
//		});
//	}
}