package lu.tudor.santec.org.fife.ui.autocomplete.dialog;

import javax.swing.JDialog;
import javax.swing.JFrame;

import lu.tudor.santec.org.fife.ui.autocomplete.AutoCompletionTextComponent;
import lu.tudor.santec.org.fife.ui.autocomplete.Completion;

/**
 * @author ferring
 * 
 * This dialog is called to change a completion selected by the edit completion dialog.<br>
 * It is similar to the SaveCompletionDialog.
 */
public class ChangeCompletionDialog extends SaveCompletionDialog
{
	private static final long serialVersionUID = 1L;
	
	protected Completion completion;
	
	protected boolean changed;
	
	
	

	/**
	 * @param textComponent The AutoCompletionTextComponent
	 * @param completionToChange The completion to change
	 */
	public ChangeCompletionDialog (JFrame owner, AutoCompletionTextComponent textComponent, Completion completionToChange)
	{
		super(owner, textComponent);
		init(textComponent, completionToChange);
	}
	
	
	/**
	 * @param textComponent The AutoCompletionTextComponent
	 * @param completionToChange The completion to change
	 */
	public ChangeCompletionDialog (JDialog owner, AutoCompletionTextComponent textComponent, Completion completionToChange)
	{
		super(owner, textComponent);
		init(textComponent, completionToChange);
	}
	
	private void init (AutoCompletionTextComponent textComponent, Completion completionToChange)
	{
		this.completion 		= completionToChange;
		
		if (completion == null)
			throw new NullPointerException();
		
		String inputText;
//		if (completion instanceof MultiWordCompletion
//				&& !((MultiWordCompletion)completion).isInputTextSet())
		if (completion.getInputText() == completion.getReplacementText())
			// if it really is the same
			inputText 			= "";
		else
			inputText 			= completion.getInputText();
		inputTextField.setText(inputText);
		
		replacementTextArea.setText(completion.getReplacementText());
		enableOkButton();
	}
	
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.org.fife.ui.autocomplete.dialog.SaveCompletionDialog#saveCompletion()
	 */
	@Override
	protected void saveCompletion()
	{
		// replace the old completion, if sth. has changed
		String inputText 		= inputTextField.getText().trim();
		String replacementText 	= replacementTextArea.getText();
		changed 				= false;
		
		if (	   inputText == null 
				|| inputText.equals("")
				|| inputText.equals(replacementText))
			inputText 			= replacementText;
		
		if (	   inputText.equals(completion.getInputText())
				&& replacementText.equals(completion.getReplacementText()))
			// nothing has changed ...
			return;
		
		changed 				= true;
		view.changeCompletion(completion, inputText, replacementText);
	}
	
	/**
	 * @return <code>true</code> if the completion was changed, else <code>false</code>.
	 */
	public boolean isChanged ()
	{
		return changed;
	}
}
