package lu.tudor.santec.org.fife.ui.autocomplete.dialog;

/**
 * @author santec
 * 
 * Used from the GECAMedBaseDialog to define what happens, if an predefined action is called.
 */
public interface DialogActionListener {
	
	/**
	 * Called if, in a GECAMedBaseDialog, the OK button is pressed or the ENTER key is hit.
	 */
	public void okActionCalled ();

	/**
	 * Called if, in a GECAMedBaseDialog, the cancel button is pressed or the ESC key is hit.
	 */
	public void cancelActionCalled ();

	/**
	 * Called if, in a GECAMedBaseDialog, the yes button is pressed or the ENTER key is hit.
	 */
	public void yesActionCalled ();

	/**
	 * Called if, in a GECAMedBaseDialog, the no button is pressed.
	 */
	public void noActionCalled ();

	/**
	 * Called if, in a GECAMedBaseDialog, the red cross to close the dialog is pressed.
	 */
	public void closeActionCalled ();
}
