

import java.awt.BorderLayout;
import java.awt.Toolkit;

import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;

public class ReportViewer extends JDialog {

	private static final long serialVersionUID = 1L;
//	private ModuleHeader titlePanel;
	private JEditorPane editor;
	private int height = 600;
	private String title = "Report.Title";
	private JFrame parent;

	public ReportViewer() {
		initViewer();
	}
	
	public ReportViewer(JFrame parent) {
		super(parent);
		this.parent = parent;
		initViewer();
	}
		
	private void initViewer() {
		setTitle(title);

		this.setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
		
		this.setLayout(new BorderLayout());

//		this.titlePanel = new ModuleHeader(title, PatientManagerModule.getIcon(PatientManagerModule.REPORT), new Color(180,255,180));
//		this.add(titlePanel, BorderLayout.NORTH);
//		
		this.editor = new JEditorPane();
		this.editor.setEditable(false);
		this.editor.setEditorKit(new HTMLEditorKit());
		
		this.add(new JScrollPane(this.editor), BorderLayout.CENTER);
		
		if (this.parent != null) {
			height = parent.getHeight() - 5;
			this.setLocation((int)parent.getLocation().getX() + 5, (int) parent.getLocation().getX() + 5);
		} else {
			height = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 20;
		}
		
		this.setSize((int)(height/1.4142),  height);
		
	};
	
	
	public void showDocument(String doc) {
		this.editor.setText(doc);
		super.setVisible(true);
	}
	
	@Override
	public void setVisible(boolean b) {
		if (!b) {
			showDocument("");
		}
		super.setVisible(b);
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
//		ReportViewer viewer = new ReportViewer();
//		
//		File f = new File("/home/hermenj/test.rtf");
//        byte[] b = new byte[(int) f.length()];
//
//		ReportTransformer rt = new ReportTransformer();
//		
//		try {
//			String xml = rt.transform2XML(new FileInputStream(f));
//
//			xml = "<html><body>" + xml;
//			
//			xml = xml.replaceAll(".*</info>", "");
//			xml = xml.replaceAll("<cell", "<td");
//			xml = xml.replaceAll("<row", "<tr");
//			
//			
//			System.out.println(xml);
//			viewer.showDocument(xml);
////			
//			viewer.setVisible(true);
//		
//		
//		} catch (FileNotFoundException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		
	}

	
	

}
