//===============================================================
// package : com.tetrasix.majix
// class : com.tetrasix.majix.MajixStandard
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */



package com.tetrasix.majix;

import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.util.ResourceBundle;

import javax.swing.UIManager;

import com.tetrasix.majix.uis.ConfigEditor;
import com.tetrasix.majix.uis.ConverterFrame;
import com.tetrasix.util.Configuration;
import com.tetrasix.util.MessageBox;


/**
 * This class defines the main entrypoint of the program for the GUI-mode.
 */
public class MajixStandard {


    /**
     * This is the main entry point for the interactive version of
     * Majix using the Swing library.
     *
     * @param   arg  
     */
	public static void main(String arg[])
	{
		if (System.getProperty("java.version").startsWith("1.0")) {
			System.out.println("This application requires Java 1.1 or higher\n");
			System.exit(1);
		}

		ResourceBundle res = 
			ResourceBundle.getBundle("com.tetrasix.majix.MajixStandardResources");

		boolean conf_loaded = false;

		File conf = new File(Configuration.getConfigurationFileName("majix"));
		if (conf.exists()) {
			Configuration.init("majix", true);
			conf_loaded = true;

		}
		else {
			Configuration.init("majix", false);
			DefaultConfiguration.makeit();
		}

		Configuration.setDefaultLocale(arg);
        
        boolean lookAndFeelSet = false;
		try {
			
			for (int ii = 0; ii < arg.length; ii++) {
                if (arg[ii].equals("-metal")) {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    lookAndFeelSet = true;
                }
                else if (arg[ii].equals("-smallmetal")) {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    UIManager.put("Button.font", new Font("Dialog", Font.BOLD, 10));
                    UIManager.put("Label.font", new Font("Dialog", Font.BOLD, 10));
                    UIManager.put("ComboBox.font", new Font("Dialog", Font.BOLD, 10));
                    UIManager.put("CheckBox.font", new Font("Dialog", Font.BOLD, 10));
                    UIManager.put("List.font", new Font("Dialog", Font.BOLD, 10));
                    UIManager.put("TextField.font", new Font("Dialog", Font.PLAIN, 10));
                    lookAndFeelSet = true;
                }
				else if (arg[ii].equals("-motif")) {
					UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    lookAndFeelSet = true;
				}
				else if (arg[ii].equals("-windows")) {
					UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    lookAndFeelSet = true;
				}
				else if (arg[ii].equals("-mac")) {
					UIManager.setLookAndFeel("com.sun.java.swing.plaf.macintosh.MacintoshLookAndFeel");
                    lookAndFeelSet = true;
				}
			}
            
            if (! lookAndFeelSet) {
                String lookandfeel = Configuration.getProperty("majix.lookandfeel");
                if (! lookandfeel.equals("")) {
                    UIManager.setLookAndFeel(lookandfeel);
                }
            }
		}
		catch (Exception e) {
			System.err.println("Unable to change look and feel");
		}



		ConverterFrame _frame = new ConverterFrame();
		_frame.enableDevelopmentEnvironment(Configuration.getProperty("majix.enable.development").equals("1"));
		_frame.enableMultipleTranslations(Configuration.getProperty("majix.enable.multi").equals("1"));

		_frame.init();
		_frame.center();
		_frame.show();

		if (! conf_loaded) {
			Frame editor = new ConfigEditor(_frame, false);
			String msgs[] = new String[3];
			msgs[0] = res.getString("msg_no_conf1");
			msgs[1] = "     " + Configuration.getConfigurationFileName("majix");
			msgs[2] = res.getString("msg_no_conf2");
			new MessageBox(editor, msgs);
		}
	}

	/**
	 * This method prints the usage of the parameters to the starting console.
	 */
	static void usage()
	{
		System.out.println("usage : com.tetrasix.majix.Majix [ -language <language> ] [ -country <country> ]");
	}
}