//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfCompoundObject
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.util.Vector;
import java.io.PrintWriter;

public class RtfCompoundObject extends RtfObject {

	protected Vector _content;

	RtfCompoundObject()
	{
		_content = new Vector();
	}

	void add(RtfObject object)
	{
		_content.addElement(object);
	}

	public int size()
	{
		return _content.size();
	}

	public RtfObject getObject(int pos)
	{
		return (RtfObject) _content.elementAt(pos);
	}

	void Dump(PrintWriter out)
	{
		for (int ii = 0; ii < _content.size(); ii++) {
			((RtfObject)_content.elementAt(ii)).Dump(out);
		}
	}

	public String getData()
	{
		StringBuffer buf = new StringBuffer();
		for (int ii = 0; ii < _content.size(); ii++) {
			buf.append(((RtfObject)_content.elementAt(ii)).getData());
		}
		return buf.toString();
	}
}

