//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfDocument
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.*;
import com.tetrasix.majix.xml.*;

public class RtfDocument extends RtfCompoundObject {

	RtfStyleSheet _theStyles = null;
	RtfExternalEntities _theEntities = null;
	RtfInfo _theInfo = null;
	String _filename;
	// one column is standard.
	int columncount = 1;

	public RtfDocument(String filename)
	{
		_filename = filename;
	}

	public void setStyleSheet(RtfStyleSheet styles)
	{
		_theStyles = styles;
	}

	public RtfStyleSheet getStyleSheet()
	{
		return _theStyles;
	}

	public void setExternalEntities(RtfExternalEntities entities)
	{
		_theEntities = entities;
	}

	public RtfExternalEntities getExternalEntities()
	{
		return _theEntities;
	}

	public void Dump(PrintWriter out)
	{
		out.println("<rtfdoc>");
		_theStyles.Dump(out);
		_theEntities.Dump(out);
		if (_theInfo != null) {
			_theInfo.Dump(out);
		}
		super.Dump(out);
		out.println("</rtfdoc>");
	}

	public void generate(XmlGenerator gen, XmlWriter out, XmlGeneratorContext context)
	{
		gen.rtfgenerate(this, out, context);
	}

	public void setInfo(RtfInfo info)
	{
		_theInfo = info;
	}

	public RtfInfo getInfo()
	{
		return _theInfo;
	}

	public String getFilePath()
	{
		return _filename;
	}

	public String getFileName()
	{
		String filename = _filename;

		int pos = filename.lastIndexOf(File.separatorChar);
		if (pos >= 0) {
			return filename.substring(pos + 1);
		}
		else {
			return filename;
		}
	}
	
	/**
	 * This method sets the columncount of the document. 
	 * 
	 * @param columns the columncount of the document.
	 */
	public void setColumnCount(int columns)
	{
		columncount = columns;
	}
	
	/**
	 * This method returns the columncount of the document. 
	 * 
	 * @return columncount the columncount of the document.
	 */
	public int getColumnCount()
	{
		return columncount;
	}
}

