//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfFieldInstance
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.*;
import com.tetrasix.majix.xml.*;

public class RtfFieldInstance extends RtfObject {

	String _fieldname;
	String _fieldresult;
	String _parameters;
	int _counter;

	RtfFieldInstance(String data)
	{
		int pos = data.indexOf(' ');
		if (pos <= 0) {
			_fieldname = data;
			_parameters = "";
		}
		else {
			_fieldname = data.substring(0, pos);
			_parameters = data.substring(pos + 1).trim();
		}
		_fieldresult = null;
	}

	RtfFieldInstance(String data, String result)
	{
		this(data);
		_fieldresult = result;
	}

	public String getFieldName()
	{
		return _fieldname;
	}

	public String getParameters()
	{
		return _parameters;
	}

	void Dump(PrintWriter out)
	{
		out.print("<field name='" + _fieldname + "' params='" + _parameters + "'");
		if (_fieldresult != null) {
			out.print(" result=\'" + _fieldresult + "'");
		}
		out.print(">");
	}

	public void generate(XmlGenerator gen, XmlWriter out, XmlGeneratorContext context)
	{
		gen.rtfgenerate(this, out, context);
	}

	public void setResult(String result)
	{
		_fieldresult = result;
	}

	public String getResult()
	{
		return _fieldresult;
	}
}

