//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfHyperLink
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.*;
import com.tetrasix.majix.xml.*;

public class RtfHyperLink extends RtfObject {

	String _url;
	String _refid;
	String _text;

	RtfHyperLink(String url, String text)
	{
		_url = url;
		_text = text;

		int pos = _url.lastIndexOf('#');
		String id = "";
		if (pos >= 0) {
			_refid = _url.substring(pos + 1);
			_url = _url.substring(0, pos);
		}
		else {
			_refid = "";
		}
	}

	public String getUrl()
	{
		return _url;
	}

	public String getRefid()
	{
		return _refid;
	}

	public String getText()
	{
		return _text;
	}

	void Dump(PrintWriter out)
	{
		out.print("<hyperlink url='" + _url + "'");
		if (_text != null) {
			out.print(" text=\'" + _text + "'");
		}
		out.print(">");
	}

	public void generate(XmlGenerator gen, XmlWriter out, XmlGeneratorContext context)
	{
		gen.rtfgenerate(this, out, context);
	}
}

