//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfInfo
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.*;

public class RtfInfo {

	static public final int TITLE    = 0;
	static public final int SUBJECT  = 1;
	static public final int AUTHOR   = 2;
	static public final int OPERATOR = 3;
	static public final int MANAGER  = 4;
	static public final int COMPANY  = 5; 

	private String[] _theProperties = new String[6];

	RtfInfo()
	{
	}

	void defineProperty(int code, String value)
	{
		if ((code >= 0) && (code <= 5)) {
			_theProperties[code] = value;
		}
	}

	public String getProperty(int code)
	{
		if ((code >= 0) && (code <= 255)) {
			return _theProperties[code];
		}

		return null;
	}

	private void Dump(PrintWriter out, String name, int code)
	{
		if (_theProperties[code] != null) {
			out.println("<" + name + ">" + _theProperties[code]
				+ "</" + name + ">");
		}
	}

	void Dump(PrintWriter out)
	{
		out.println("<info>");
		Dump(out, "title", TITLE);
		Dump(out, "subject", SUBJECT);
		Dump(out, "author", AUTHOR);
		Dump(out, "operator", OPERATOR);
		Dump(out, "manager", MANAGER);
		Dump(out, "company", COMPANY); 
		out.println("</info>");
	}
}

