//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfRowProperties
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.PrintWriter;
import java.util.Vector;

public class RtfRowProperties implements Cloneable  {

    // row borders
    public static final int ROWBORDER_NONE = 0;
    public static final int ROWBORDER_TOP = 1;
    public static final int ROWBORDER_BOTTOM = 2;
    public static final int ROWBORDER_LEFT = 4;
    public static final int ROWBORDER_RIGHT = 8;
    public static final int ROWBORDER_HORIZONTAL = 16;
    public static final int ROWBORDER_VERTICAL = 32;
    
	private RtfCellProperties _cellProps[];
	// for compatibility with word-versions that dont set size with clwWidth
	// but with cellx-controlword
	private int _cellWidths[];
	// we save the celllimits for processing the table to detect column spanning cells
	private int _cellLimits[];
	
	private int _borderWidthTop = 0;
    private int _borderWidthBottom = 0;
    private int _borderWidthLeft = 0;
    private int _borderWidthRight = 0;
    private int _borderWidthHorizontal = 0;
    private int _borderWidthVertical = 0;

    private int _borderMarginTop = 0;
    private int _borderMarginBottom = 0;
    private int _borderMarginLeft = 0;
    private int _borderMarginRight = 0;
    
	RtfRowProperties()
	{
		_cellWidths = null;
	    _cellProps = null;
	    _borderWidthTop = 0;
	    _borderWidthBottom = 0;
	    _borderWidthLeft = 0;
	    _borderWidthRight = 0;
	    _borderWidthHorizontal = 0;
	    _borderWidthVertical = 0;
	    _borderMarginTop = 0;
	    _borderMarginBottom = 0;
	    _borderMarginLeft = 0;
	    _borderMarginRight = 0;
	}

	protected Object clone()
	{
		RtfRowProperties properties = new RtfRowProperties();

		if (_cellWidths != null) {
			properties._cellWidths = new int[_cellWidths.length];
			for (int ii = 0; ii < _cellWidths.length; ii++) {
				properties._cellWidths[ii] = _cellWidths[ii];
			}
		}

		if (_cellLimits != null) {
			properties._cellLimits = new int[_cellLimits.length];
			for (int ii = 0; ii < _cellLimits.length; ii++) {
				properties._cellLimits[ii] = _cellLimits[ii];
			}
		}

		if (_cellProps != null) {
			properties._cellProps = new RtfCellProperties[_cellProps.length];
			for (int ii = 0; ii < _cellProps.length; ii++) {
				properties._cellProps[ii] = _cellProps[ii];
			}
		}
		
		properties.setBorderWidth(RtfRowProperties.ROWBORDER_BOTTOM,
		        getBorderWidth(RtfRowProperties.ROWBORDER_BOTTOM));
		properties.setBorderWidth(RtfRowProperties.ROWBORDER_TOP,
		        getBorderWidth(RtfRowProperties.ROWBORDER_TOP));
		properties.setBorderWidth(RtfRowProperties.ROWBORDER_LEFT,
		        getBorderWidth(RtfRowProperties.ROWBORDER_LEFT));
		properties.setBorderWidth(RtfRowProperties.ROWBORDER_RIGHT,
		        getBorderWidth(RtfRowProperties.ROWBORDER_RIGHT));
		properties.setBorderWidth(RtfRowProperties.ROWBORDER_HORIZONTAL,
		        getBorderWidth(RtfRowProperties.ROWBORDER_HORIZONTAL));
		properties.setBorderWidth(RtfRowProperties.ROWBORDER_VERTICAL,
		        getBorderWidth(RtfRowProperties.ROWBORDER_VERTICAL));

		properties.setRowPadding(RtfRowProperties.ROWBORDER_BOTTOM,
		        getRowPadding(RtfRowProperties.ROWBORDER_BOTTOM));
		properties.setRowPadding(RtfRowProperties.ROWBORDER_TOP,
		        getRowPadding(RtfRowProperties.ROWBORDER_TOP));
		properties.setRowPadding(RtfRowProperties.ROWBORDER_LEFT,
		        getRowPadding(RtfRowProperties.ROWBORDER_LEFT));
		properties.setRowPadding(RtfRowProperties.ROWBORDER_RIGHT,
		        getRowPadding(RtfRowProperties.ROWBORDER_RIGHT));
		
		return properties;
	}

	void setCellWidths(int widths[])
	{
		_cellWidths = widths;
	}

	void setCellWidths(Vector limits)
	{
		if (limits != null) {
			int length = limits.size();
			_cellWidths = new int[length];
			_cellLimits = new int[length];
			int current = 0;
			for (int ii = 0; ii < length; ii++) {
				int newcurrent = Integer.parseInt(limits.elementAt(ii).toString());
				// save the cellimit for processing of the colspanning
				_cellLimits[ii] = newcurrent;
				_cellWidths[ii] = newcurrent - current;
				current = newcurrent;
			}
		}
		else {
			_cellWidths = null;
		}
	}

	int getCellLimit(int pos) 
	{
		if (pos < _cellLimits.length) {
			return _cellLimits[pos];
		}
		else {
			return -1;
		} 
	}

	int[] getCellLimits() 
	{
		return _cellLimits;
	}

	int getCellWidth(int pos) 
	{
		if (pos < _cellWidths.length) {
			return _cellWidths[pos];
		}
		else {
			return -1;
		} 
	}

	void setCellProperties(RtfCellProperties props[])
	{
		_cellProps = props;
	}

	void setCellProperties(Vector props)
	{
		if (props != null) {
			int length = props.size();
			_cellProps = new RtfCellProperties[length];
			int current = 0;
			for (int ii = 0; ii < length; ii++) {
			    RtfCellProperties thiscell = (RtfCellProperties) props.elementAt(ii);
				_cellProps[ii] = thiscell;
			}
		}
		else {
		    _cellProps = null;
		}
	}

	public RtfCellProperties getCellProperties(int index)
	{
	    if (_cellProps == null) return null;
	    if (index > this._cellProps.length-1) return new RtfCellProperties();
	    return this._cellProps[index];
	}

	void setBorderWidth(int borderside, int width)
	{
	    switch (borderside) {
	    	case ROWBORDER_TOP:
	    	    this._borderWidthTop = width;
	    	    break;
	    	case ROWBORDER_BOTTOM:
	    	    this._borderWidthBottom = width;
	    	    break;
	    	case ROWBORDER_LEFT:
	    	    this._borderWidthLeft = width;
	    	    break;
	    	case ROWBORDER_RIGHT:
	    	    this._borderWidthRight = width;
	    	    break;
	    	case ROWBORDER_HORIZONTAL:
	    	    this._borderWidthHorizontal = width;
	    	    break;
	    	case ROWBORDER_VERTICAL:
	    	    this._borderWidthVertical = width;
	    	    break;
	    }
	}

	public int getBorderWidth(int borderside)
	{
	    switch (borderside) {
	    	case ROWBORDER_TOP:
	    	    return this._borderWidthTop;
	    	case ROWBORDER_BOTTOM:
	    	    return this._borderWidthBottom;
	    	case ROWBORDER_LEFT:
	    	    return this._borderWidthLeft;
	    	case ROWBORDER_RIGHT:
	    	    return this._borderWidthRight;
	    	case ROWBORDER_HORIZONTAL:
	    	    return this._borderWidthHorizontal;
	    	case ROWBORDER_VERTICAL:
	    	    return this._borderWidthVertical;
	    }
	    
	    return 0;
	}

	public boolean hasTopBorder() {
		return this._borderWidthTop > 0;
	}
	
	public boolean hasBottomBorder() {
		return this._borderWidthBottom > 0;
	}
	
	public boolean hasLeftBorder() {
		return this._borderWidthLeft > 0;
	}
	
	public boolean hasRightBorder() {
		return this._borderWidthRight > 0;
	}
	
	public boolean hasNoBorder() {
		return this._borderWidthRight == 0 &&
		       this._borderWidthLeft == 0 &&
		       this._borderWidthTop == 0 &&
		       this._borderWidthBottom == 0;
	}
	
	public boolean hasHorizontalBorder() {
		return this._borderWidthHorizontal > 0;
	}
	
	public boolean hasVerticalBorder() {
		return this._borderWidthVertical > 0;
	}
	
	void setRowPadding(int borderside, int margin)
	{
	    switch (borderside) {
	    	case ROWBORDER_TOP:
	    	    this._borderMarginTop = margin;
	    	    break;
	    	case ROWBORDER_BOTTOM:
	    	    this._borderMarginBottom = margin;
	    	    break;
	    	case ROWBORDER_LEFT:
	    	    this._borderMarginLeft = margin;
	    	    break;
	    	case ROWBORDER_RIGHT:
	    	    this._borderMarginRight = margin;
	    	    break;
	    }
	}

	public int getRowPadding(int borderside)
	{
	    switch (borderside) {
	    	case ROWBORDER_TOP:
	    	    return this._borderMarginTop;
	    	case ROWBORDER_BOTTOM:
	    	    return this._borderMarginBottom;
	    	case ROWBORDER_LEFT:
	    	    return this._borderMarginLeft;
	    	case ROWBORDER_RIGHT:
	    	    return this._borderMarginRight;
	    }
	    
	    return 0;
	}

	void Dump(PrintWriter out)
	{
	    // TODO check the output
	    if (hasBottomBorder()) {
	        out.print(" border-bottom=\"true\"");
			out.print(" borderwidth_bottom=\"" + _borderWidthBottom + "\"");
	    }
	    if (hasLeftBorder()) {
	        out.print(" border-left=\"true\"");
			out.print(" borderwidth_left=\"" + _borderWidthLeft + "\"");
	    }
	    if (hasRightBorder()) {
	        out.print(" border-right=\"true\"");
			out.print(" borderwidth_right=\"" + _borderWidthRight + "\"");
	    }
	    if (hasTopBorder()) {
	        out.print(" border-top=\"true\"");
			out.print(" borderwidth_top=\"" + _borderWidthTop + "\"");
	    }
	    if (this._borderMarginBottom > 0) {
			out.print(" bordermargin_bottom=\"" + _borderMarginBottom + "\"");
	    }
	    if (this._borderMarginLeft > 0) {
			out.print(" bordermargin_lef=\"" + _borderMarginLeft + "\"");
	    }
	    if (this._borderMarginRight > 0) {
			out.print(" bordermargin_right=\"" + _borderMarginRight + "\"");
	    }
	    if (this._borderMarginTop > 0) {
			out.print(" bordermargin_top=\"" + _borderMarginTop + "\"");
	    }

		if (_cellWidths != null) {
			out.print(" cellwidths=\"");
			for (int ii = 0; ii < _cellWidths.length; ii++) {
				if (ii > 0) {
					out.print(" ");
				}
				out.print(_cellWidths[ii]);
			}
			out.print("\"");
		}

	    if (_cellProps != null) {
			for (int ii = 0; ii < _cellProps.length; ii++) {
				_cellProps[ii].Dump(out);
			}
		}

	}
}

