//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfStyleSheet
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.*;

public class RtfStyleSheet {

	private StyleDefinition[] _theStyles;
	static RtfStyleSheet _currentStyleSheet = null;

	public RtfStyleSheet()
	{
		_theStyles = new StyleDefinition[256];
		_currentStyleSheet = this;
	}

	public void defineParagraphStyle(int code, String name, RtfTextProperties textProperties)
	{
		if ((code >= 0) && (code <= 255)) {
			_theStyles[code] = new ParagraphStyleDefinition(code, name, textProperties);
		}
		else {
			System.out.println("illegal paragraph style code : " + code + " : " + name);
		}
	}

	public void defineCharacterStyle(int code, String name, RtfTextProperties textProperties)
	{
		if ((code >= 0) && (code <= 255)) {
			_theStyles[code] = new CharacterStyleDefinition(code, name, textProperties);
		}
		else {
			System.out.println("illegal character style code : " + code);
		}
	}

	public String getStyleName(int code)
	{
		if (code >= 0) {
			StyleDefinition style = _theStyles[code];
			if (style != null) {
				return _theStyles[code].getName();
			}
			else {
				return null;
			}
		}
		else {
			return null;
		}
	}

	public boolean isParagraphStyle(int code)
	{
		if (code >= 0) {
			StyleDefinition style = _theStyles[code];
			if (style != null) {
				return style instanceof ParagraphStyleDefinition;
			}
		}

		return false;
	}

	public boolean isCharacterStyle(int code)
	{
		if (code >= 0) {
			StyleDefinition style = _theStyles[code];
			if (style != null) {
				return style instanceof CharacterStyleDefinition;
			}
		}

		return false;
	}

	public RtfTextProperties getTextProperties(int code)
	{
		if (code >= 0) {
			StyleDefinition style = _theStyles[code];
			if (style != null) {
				return style.getTextProperties();
			}
			else {
				return new RtfTextProperties();
			}
		}
		else {
			return new RtfTextProperties();
		}
	}

	public void Dump(PrintWriter out)
	{
		out.println("<stylesheet>");
		for (int ii = 0; ii < 256; ii++) {
			if (_theStyles[ii] != null) {
				_theStyles[ii].Dump(out);
			}
		}
		out.println("</stylesheet>");
	}

	public static RtfStyleSheet getCurrentStyleSheet()
	{
		return _currentStyleSheet;
	}

	abstract class StyleDefinition {
		String _styleName; 
		RtfTextProperties _textProperties;
		int _code;

		StyleDefinition(int code, String name, RtfTextProperties textProperties)
		{
			_code           = code;
			_styleName      = name;
			_textProperties = textProperties;
		}

		String getName()
		{
			return _styleName;
		}

		RtfTextProperties getTextProperties()
		{
			return _textProperties;
		}

		abstract void Dump(PrintWriter out);
	}

	class ParagraphStyleDefinition extends StyleDefinition {

		ParagraphStyleDefinition(int code, String name, RtfTextProperties textProperties)
		{
			super(code, name, textProperties);
		}

		void Dump(PrintWriter out)
		{
			out.println("<style code=\"" + _code + "\""
				+ ((_textProperties.changedFontSize() == true) ? " fontsize=\""+_textProperties.getFontSize()+"\"" : "")
				+ ((_textProperties.isBold() == true) ? " bold=\"1\"" : "")
				+ ((_textProperties.isItalic() == true) ? " italic=\"1\"" : "")
				+ ((_textProperties.isHidden() == true) ? " hidden=\"1\"" : "")
				+ ((_textProperties.isUnderlined() == true) ? " underlined=\"1\"" : "")
				+ ((_textProperties.isSuper() == true) ? " super=\"1\"" : "")
				+ ((_textProperties.isSub() == true) ? " sub=\"1\"" : "")
				+ ((_textProperties.isDeleted() == true) ? " deleted=\"1\"" : "")
				+ ((_textProperties.getExpanded() != 0) ? " expand=\""+_textProperties.getExpanded()+"\"" : "")
				+ ((_textProperties.getColor() == -1) ? " color=\"" + _textProperties.getColorName() + "\"" : "")
				+ ">" + _styleName + "</style>");
		}
	}

	class CharacterStyleDefinition extends StyleDefinition {

		CharacterStyleDefinition(int code, String name, RtfTextProperties textProperties)
		{
			super(code, name, textProperties);
		}

		void Dump(PrintWriter out)
		{
			out.println("<cstyle code=\"" + _code + "\""
				+ ((_textProperties.changedFontSize() == true) ? " fontsize=\""+_textProperties.getFontSize()+"\"" : "")
				+ ((_textProperties.isBold() == true) ? " bold=\"1\"" : "")
				+ ((_textProperties.isItalic() == true) ? " italic=\"1\"" : "")
				+ ((_textProperties.isHidden() == true) ? " hidden=\"1\"" : "")
				+ ((_textProperties.isUnderlined() == true) ? " underlined=\"1\"" : "")
				+ ((_textProperties.isSuper() == true) ? " super=\"1\"" : "")
				+ ((_textProperties.isSub() == true) ? " sub=\"1\"" : "")
				+ ((_textProperties.isDeleted() == true) ? " deleted=\"1\"" : "")
				+ ((_textProperties.getExpanded() != 0) ? " expand=\""+_textProperties.getExpanded()+"\"" : "")
				+ ((_textProperties.getColor() != -1) ? " color=\"" + _textProperties.getColorName() + "\"" : "")
				+ ">" + _styleName + "</style>");
		}
	}
}
