//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfText
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.*;
import com.tetrasix.majix.xml.*;

public class RtfTab extends RtfObject {

	private RtfTextProperties _properties;

	RtfTab(RtfTextProperties props)
	{
	    this._properties = props;
	}

	public RtfTextProperties getTextProperties()
	{
		return _properties;
	}

	void Dump(PrintWriter out)
	{
	    StringBuffer attributes = new StringBuffer();
	    
		if (_properties.isHidden()) {
		    attributes.append(" hidden=\"true\"");
		}
		if (_properties.isUnderlined()) {
		    attributes.append(" underlined=\"true\"");
		}
		if (_properties.isDeleted()) {
		    attributes.append(" deleted=\"true\"");
		}

		out.print("<tab"+attributes.toString()+"/>");
	}

	public void generate(XmlGenerator gen, XmlWriter out, XmlGeneratorContext context)
	{
		gen.rtfgenerate(this, out, context);
	}
}

