//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfText
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.*;

import com.tetrasix.util.Configuration;

public class RtfTabDef extends RtfObject implements Cloneable {

	public static final int TABALIGN_LEFT = 0;
	public static final int TABALIGN_RIGHT = 1;
	public static final int TABALIGN_CENTER = 2;
	public static final int TABALIGN_DECIMAL = 3;
	
	public static final int TAB_DEFAULT_WIDTH = Integer.parseInt(Configuration.getProperty("majix.generate.defaulttabsize","720"));
	
	public static final String TAB_TYPE_DEFAULT = "default";
	public static final String TAB_TYPE_NORMAL = "normal";

	private int _align = 0;
	private int _position = -1;
	private String _type = "default";
	
	RtfTabDef(int align, int position, String type)
	{
		this._align = align;
		this._position = position;
		this._type = type;
	}

	public String getTabAlign() {
	    String align = null;
	    switch (_align) {
			case (TABALIGN_LEFT):
			    align = "left";
				break;
	    	case (TABALIGN_RIGHT):
	    	    align = "right";
				break;
	    	case (TABALIGN_CENTER):
	    	    align = "center";
				break;
	    	case (TABALIGN_DECIMAL):
	    	    align = "decimal";
	    		break;
	    }
	    
	    return align;
	}
	
	public int getTabPosition() {
		return _position;
	}
	
	public Object clone() {
		return new RtfTabDef(_align, _position, _type);
	}

	void Dump(PrintWriter out)
	{
		out.println("<tabdef "+"align=\""+_align+"\" position=\""+_position+"\"/>");
	}
}

