//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfTabProperties
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.PrintWriter;
import java.util.Vector;

/**
 * <code>RtfTabProperties</code>
 */
public class RtfTabProperties implements Cloneable {

	private int _tabPositions[];

	RtfTabProperties()
	{
		_tabPositions = null;
	}

	void setTabPositions(int positions[])
	{
		_tabPositions = positions;
	}

	void setTabPositions(Vector positions)
	{
		if (positions != null) {
			int length = positions.size();
			_tabPositions = new int[length];
			int current = 0;
			for (int ii = 0; ii < length; ii++) {
				int newcurrent = Integer.parseInt(positions.elementAt(ii).toString());
				_tabPositions[ii] = newcurrent - current;
				current = newcurrent;
			}
		}
		else {
			_tabPositions = null;
		}
	}

	int getTabPosition(int pos) 
	{
		if (pos < _tabPositions.length) {
			return _tabPositions[pos];
		}
		else {
			return -1;
		} 
	}


	protected Object clone()
	{
		RtfTabProperties properties = new RtfTabProperties();
		
		if (_tabPositions != null) {
			properties._tabPositions = new int[_tabPositions.length];
			for (int ii = 0; ii < _tabPositions.length; ii++) {
				properties._tabPositions[ii] = _tabPositions[ii];
			}
		}

		return properties;
	}
	
	void Dump(PrintWriter out)
	{
		if (_tabPositions != null) {
			out.print(" tabpositions=\"");
			for (int ii = 0; ii < _tabPositions.length; ii++) {
				if (ii > 0) {
					out.print(" ");
				}
				out.print(_tabPositions[ii]);
			}
			out.print("\"");
		}
	}
}
