//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfTextProperties
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import com.tetrasix.util.Configuration;

public class RtfTextProperties implements Cloneable {

	/** the default fontsize is 24 half-points in Word */
	public static final int DEFAULT_FONTSIZE = Integer.parseInt(Configuration.getProperty("majix.generate.defaultfontsize","24"));
	
	boolean _bold = false;
	boolean _italic = false;
	boolean _underlined = false;
	boolean _doubleUnderlined = false;
	boolean _hidden = false;
	boolean _super = false;
	boolean _sub = false;
	boolean _del = false;
	boolean _caps = false;
	
	int _color = -1;
	// expanded/condensed characters. condensed values are negative
	int _expanded = 0;
	int _charStyle = -1;

	int _fontSize = DEFAULT_FONTSIZE;

	protected Object clone()
	{
		RtfTextProperties properties = new RtfTextProperties();

		properties.setSuper(isSuper());
		properties.setSub(isSub());
		properties.setDeleted(isDeleted());
		properties.setBold(isBold());
		properties.setItalic(isItalic());
		properties.setHidden(isHidden());
		properties.setUnderlined(isUnderlined());
		properties.setDoubleUnderlined(isDoubleUnderlined());
		properties.setCapitalLetters(isCapitalLetters());
		properties.setColor(getColor());
		properties.setStyle(getStyle());
		properties.setFontSize(getFontSize());
		properties.setExpanded(getExpanded());

		return properties;
	}

	/**
	 * Resets the textproperties to "plain".
	 * See also the control word \plain in RTF-Spec 1.7.
	 *
	 */
	void reset()
	{
		setBold(false);
		setItalic(false);
		setUnderlined(false);
		this.setDoubleUnderlined(false);
		setHidden(false);
		setDeleted(false);
		setSuper(false);
		setSub(false);
		setColor(-1);
		setStyle(-1);
		setFontSize(24);
		setExpanded(0);
		setCapitalLetters(false);
	}
	
	public boolean equals(Object o) {
	    if (o == null) return false;
	    if (!(o instanceof RtfTextProperties)) return false;
	    RtfTextProperties props = (RtfTextProperties) o; 
	    boolean equal = true;

	    // compare
		equal &= (_bold == props._bold);
		equal &= (_italic == props._italic);
		equal &= (_underlined == props._underlined);
		equal &= (_doubleUnderlined == props._doubleUnderlined);
		equal &= (_hidden == props._hidden);
		equal &= (_super == props._super);
		equal &= (_sub == props._sub);
		equal &= (_del == props._del);
		// doesnt generate tags, so is irrelevant
//		equal &= (_caps == props._caps);
		
		equal &= (_color == props._color);
		equal &= (_charStyle == props._charStyle);
		equal &= (_fontSize == props._fontSize);
		equal &= (_expanded == props._expanded);
	    
	    return equal;
	}
	
	void setSuper(boolean supervalue)
	{
		_super = supervalue;
	}

	void setSub(boolean sub)
	{
		_sub = sub;
	}
	
	void setDeleted(boolean del)
	{
		_del = del;
	}
	
	void setBold(boolean bold)
	{
		_bold = bold;
	}

	void setItalic(boolean italic)
	{
		_italic = italic;
	}

	void setHidden(boolean hidden)
	{
		_hidden = hidden;
	}

	void setUnderlined(boolean underlined)
	{
		_underlined = underlined;
	}

	void setDoubleUnderlined(boolean dunderlined)
	{
		_doubleUnderlined = dunderlined;
	}

	void setCapitalLetters(boolean capital)
	{
		_caps = capital;
	}

	public boolean isSuper()
	{
		return _super;
	}

	public boolean isSub()
	{
		return _sub;
	}

	public boolean isDeleted()
	{
		return _del;
	}

	public boolean isBold()
	{
		return _bold;
	}

	public boolean isItalic()
	{
		return _italic;
	}

	public boolean isHidden()
	{
		return _hidden;
	}

	public boolean isUnderlined()
	{
		return _underlined;
	}

	public boolean isDoubleUnderlined()
	{
		return _doubleUnderlined;
	}

	public boolean isCapitalLetters()
	{
		return this._caps;
	}

	void setStyle(int style)
	{
		_charStyle = style;
	}

	public int getStyle()
	{
		return _charStyle;
	}

	void setColor(int color)
	{
		_color = color;
	}

	public int getColor()
	{
		return _color;
	}

	void setExpanded(int expand)
	{
		_expanded = expand;
	}

	public int getExpanded()
	{
		return _expanded;
	}

	void setFontSize(int size)
	{
		_fontSize = size;
	}

	public int getFontSize()
	{
		return _fontSize;
	}

	public boolean changedFontSize()
	{
		return _fontSize != DEFAULT_FONTSIZE;
	}

	String getColorName()
	{
		return getColorNamefromCode(_color);
	}

	static String getColorNamefromCode(int color)
	{
		if (color == 1) {
			return "Black";
		}
		else if (color == 2) {
			return "Blue";
		}
		else if (color == 3) {
			return "Aqua";
		}
		else if (color == 4) {
			return "Lime";
		}
		else if (color == 5) {
			return "Fuchsia";
		}
		else if (color == 6) {
			return "Red";
		}
		else if (color == 7) {
			return "Yellow";
		}
		else if (color == 8) {
			return "White";
		}
		else if (color == 9) {
			return "Navy";
		}
		else if (color == 10) {
			return "Teal";
		}
		else if (color == 11) {
			return "Green";
		}
		else if (color == 12) {
			return "Purple";
		}
		else if (color == 13) {
			return "Maroon";
		}
		else if (color == 14) {
			return "Olive";
		}
		else if (color == 15) {
			return "Gray";
		}
		else if (color == 16) {
			return "Silver";
		}
		else {
			return "";
		}
	}

	public String getColorCode()
	{
		if (_color == 1) {
			return "cA";
		}
		else if (_color == 2) {
			return "cB";
		}
		else if (_color == 3) {
			return "cC";
		}
		else if (_color == 4) {
			return "cD";
		}
		else if (_color == 5) {
			return "cE";
		}
		else if (_color == 6) {
			return "cF";
		}
		else if (_color == 7) {
			return "cG";
		}
		else if (_color == 8) {
			return "cH";
		}
		else if (_color == 9) {
			return "cI";
		}
		else if (_color == 10) {
			return "cJ";
		}
		else if (_color == 11) {
			return "cK";
		}
		else if (_color == 12) {
			return "cL";
		}
		else if (_color == 13) {
			return "cM";
		}
		else if (_color == 14) {
			return "cN";
		}
		else if (_color == 15) {
			return "cO";
		}
		else if (_color == 16) {
			return "cP";
		}
		else {
			return "";
		}
	}

	public String toString()
	{
		StringBuffer buf = new StringBuffer();
		boolean empty = true;

		if (_fontSize != DEFAULT_FONTSIZE) {
			buf.append("size=\""+_fontSize+"\" ");
			empty = false;
		}
		if (_bold) {
			buf.append("bold ");
			empty = false;
		}
		if (_italic) {
			buf.append("italic ");
			empty = false;
		}
		if (_underlined) {
			buf.append("underlined ");
			empty = false;
		}
		if (_doubleUnderlined) {
			buf.append("doubleunderlined ");
			empty = false;
		}
		if (_caps) {
			buf.append("capital ");
			empty = false;
		}
		if (_color != -1) {
			buf.append(getColorName());
			empty = false;
		}
		if (_expanded != 0) {
			buf.append("expanded=\""+_expanded+"\"");
			empty = false;
		}

		if (empty) {
			return "plain";
		}
		else {
			return buf.toString();
		}
	}
}


