//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfTextPropertiesStack
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

class RtfTextPropertiesStackCell {

	private RtfTextProperties _properties;
	private RtfTextPropertiesStackCell _nextcell;

	RtfTextPropertiesStackCell(RtfTextPropertiesStackCell cell, RtfTextProperties properties)
	{
		_properties = properties;
		_nextcell = cell;
	}

	RtfTextPropertiesStackCell getNextCell()
	{
		return _nextcell;
	}

	public RtfTextProperties getProperties()
	{
		return _properties;
	}

	public String toString()
	{
		return _properties.toString();
	}
}

class RtfTextPropertiesStack {

	RtfTextPropertiesStackCell _top;

	RtfTextPropertiesStack()
	{
		_top = null;
	}

	void push(RtfTextProperties properties)
	{
		_top = new RtfTextPropertiesStackCell(_top, properties);
	}

	RtfTextProperties pop()
	{
		RtfTextPropertiesStackCell save = _top;

		if (_top != null) {
			_top = _top.getNextCell();
		}

		return (save != null) ? save.getProperties() : new RtfTextProperties();
	}

	boolean empty()
	{
		return _top == null;
	}

	RtfTextProperties top()
	{
		if (_top != null) {
			return _top.getProperties();
		}
		else {
			return null;
		}
	}

	public String toString()
	{
		StringBuffer buf = new StringBuffer();
		RtfTextPropertiesStackCell cell = _top;

		while (cell != null) {
			buf.append(cell.toString());
			cell = cell.getNextCell();
			if (cell != null) {
				buf.append(" : ");
			}
		}

		return buf.toString();
	}
}
