//===============================================================
// package : com.tetrasix.majix
// class : com.tetrasix.majix.templates.ConversionTemplateFactory
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.templates;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

import com.jclark.xml.parse.EntityManagerImpl;
import com.jclark.xml.parse.OpenEntity;
import com.jclark.xml.parse.StartElementEvent;
import com.jclark.xml.parse.io.Application;
import com.jclark.xml.parse.io.ApplicationImpl;
import com.jclark.xml.parse.io.Parser;
import com.jclark.xml.parse.io.ParserImpl;
import com.tetrasix.majix.rtf.RtfAbstractStylesheet;
import com.tetrasix.majix.rtf.RtfStyleMap;
import com.tetrasix.majix.xml.ConversionTemplate;
import com.tetrasix.majix.xml.XmlGeneratorAutomaton;
import com.tetrasix.majix.xml.XmlGeneratorParam;
import com.tetrasix.majix.xml.XmlGeneratorState;
import com.tetrasix.majix.xml.XmlGeneratorTransition;
import com.tetrasix.majix.xml.XmlTagMap;
import com.tetrasix.majix.xml.XmlTagTemplate;
import com.tetrasix.majix.xml.XmlTagTemplateElement;
import com.tetrasix.majix.xml.XmlTagTemplateList;
import com.tetrasix.majix.xml.XmlTagTemplateNull;
import com.tetrasix.majix.xml.XmlTagTemplateString;
import com.tetrasix.majix.xml.XmlTagTemplateVariable;

public class ConversionTemplateFactory {

	private GenericConversionTemplate _loading_template = null;

	public ConversionTemplate getConversionTemplate(String name)
	{
		if (name.equals("mydoc")) {
			return new MyDocTemplate();
		}
		else {
			String filename = name + ".majixt";
			File file = new File(filename);
			if (file.exists()) {
				
				System.out.println("Loading template from file " + file.getAbsolutePath());
				ConversionTemplate template = load(file.getAbsolutePath());

				filename = name + ".sty";
				file = new File(filename);
				if (file.exists()) {
					System.out.println("Loading style map from file " + file.getAbsolutePath());
					RtfStyleMap stylemap = new RtfStyleMap(file.getAbsolutePath(), template.getStyleMap().getAbstractStyleSheet());
		 			template.setStyleMap(stylemap);
				}
				else {
					System.err.println("The style map does not exists : " + name);
				}
							
				filename = name + ".tdef";
				file = new File(filename);
				if (file.exists()) {
					System.out.println("Loading tag map from file " + file.getAbsolutePath());
					template.setGeneratorParam(new XmlGeneratorParam(template, file.getAbsolutePath()));
				}
				else {
					System.err.println("The tag map does not exists : " + name);
				}
				
//				_loading_template.save("zzz.majixt");

				System.out.println("Loading done");
				return template;
			}
			else {
				System.err.println("Template does not exists : " + name);
				return null;
			}
		}
	}

	public ConversionTemplate load(String filename)
	{
		try {
			_loading_template = new GenericConversionTemplate();

			Parser parser = new ParserImpl();
			OpenEntity entity = EntityManagerImpl.openFile(filename);

			parser.setApplication(new ConversionTemplateLoaderApplication());
			parser.parseDocument(entity);

			return _loading_template;
		}
		catch (IOException e) {
			System.err.println("Unable to load : " + filename);
			System.err.println("reason : " + e.getMessage());
			e.printStackTrace();
			return null;
		}
	}

	private class ConversionTemplateLoaderApplication extends ApplicationImpl {
		
		Application _application = null;

		RtfAbstractStylesheet _abstract_style_sheet = null;
		boolean _in_paragraph_styles;
		boolean _in_character_styles;

		XmlGeneratorState startState;
		XmlGeneratorState endState;
		String key;
		boolean generate_paragraph;
		boolean again;
		boolean push;
		boolean _default_transition = false;

		boolean before = true;
		boolean after = false;

		XmlTagTemplateList ttlist = null;
		XmlTagTemplate tt = null;

		Hashtable _states = new Hashtable(100);
		XmlGeneratorTransition transition;

		public void startElement(StartElementEvent event)
		{
			String tag = event.getName();

			XmlGeneratorAutomaton automaton = _loading_template.getGeneratorAutomaton();

			if (tag.equals("majixt")) {
				_loading_template.setName(event.getAttributeValue("name"));
			}
			else if (tag.equals("abstractstylesheet")) {
				_abstract_style_sheet = _loading_template.getStyleMap().getAbstractStyleSheet();
				_in_paragraph_styles = false;
				_in_character_styles = false;
			}
			else if (tag.equals("pstyles")) {
				_in_paragraph_styles = true;
				_in_character_styles = false;
			}
			else if (tag.equals("cstyles")) {
				_in_paragraph_styles = false;
				_in_character_styles = true;
			}
			else if (tag.equals("astyle")) {
				if (_in_paragraph_styles) {
					_abstract_style_sheet.defineParagraphStyle(
						event.getAttributeValue("name"),
						event.getAttributeValue("description"));
				}
				else {
					_abstract_style_sheet.defineCharacterStyle(
						event.getAttributeValue("name"),
						event.getAttributeValue("description"));
				}
			}
			else if (tag.equals("automaton")) {
				automaton.setStartState(getState(event.getAttributeValue("start")));
				automaton.setStartCellState(getState(event.getAttributeValue("startcell")));
			}
			else if (tag.equals("transition")) {
				startState = getState(event.getAttributeValue("start"));
				endState = getState(event.getAttributeValue("end"));
				key = event.getAttributeValue("key");
				generate_paragraph = parseBool(event.getAttributeValue("generate_paragraph"));
				again = parseBool(event.getAttributeValue("again"));
				push = parseBool(event.getAttributeValue("push"));

				if (_default_transition) {
					transition = automaton.defineDefaultTransition(
								endState,
								(XmlTagTemplate)null,
								generate_paragraph,
								(XmlTagTemplate)null);
				}
				else {
					transition = automaton.defineTransition(
								startState,
								endState,
								key,
								(XmlTagTemplate)null,
								generate_paragraph,
								(XmlTagTemplate)null,
								again,
								push);
				}
			}
			else if (tag.equals("before")) {
				ttlist = null;
				before = true;
				after = false;
			}
			else if (tag.equals("after")) {
				ttlist = null;
				before = false;
				after = true;
			}
			else if (tag.equals("tt_list")) {
				if (ttlist == null) {
					ttlist = new XmlTagTemplateList();
					if (before) {
						transition.setGenerateBefore(ttlist);
					}
					else if (after) {
						transition.setGenerateAfter(ttlist);
					}
					else {
						System.err.println("Error when loading template : 001");
					}
				}
			}
			else if (tag.equals("tt_string")) {
				tt = new XmlTagTemplateString(event.getAttributeValue("text"));
				if (ttlist != null) {
					ttlist.add(tt);
				}
				else if (before) {
					transition.setGenerateBefore(tt);
				}
				else if (after) {
					transition.setGenerateAfter(tt);
				}
				else {
					System.err.println("Error when loading template : 002");
				}
			}
			else if (tag.equals("tt_element")) {
				tt = new XmlTagTemplateElement(_loading_template, event.getAttributeValue("tag"), parseBool(event.getAttributeValue("endtag")));
				if (ttlist != null) {
					ttlist.add(tt);
				}
				else if (before) {
					transition.setGenerateBefore(tt);
				}
				else if (after) {
					transition.setGenerateAfter(tt);
				}
				else {
					System.err.println("Error when loading template : 002");
				}
			}
			else if (tag.equals("tt_null")) {
				tt = new XmlTagTemplateNull();
				if (ttlist != null) {
					ttlist.add(tt);
				}
				else if (before) {
					transition.setGenerateBefore(tt);
				}
				else if (after) {
					transition.setGenerateAfter(tt);
				}
				else {
					System.err.println("Error when loading template : 002");
				}
			}
			else if (tag.equals("tt_variable")) {
				tt = new XmlTagTemplateVariable(event.getAttributeValue("key"), _loading_template);
				if (ttlist != null) {
					ttlist.add(tt);
				}
				else if (before) {
					transition.setGenerateBefore(tt);
				}
				else if (after) {
					transition.setGenerateAfter(tt);
				}
				else {
					System.err.println("Error when loading template : 002");
				}
			}
			else if (tag.equals("default")) {
				_default_transition = true;
			}
			else if (tag.equals("tagmap")) {
			}
			else if (tag.equals("tag")) {
				XmlGeneratorParam param = _loading_template.getGeneratorParam();
				XmlTagMap tagMap = param.getTags();
				tagMap.load(event, true);
			}
			else {
				System.err.println("Unknown tag : <" + tag + ">");
			}
		}

		private XmlGeneratorState getState(String name)
		{
			if (name != null) {
				XmlGeneratorState state = (XmlGeneratorState)_states.get(name);
				if (state == null) {
					state = new XmlGeneratorState(name);
					_states.put(name, state);
				}

				return state;
			}
			else {
				return null;
			}
		}

		private boolean parseBool(String s)
		{
			if (s == null) {
				return false;
			}
			else if (s.equals("1")) {
				return true;
			}
			else {
				return false;
			}
		}
	}
}
