//===============================================================
// package : com.tetrasix.majix
// class : com.tetrasix.majix.templates.ConversionTemplateFactory
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.templates;


import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import com.tetrasix.majix.rtf.AbstractStyleProvider;
import com.tetrasix.majix.rtf.RtfAbstractStylesheet;
import com.tetrasix.majix.rtf.RtfStyleMap;
import com.tetrasix.majix.xml.ConversionTemplate;
import com.tetrasix.majix.xml.XmlGeneratorAutomaton;
import com.tetrasix.majix.xml.XmlGeneratorParam;
import com.tetrasix.util.ISO8859XMLWriter;

public class GenericConversionTemplate implements ConversionTemplate {

	protected String                 _templateName;
	protected RtfAbstractStylesheet  _abstractStyleSheet;
	protected RtfStyleMap            _styleMap;
	protected XmlGeneratorAutomaton  _automaton;
	protected XmlGeneratorParam	     _genParam;

	public GenericConversionTemplate()
	{
		_styleMap = new RtfStyleMap();
		initRtfAbstractStyleSheet(_styleMap.getRtfAbstractStylesheet());
		_abstractStyleSheet = _styleMap.getAbstractStyleSheet();
		_automaton = new XmlGeneratorAutomaton(this);
		_genParam = new XmlGeneratorParam();
	}
	
	public void save(String filename)
	{
		try {
			OutputStream ostream = new FileOutputStream(filename);
			ISO8859XMLWriter writer = new ISO8859XMLWriter(ostream, ISO8859XMLWriter.MINIMIZE_EMPTY_ELEMENTS);

			writer.markup("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>");writer.write("\n");
			writer.markup("<!DOCTYPE majixt SYSTEM \"majixt.dtd\" [");writer.write("\n");
			writer.markup("]>");writer.write("\n");

			writer.startElement("majixt");
			writer.attribute("name", _templateName);
	
			if (_abstractStyleSheet == null) {
				writer.comment("*** Abstract Style Sheet missing ***");
			}
			else {
				_abstractStyleSheet.save(writer);
			}
			if (_automaton == null) {
				writer.comment("*** Automaton missing ***");
			}
			else {
				_automaton.save(writer);
			}

			_genParam.getTags().Save(writer, true);

			writer.endElement("majixt");


			writer.flush();
			ostream.close();
		}
		catch(IOException e) {
			System.out.println("IO error : " + e.getMessage());
		}
	}

	public XmlGeneratorParam getGeneratorParam()
	{
		return _genParam;
	}

	public XmlGeneratorAutomaton getGeneratorAutomaton()
	{
		return _automaton;
	}

	public void setGeneratorParam(XmlGeneratorParam param)
	{
		_genParam = param;
	}

	public void initGenParam(XmlGeneratorParam genParams)
	{
	}

	public void setName(String name)
	{
		_templateName = name;
	}

	public String getName()
	{
		return _templateName;
	}

	public RtfStyleMap getStyleMap()
	{
		return _styleMap;
	}
	
	public void setStyleMap(RtfStyleMap map)
	{
		_styleMap = map;
  	initRtfAbstractStyleSheet(_styleMap.getRtfAbstractStylesheet());
	}
	
	public void setAbstractStyleProvider(AbstractStyleProvider provider)
	{
		_styleMap.setAbstractStyleProvider(provider);
	}


	public void initRtfAbstractStyleSheet(RtfAbstractStylesheet assh)
	{
  	assh.setDefaultStyle("p");
	}
}
