//===============================================================
// package : com.tetrasix.majix
// class : com.tetrasix.majix.templates.MyDoc.java
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.templates;

import com.tetrasix.majix.rtf.RtfAbstractStylesheet;
import com.tetrasix.majix.rtf.RtfStyleMap;
import com.tetrasix.majix.xml.XmlGeneratorAutomaton;
import com.tetrasix.majix.xml.XmlGeneratorParam;
import com.tetrasix.majix.xml.XmlGeneratorState;
import com.tetrasix.majix.xml.XmlTagMap;
import com.tetrasix.util.Configuration;

public class MyDocTemplate extends GenericConversionTemplate {

	private String                 RE;

	public MyDocTemplate()
	{
		RE = System.getProperty("line.separator");

		_templateName = "MyDoc";

		_styleMap = new RtfStyleMap();
		initRtfAbstractStyleSheet(_styleMap.getRtfAbstractStylesheet());
		_abstractStyleSheet = _styleMap.getRtfAbstractStylesheet();
		initTagMap();

		_genParam = new XmlGeneratorParam();
		initGenParam(_genParam);

		_automaton = new XmlGeneratorAutomaton(this);
		initGeneratorAutomaton();

		save("mydoc.majixt");
	}

	void initTagMap()
	{
		_styleMap.clear();

		// Microsoft standard styles

		//defineParagraph("Normal",          "pa",      "pa");
		_styleMap.defineParagraph("heading 1",       "h1",	true);
		_styleMap.defineParagraph("heading 2",       "h2",	true);
		_styleMap.defineParagraph("heading 3",       "h3",	true);
		_styleMap.defineParagraph("heading 4",       "h4",	true);
		_styleMap.defineParagraph("heading 5",       "h5",	true);
		_styleMap.defineParagraph("heading 6",       "h6",	true);
		_styleMap.defineParagraph("heading 7",       "p",	true);
		_styleMap.defineParagraph("heading 8",       "p",	true);
		_styleMap.defineParagraph("heading 9",       "p",	true);
		_styleMap.defineParagraph("List Bullet",     "lb1",	true);
		_styleMap.defineParagraph("List Bullet 2",   "lb2",	true);
		_styleMap.defineParagraph("List Bullet 3",   "lb3",	true);
		_styleMap.defineParagraph("List Bullet 4",   "lb3",	true);
		_styleMap.defineParagraph("List Bullet 5",   "lb3",	true);
		_styleMap.defineParagraph("List Number",     "ln1",	true);
		_styleMap.defineParagraph("List Number 2",   "ln2",	true);
		_styleMap.defineParagraph("List Number 3",   "ln3",	true);
		_styleMap.defineParagraph("List Number 4",   "ln3",	true);
		_styleMap.defineParagraph("List Number 5",   "ln3",	true);
		_styleMap.defineParagraph("List Continue",   "lc1",	true);
		_styleMap.defineParagraph("List Continue 2", "lc2",	true);
		_styleMap.defineParagraph("List Continue 3", "lc3",	true);
		_styleMap.defineParagraph("List",            "p",	true);
		_styleMap.defineParagraph("List 2",          "p",	true);
		_styleMap.defineParagraph("List 3",          "p",	true);
		_styleMap.defineParagraph("List 4",          "p",	true);
		_styleMap.defineParagraph("List 5",          "p",	true);
		_styleMap.defineParagraph("Note Heading",    "not",	true);

		_styleMap.defineParagraph("Block Text",      "p",	true);
		_styleMap.defineParagraph("Block Text",      "p",	true);
		_styleMap.defineParagraph("Body Text",       "p",	true);
		_styleMap.defineParagraph("Body Text 2",     "p",	true);
		_styleMap.defineParagraph("Body Text 3",     "p",	true);
		_styleMap.defineParagraph("Body First Indent",     "p",	true);
		_styleMap.defineParagraph("Body First Indent 2",     "p",	true);
		_styleMap.defineParagraph("Body Text Indent",     "p",	true);
		_styleMap.defineParagraph("Body Text Indent 2",     "p",	true);
		_styleMap.defineParagraph("Body Text Indent 3",     "p",	true);
		_styleMap.defineParagraph("Caption",     "p",	true);
		_styleMap.defineParagraph("Closing",     "p",	true);
		_styleMap.defineParagraph("Comment Text",     "p",	true);
		_styleMap.defineParagraph("Date",     "p",	true);
		_styleMap.defineParagraph("Document Map",     "p",	true);
		_styleMap.defineParagraph("Endnote Text",     "p",	true);
		_styleMap.defineParagraph("Envelope Address",     "p",	true);
		_styleMap.defineParagraph("Envelope Return",     "p",	true);
		_styleMap.defineParagraph("Exemple",     "p",	true);
		_styleMap.defineParagraph("Footer",     "p",	true);
		_styleMap.defineParagraph("Footnote Text",     "p",	true);
		_styleMap.defineParagraph("Header",     "p",	true);
		_styleMap.defineParagraph("Message Header",     "p",	true);
		_styleMap.defineParagraph("Normal Indent",     "p",	true);
		_styleMap.defineParagraph("Plain Text",     "p",	true);
		_styleMap.defineParagraph("Preformatted",     "p",	true);
		_styleMap.defineParagraph("Salutation",     "p",	true);
		_styleMap.defineParagraph("Signature",     "p",	true);
		_styleMap.defineParagraph("Table of Authorities",     "p",	true);
		_styleMap.defineParagraph("Table of Figures",     "p",	true);
		_styleMap.defineParagraph("TOA Heading",     "p",	true);


		// TetraSix standard styles 

		_styleMap.defineParagraph("Title",           "ti",	false);
		_styleMap.defineParagraph("Definition List", "dl1",	false);
		_styleMap.defineParagraph("Attention",       "att",	false);
		_styleMap.defineParagraph("Note",            "not",	false);

		if (! Configuration.getProperty("enable.meta").equals("")) {
			_styleMap.defineParagraph("Meta", "meta",	false);
		}

		// Standard character styles 
 
 		_styleMap.defineCharacter("Emphasis",				"em",	true);
		_styleMap.defineCharacter("Strong",					"sg",	true);

		_styleMap.defineCharacter("Comment Reference",      "cs",	true);
		_styleMap.defineCharacter("Endnote Reference",      "cs",	true);
		_styleMap.defineCharacter("FollowedHyperlink",      "cs",	true);
		_styleMap.defineCharacter("Footnote Reference",      "cs",	true);
		_styleMap.defineCharacter("Hyperlink",				"cs",	true);
		_styleMap.defineCharacter("Line Number",			"cs",	true);
		_styleMap.defineCharacter("Page Number",			"cs",	true);

		// TetraSix character styles 

		_styleMap.defineCharacter("Product Name",     "pn", false);
		_styleMap.defineCharacter("TradeMark",        "tm", false);
		_styleMap.defineCharacter("Jargon",		      "jg", false);
		_styleMap.defineCharacter("Keyword",		  "kw", false);
		_styleMap.defineCharacter("Exemple inline",   "ei", false);

		_styleMap.defineParagraph("*Bulleted paragraph",  "lb1",	true);
		_styleMap.defineParagraph("*Numbered paragraph",  "ln1",	true);
	}

	public void setGeneratorParam(XmlGeneratorParam param)
	{
		_genParam = param;

		_automaton = new XmlGeneratorAutomaton(this);
		initGeneratorAutomaton();
	}

	public void initGenParam(XmlGeneratorParam genParam)
	{
		genParam.setDtdName("mydoc");
		genParam.setDtdSystemId("mydoc.dtd");
		genParam.setDtdPublicId("-//TetraSix//DTD mydoc v1.1//EN");

		XmlTagMap tags = genParam.getTags();

		tags.add(XmlTagMap.TC_SECTION,  XmlTagMap.TC_TYPE_TAG,   "ti",	"document title",	"title");
		tags.add(XmlTagMap.TC_SECTION,  XmlTagMap.TC_TYPE_TAG,   "h1",	"section level 1");
		tags.add(XmlTagMap.TC_SECTION,  XmlTagMap.TC_TYPE_TAG,   "h2",	"section level 2");
		tags.add(XmlTagMap.TC_SECTION,  XmlTagMap.TC_TYPE_TAG,   "h3",	"section level 3");
		tags.add(XmlTagMap.TC_SECTION,  XmlTagMap.TC_TYPE_TAG,   "h4",	"section level 4");
		tags.add(XmlTagMap.TC_SECTION,  XmlTagMap.TC_TYPE_TAG,   "h5",	"section level 5");
		tags.add(XmlTagMap.TC_SECTION,  XmlTagMap.TC_TYPE_TAG,   "h6",	"section level 6");
		tags.add(XmlTagMap.TC_SECTION,  XmlTagMap.TC_TYPE_TAG,   "ht",	"section title",	"ht");

		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "pa",	"paragraph",				"p");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "b1",	"block element 1",			"b1");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "b2",	"block element 2",			"b2");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "b3",	"block element 3",			"b3");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "b4",	"block element 4",			"b4");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "b5",	"block element 5",			"b5");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "b6",	"block element 6",			"b6");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "b7",	"block element 7",			"b7");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "b8",	"block element 8",			"b8");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "b9",	"block element 9",			"b9");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "sl",	"simple list",				"list");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "ol",	"ordered list",				"list",    "style='numeric'");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "ul",	"unordered list",			"list",    "style='bullet'");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "li",	"list item",				"item");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "dl",	"definition list",			"dl");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "df",	"definition list entry",    "");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "dt",	"definition term",			"dt");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "dd",	"definition",				"dd");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "at",	"attention",				"attention");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "nt",	"note",				        "note");
		tags.add(XmlTagMap.TC_BODY,     XmlTagMap.TC_TYPE_TAG,   "pb",  "Page Break",				"page");

		tags.add(XmlTagMap.TC_TABLE,    XmlTagMap.TC_TYPE_TAG,   "ta",	"table",					"table");
		tags.add(XmlTagMap.TC_TABLE,    XmlTagMap.TC_TYPE_TAG,   "ro",	"table row",				"row");
		tags.add(XmlTagMap.TC_TABLE,    XmlTagMap.TC_TYPE_TAG,   "ce",	"table cell",				"cell", "", true);
		tags.add(XmlTagMap.TC_TABLE,	XmlTagMap.TC_TYPE_ATTR,  "cw",	"cell width attribute name","", "width");
		tags.add(XmlTagMap.TC_TABLE,	XmlTagMap.TC_TYPE_ATTR,  "colspan",	"cell colspan","", "colspan");
		tags.add(XmlTagMap.TC_TABLE,	XmlTagMap.TC_TYPE_ATTR,  "rowspan",	"cell rowspan","", "rowspan");

		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_TAG3,  "gr",	"Picture",					"graphic", "", 
																"URL of the graphic",       "url",
																"entity name of the graphic",    "");
		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_SPECIAL,  "gp",	"Pictures entity prefix",			"g");
		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_SPECIAL,  "gd",	"Pictures directory",			"images");
		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_SPECIAL,  "pe",	"Picture extension",			"wmf");
		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_SPECIAL,  "pnn",	"Picture notation name",			"wmf");
		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_SPECIAL,  "pni",	"Picture notation identifier",			"-/TetraSix/NOTATION Windows Metafile/EN");
		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_TAG3,  "hl",	
				"Hyperlink",				"link", "",
				"URL of the target",        "url",
				"ID within the target",     "refid");

		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_BOOL, "ix",	"is XML",			        "*BOOLEAN*", "true");
		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_SPECIAL, "ec",	"Encoding",							"ISO-8859-1" );
		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_BOOL, "sa",	"Standalone",				"*BOOLEAN*", "true" );
		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_SPECIAL, "sn",	"Stylesheet name",			        "mydoc.xsl");
		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_SPECIAL, "st",	"Stylesheet type",			        "text/xsl");

		tags.add(XmlTagMap.TC_CHARPROP, XmlTagMap.TC_TYPE_TAG,  "bt",	"bold text",				"b");
		tags.add(XmlTagMap.TC_CHARPROP, XmlTagMap.TC_TYPE_TAG,  "it",	"italic text",				"i");
		tags.add(XmlTagMap.TC_CHARPROP, XmlTagMap.TC_TYPE_TAG,  "ut",	"underlined text",			"u");
		tags.add(XmlTagMap.TC_CHARPROP, XmlTagMap.TC_TYPE_TAG,  "vt",	"hidden text",			    "v");


		tags.add(XmlTagMap.TC_INFO,     XmlTagMap.TC_TYPE_BOOL, "ip", "include info block",	"*BOOLEAN*", "true");
		tags.add(XmlTagMap.TC_INFO,     XmlTagMap.TC_TYPE_TAG,  "in", "info block",			"info");
		tags.add(XmlTagMap.TC_INFO,     XmlTagMap.TC_TYPE_TAG,  "iz", "title (info)",		"title");
		tags.add(XmlTagMap.TC_INFO,     XmlTagMap.TC_TYPE_TAG,  "is", "subject (info)",		"subject");
		tags.add(XmlTagMap.TC_INFO,     XmlTagMap.TC_TYPE_TAG,  "ia", "author (info)",	    "author");
		tags.add(XmlTagMap.TC_INFO,     XmlTagMap.TC_TYPE_TAG,  "io", "operator (info)",	"operator");
		tags.add(XmlTagMap.TC_INFO,     XmlTagMap.TC_TYPE_TAG,  "im", "manager(info)",		"manager");
		tags.add(XmlTagMap.TC_INFO,     XmlTagMap.TC_TYPE_TAG,  "ic", "company (info)",		"company"); 

		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_TAG,  "tc", "table of contents",	"toc");

		tags.add(XmlTagMap.TC_ENTITIES, XmlTagMap.TC_TYPE_ENT,  "tb", "Tabulation entity",	"");
		tags.add(XmlTagMap.TC_ENTITIES, XmlTagMap.TC_TYPE_ENT,  "lb", "Line Break",	"");

		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cA",	"color Black",			"c",	"color='black'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cB",	"color Blue",			"c",	"color='blue'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cC",	"color Aqua",		    "c",	"color='aqua'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cD",	"color Lime",			"c",	"color='lime'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cE",	"color Fuchsia",		"c",	"color='fuschia'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cF",	"color Red",			"c",	"color='red'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cG",	"color Yellow",			"c",	"color='yellow'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cH",	"color White",			"c",	"color='white'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cI",	"color Navy",			"c",	"color='navy'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cJ",	"color Teal",			"c",	"color='teal'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cK",	"color Green",			"c",	"color='green'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cL",	"color Purple",			"c",	"color='purple'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cM",	"color Maroon",			"c",	"color='maroon'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cN",	"color Olive",			"c",	"color='olive'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cO",	"color Gray",			"c",	"color='gray'");
		tags.add(XmlTagMap.TC_COLOR,    XmlTagMap.TC_TYPE_TAG,  "cP",	"color Silver",			"c",	"color='silver'");

		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "em",	"Emphasis",			 "emph");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "sg",	"Strong",			 "strong");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "pn",	"Product Name",		 "prodname");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "jg",	"Jargon",			 "jargon");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "tm",	"Trade mark",		 "tm");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "kw",	"Keyword",			 "kw");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "ei",	"Exemple in-line",	 "exemple");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "i1",	"Inline element 1",	 "ie1");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "i2",	"Inline element 2",	 "ie2");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "i3",	"Inline element 3",	 "ie3");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "i4",	"Inline element 4",	 "ie4");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "i5",	"Inline element 5",	 "ie5");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "i6",	"Inline element 5",	 "ie5");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "i7",	"Inline element 5",	 "ie5");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "i8",	"Inline element 5",	 "ie5");
		tags.add(XmlTagMap.TC_INLINE,   XmlTagMap.TC_TYPE_TAG,  "i9",	"Inline element 5",	 "ie5");

		tags.add(XmlTagMap.TC_SPECIAL,  XmlTagMap.TC_TYPE_ATTR,  "id",	"id attribute",	"", "id");

		tags.add(XmlTagMap.TC_MISC,     XmlTagMap.TC_TYPE_BOOL,  "ie",  "include empty paragraphs",	"*BOOLEAN*", "true");
	}

	private static final boolean GENERATE = true;
	private static final boolean AGAIN = true;
	private static final boolean PUSH = true;

	private static final boolean NOGENERATE = false;
	private static final boolean NOAGAIN = false;
	private static final boolean NOPUSH = false;

	public XmlGeneratorAutomaton getGeneratorAutomaton()
	{
		return _automaton;
	}

	public void getGeneratorAutomaton(XmlGeneratorAutomaton  automaton)
	{
		_automaton = automaton;
	}

	void initGeneratorAutomaton()
	{
		// start of file
		XmlGeneratorState state0   = new XmlGeneratorState("Sinfile");

		// in document
		XmlGeneratorState state1   = new XmlGeneratorState("Sindoc");

		// in header of level n
		XmlGeneratorState stateh1  = new XmlGeneratorState("Sh1");
		XmlGeneratorState stateh2  = new XmlGeneratorState("Sh2");
		XmlGeneratorState stateh3  = new XmlGeneratorState("Sh3");
		XmlGeneratorState stateh4  = new XmlGeneratorState("Sh4");
		XmlGeneratorState stateh5  = new XmlGeneratorState("Sh5");
		XmlGeneratorState stateh6  = new XmlGeneratorState("Sh6");

		XmlGeneratorState statelb1 = new XmlGeneratorState("Slb1");
		XmlGeneratorState statelb2 = new XmlGeneratorState("Slb2");
		XmlGeneratorState statelb3 = new XmlGeneratorState("Slb3");
		XmlGeneratorState statelb4 = new XmlGeneratorState("Slb4");
		XmlGeneratorState statelb5 = new XmlGeneratorState("Slb5");
		XmlGeneratorState statelb6 = new XmlGeneratorState("Slb6");
  
		XmlGeneratorState stateln1 = new XmlGeneratorState("Sln1");
		XmlGeneratorState stateln2 = new XmlGeneratorState("Sln2");
		XmlGeneratorState stateln3 = new XmlGeneratorState("Sln3");
		XmlGeneratorState stateln4 = new XmlGeneratorState("Sln4");
		XmlGeneratorState stateln5 = new XmlGeneratorState("Sln5");
		XmlGeneratorState stateln6 = new XmlGeneratorState("Sln6");
  
		XmlGeneratorState statedl1 = new XmlGeneratorState("Sdl1");

		XmlGeneratorState statetable = new XmlGeneratorState("Stable");

		XmlGeneratorState statecellstart = new XmlGeneratorState("Scellstart");
		XmlGeneratorState statecell = new XmlGeneratorState("Scell");

		XmlGeneratorState stateex = new XmlGeneratorState("Spre");

		_automaton.setStartState(state0);
		_automaton.setStartCellState(statecellstart);

		// parameters of defineTransition
		//	startState,
		//	endState,
		//	key,
		//	generate_before,
		//	generate_paragraph,
		//	generate_after,
 		//	boolean again,
		//	push

		// Transitions from state0

		_automaton.defineTransition(state0, state1, "*DOC*",
							  "<!DOCTYPE <D> PUBLIC \"<P>\" \"<S>\" [" + RE + "<E>]>" + RE + "<<D>>" + RE + "<I>" + RE, false, null, false, false);
		_automaton.defineTransition(state0, state1, "*EOF*",
							  RE, false, null, false, false);
		_automaton.defineTransition(state0, state1, "*EOC*",
							  RE, false, null, false, false);
			
		// Transitions from state1

		_automaton.defineTransition(state1, stateh1, "h1",
							  RE + "<h1><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(state1, stateh2, "h2",
							  RE + "<h2><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(state1, stateh3, "h3",
							  RE + "<h3><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(state1, stateh4, "h4",
							  RE + "<h4><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(state1, stateh5, "h5",
							  RE + "<h5><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(state1, stateh6, "h6",
							  RE + "<h6><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);

		_automaton.defineTransition(state1, state1, "p",
							  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(state1, state1, "bl1",
							  RE + "<b1>", true, "</b1>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(state1, state1, "bl2",
							  RE + "<b2>", true, "</b2>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(state1, state1, "bl3",
							  RE + "<b3>", true, "</b3>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(state1, state1, "bl4",
							  RE + "<b4>", true, "</b4>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(state1, state1, "bl5",
							  RE + "<b5>", true, "</b5>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(state1, state1, "bl6",
							  RE + "<b6>", true, "</b6>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(state1, state1, "bl7",
							  RE + "<b7>", true, "</b7>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(state1, state1, "bl8",
							  RE + "<b8>", true, "</b8>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(state1, state1, "bl9",
							  RE + "<b9>", true, "</b9>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(state1, state1, "att",
							  RE + "<at>", true, "</at>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(state1, state1, "not",
							  RE + "<nt>", true, "</nt>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(state1, state0, "*EOF*",
							  "</<D>>", false, null, 
							  AGAIN, NOPUSH);
		_automaton.defineTransition(state1, state0, "*EOC*",
							  "", false, null, 
							  NOAGAIN, NOPUSH);

		_automaton.defineTransition(state1, statelb1, "lb1",
							  RE + "<ul>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(state1, stateln1, "ln1",
							  RE + "<ol>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(state1, state1, "ti",
							  RE + "<ti>", true, "</ti>" + RE, 
							  NOAGAIN, NOPUSH);

		_automaton.defineTransition(state1, statetable, "row",
							  RE + "<ta>", false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(state1, stateex, "ex",
							  RE + "<ex>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(state1, statedl1, "dl1",
							  RE + "<dl>" + RE, false, null, 
							  AGAIN, PUSH);

		// Transitions from stateh1

		_automaton.defineTransition(stateh1, stateh2, "h2",
							  RE + "<h2><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(stateh1, stateh3, "h3",
							  RE + "<h3><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(stateh1, stateh4, "h4",
							  RE + "<h4><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(stateh1, stateh5, "h5",
							  RE + "<h5><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(stateh1, stateh6, "h6",
							  RE + "<h6><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);

		_automaton.defineTransition(stateh1, stateh1, "p",
							  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh1, stateh1, "bl1",
							  RE + "<b1>", true, "</b1>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh1, stateh1, "bl2",
							  RE + "<b2>", true, "</b2>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh1, stateh1, "bl3",
							  RE + "<b3>", true, "</b3>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh1, stateh1, "bl4",
							  RE + "<b4>", true, "</b4>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh1, stateh1, "bl5",
							  RE + "<b5>", true, "</b5>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh1, stateh1, "bl6",
							  RE + "<b6>", true, "</b6>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh1, stateh1, "bl7",
							  RE + "<b7>", true, "</b7>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh1, stateh1, "bl8",
							  RE + "<b8>", true, "</b8>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh1, stateh1, "bl9",
							  RE + "<b9>", true, "</b9>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh1, stateh1, "att",
							  RE + "<at>", true, "</at>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh1, stateh1, "not",
							  RE + "<nt>", true, "</nt>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh1, statelb1, "lb1",
							  RE + "<ul>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh1, stateln1, "ln1",
							  RE + "<ol>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh1, state1, null,
							  "</h1>", false, null, 
							  AGAIN, NOPUSH);
		
		_automaton.defineTransition(stateh1, statetable, "row",
							  RE + "<ta>", false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh1, stateex, "ex",
							  RE + "<ex>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh1, statedl1, "dl1",
							  RE + "<dl>" + RE, false, null, 
							  AGAIN, PUSH);
		// test
		_automaton.defineTransition(stateh1, null, "*EOC*",
				  			  "</h1>", false, null, 
							  AGAIN, NOPUSH);

		// Transitions from stateh2
		_automaton.defineTransition(stateh2, stateh3, "h3",
							  RE + "<h3><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(stateh2, stateh4, "h4",
							  RE + "<h4><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(stateh2, stateh5, "h5",
							  RE + "<h5><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(stateh2, stateh6, "h6",
							  RE + "<h6><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		
		_automaton.defineTransition(stateh2, stateh2, "p",
							  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh2, stateh2, "bl1",
							  RE + "<b1>", true, "</b1>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh2, stateh2, "bl2",
							  RE + "<b2>", true, "</b2>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh2, stateh2, "bl3",
							  RE + "<b3>", true, "</b3>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh2, stateh2, "bl4",
							  RE + "<b4>", true, "</b4>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh2, stateh2, "bl5",
							  RE + "<b5>", true, "</b5>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh2, stateh2, "bl6",
							  RE + "<b6>", true, "</b6>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh2, stateh2, "bl7",
							  RE + "<b7>", true, "</b7>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh2, stateh2, "bl8",
							  RE + "<b8>", true, "</b8>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh2, stateh2, "bl9",
							  RE + "<b9>", true, "</b9>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh2, stateh2, "att",
							  RE + "<at>", true, "</at>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh2, stateh2, "not",
							  RE + "<nt>", true, "</nt>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh2, statelb1, "lb1",
							  RE + "<ul>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh2, stateln1, "ln1",
							  RE + "<ol>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh2, null, null,
							  "</h2>", false, null, 
							  AGAIN, NOPUSH);
		
		_automaton.defineTransition(stateh2, statetable, "row",
 							  RE + "<ta>", false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh2, stateex, "ex",
							  RE + "<ex>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh2, statedl1, "dl1",
							  RE + "<dl>" + RE, false, null, 
							  AGAIN, PUSH);
		// test
		_automaton.defineTransition(stateh2, null, "*EOC*",
				  			  "</h2>", false, null, 
							  AGAIN, NOPUSH);

		// Transitions from stateh3

		_automaton.defineTransition(stateh3, stateh4, "h4",
							  RE + "<h4><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(stateh3, stateh5, "h5",
							  RE + "<h5><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(stateh3, stateh6, "h6",
							  RE + "<h6><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);

		_automaton.defineTransition(stateh3, stateh3, "p",
							  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh3, stateh3, "bl1",
							  RE + "<b1>", true, "</b1>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh3, stateh3, "bl2",
							  RE + "<b2>", true, "</b2>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh3, stateh3, "bl3",
							  RE + "<b3>", true, "</b3>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh3, stateh3, "bl4",
							  RE + "<b4>", true, "</b4>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh3, stateh3, "bl5",
							  RE + "<b5>", true, "</b5>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh3, stateh3, "bl6",
							  RE + "<b6>", true, "</b6>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh3, stateh3, "bl7",
							  RE + "<b7>", true, "</b7>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh3, stateh3, "bl8",
							  RE + "<b8>", true, "</b8>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh3, stateh3, "bl9",
							  RE + "<b9>", true, "</b9>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh3, stateh3, "att",
							  RE + "<at>", true, "</at>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh3, stateh3, "not",
							  RE + "<nt>", true, "</nt>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh3, statelb1, "lb1",
							  RE + "<ul>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh3, stateln1, "ln1",
							  RE + "<ol>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh3, null, null,
							  "</h3>", false, null, 
							  AGAIN, NOPUSH);
		

		_automaton.defineTransition(stateh3, statetable, "row",
							  RE + "<ta>", false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh3, stateex, "ex",
							  RE + "<ex>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh3, statedl1, "dl1",
							  RE + "<dl>" + RE, false, null, 
							  AGAIN, PUSH);
		// test
		_automaton.defineTransition(stateh3, null, "*EOC*",
				  			  "</h3>", false, null, 
							  AGAIN, NOPUSH);

		// Transitions from stateh4

		_automaton.defineTransition(stateh4, stateh5, "h5",
							  RE + "<h5><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(stateh4, stateh6, "h6",
							  RE + "<h6><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);

		_automaton.defineTransition(stateh4, stateh4, "p",
							  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh4, stateh4, "bl1",
							  RE + "<b1>", true, "</b1>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh4, stateh4, "bl2",
							  RE + "<b2>", true, "</b2>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh4, stateh4, "bl3",
							  RE + "<b3>", true, "</b3>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh4, stateh4, "bl4",
							  RE + "<b4>", true, "</b4>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh4, stateh4, "bl5",
							  RE + "<b5>", true, "</b5>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh4, stateh4, "bl6",
							  RE + "<b6>", true, "</b6>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh4, stateh4, "bl7",
							  RE + "<b7>", true, "</b7>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh4, stateh4, "bl8",
							  RE + "<b8>", true, "</b8>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh4, stateh4, "bl9",
							  RE + "<b9>", true, "</b9>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh4, stateh4, "att",
							  RE + "<at>", true, "</at>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh4, stateh4, "not",
							  RE + "<nt>", true, "</nt>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh4, statelb1, "lb1",
							  RE + "<ul>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh4, stateln1, "ln1",
							  RE + "<ol>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh4, null, null,
							  "</h4>", false, null, 
							  AGAIN, NOPUSH);
		

		_automaton.defineTransition(stateh4, statetable, "row",
							  RE + "<ta>", false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh4, stateex, "ex",
							  RE + "<ex>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh4, statedl1, "dl1",
							  RE + "<dl>" + RE, false, null, 
							  AGAIN, PUSH);
		// test
		_automaton.defineTransition(stateh4, null, "*EOC*",
				  			  "</h4>", false, null, 
							  AGAIN, NOPUSH);

		// Transitions from stateh5
		_automaton.defineTransition(stateh5, stateh6, "h6",
							  RE + "<h6><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);

		_automaton.defineTransition(stateh5, stateh5, "p",
							  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh5, stateh5, "bl1",
							  RE + "<b1>", true, "</b1>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh5, stateh5, "bl2",
							  RE + "<b2>", true, "</b2>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh5, stateh5, "bl3",
							  RE + "<b3>", true, "</b3>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh5, stateh5, "bl4",
							  RE + "<b4>", true, "</b4>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh5, stateh5, "bl5",
							  RE + "<b5>", true, "</b5>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh5, stateh5, "bl6",
							  RE + "<b6>", true, "</b6>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh5, stateh5, "bl7",
							  RE + "<b7>", true, "</b7>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh5, stateh5, "bl8",
							  RE + "<b8>", true, "</b8>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh5, stateh5, "bl9",
							  RE + "<b9>", true, "</b9>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh5, stateh5, "att",
							  RE + "<at>", true, "</at>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh5, stateh5, "not",
							  RE + "<nt>", true, "</nt>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh5, statelb1, "lb1",
							  RE + "<ul>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh5, stateln1, "ln1",
							  RE + "<ol>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh5, null, null,
							  "</h5>", false, null, 
							  AGAIN, NOPUSH);
		
		_automaton.defineTransition(stateh5, statetable, "row",
							  RE + "<ta>", false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh5, stateex, "ex",
							  RE + "<ex>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh5, statedl1, "dl1",
							  RE + "<dl>" + RE, false, null, 
							  AGAIN, PUSH);

		// test
		_automaton.defineTransition(stateh5, null, "*EOC*",
				  			  "</h5>", false, null, 
							  AGAIN, NOPUSH);

		// Transitions from stateh6
		_automaton.defineTransition(stateh6, stateh6, "p",
							  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh6, stateh6, "bl1",
							  RE + "<b1>", true, "</b1>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh6, stateh6, "bl2",
							  RE + "<b2>", true, "</b2>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh6, stateh6, "bl3",
							  RE + "<b3>", true, "</b3>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh6, stateh6, "bl4",
							  RE + "<b4>", true, "</b4>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh6, stateh6, "bl5",
							  RE + "<b5>", true, "</b5>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh6, stateh6, "bl6",
							  RE + "<b6>", true, "</b6>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh6, stateh6, "bl7",
							  RE + "<b7>", true, "</b7>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh6, stateh6, "bl8",
							  RE + "<b8>", true, "</b8>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh6, stateh6, "bl9",
							  RE + "<b9>", true, "</b9>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh6, stateh6, "att",
							  RE + "<at>", true, "</at>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh6, stateh6, "not",
							  RE + "<nt>", true, "</nt>" + RE,
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateh6, statelb1, "lb1",
							  RE + "<ul>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh6, stateln1, "ln1",
							  RE + "<ol>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh6, null, null,
							  "</h6>", false, null, 
							  AGAIN, NOPUSH);
		

		_automaton.defineTransition(stateh6, statetable, "row",
							  RE + "<ta>", false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh6, stateex, "ex",
							  RE + "<ex>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateh6, statedl1, "dl1",
							  RE + "<dl>" + RE, false, null, 
							  AGAIN, PUSH);
		// test
		_automaton.defineTransition(stateh6, null, "*EOC*",
				  			  "</h6>", false, null, 
							  AGAIN, NOPUSH);

		// Transitions from statelb1
		_automaton.defineTransition(statelb1, statelb2, "lb1",
							  RE + "<li><pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(statelb1, statelb3, "lb2",
							  RE + "<ul>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(statelb1, stateln3, "ln2",
							  RE + "<ol>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(statelb1, null, null,
							  "</ul>" + RE, false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineTransition(statelb2, statelb2, "lc1",
		 					  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(statelb2, statelb1, null,
							  "</li>" + RE, false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineTransition(statelb3, statelb4, "lb2",
							  RE + "<li><pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(statelb3, statelb5, "lb3",
							  RE + "<ul>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(statelb3, stateln5, "ln3",
							  RE + "<ol>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(statelb3, null, null,
							  "</ul>" + RE, false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineTransition(statelb4, statelb4, "lc2",
		 					  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(statelb4, statelb3, null,
							  "</li>" + RE, false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineTransition(statelb5, statelb6, "lb3",
							  RE + "<li><pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(statelb5, null, null,
							  "</ul>" + RE, false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineTransition(statelb6, statelb6, "lc3",
		 					  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(statelb6, statelb5, null,
							  "</li>" + RE, false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineTransition(stateln1, stateln2, "ln1",
							  RE + "<li><pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateln1, stateln3, "ln2",
							  RE + "<ol>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateln1, statelb3, "lb2",
							  RE + "<ul>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateln1, null, null,
							  "</ol>" + RE, false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineTransition(stateln2, stateln2, "lc1",
		 					  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateln2, stateln1, null,
							  "</li>" + RE, false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineTransition(stateln3, stateln4, "ln2",
							  RE + "<li><pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateln3, statelb5, "lb3",
							  RE + "<ul>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateln3, stateln5, "ln3",
							  RE + "<ol>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(stateln3, null, null,
							  "</ol>" + RE, false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineTransition(stateln4, stateln4, "lc2",
		 					  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateln4, stateln3, null,
							  "</li>" + RE, false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineTransition(stateln5, stateln6, "ln3",
							  RE + "<li><pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateln5, null, null,
							  "</ol>" + RE, false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineTransition(stateln6, stateln6, "lc3",
		 					  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(stateln6, stateln5, null,
							  "</li>" + RE, false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineDefaultTransition(state1, null, false, null);
		
		// transitions from state statetable

		_automaton.defineTransition(statetable, statetable, "row",
		 					  RE + "<ro>" + RE, true, "</ro>" + RE, 
							  NOAGAIN, NOPUSH);

		_automaton.defineTransition(statetable, null, null,
		 					  "</ta>", false, null, 
							  AGAIN, NOPUSH);

		// transitions from state statecellstart

		_automaton.defineTransition(statecellstart, statecell, "cell",
							  RE + "<ce>" + RE, true, null, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(statecellstart, null, "*EOF*",
							  "</ce>", false, null, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(statecellstart, null, "*EOC*",
							  "</ce>", false, null, 
							  NOAGAIN, NOPUSH);

		// transitions from state statecell

		_automaton.defineTransition(statecell, statecell, "p",
							  RE + "<pa>", true, "</pa>" + RE, 
							  NOAGAIN, NOPUSH);
		_automaton.defineTransition(statecell, null, "*EOF*",
							  "", false, null, 
							  AGAIN, NOPUSH);
		_automaton.defineTransition(statecell, null, "*EOC*",
							  "", false, null, 
							  AGAIN, NOPUSH);

		_automaton.defineTransition(statecell, statelb1, "lb1",
							  RE + "<ul>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(statecell, stateln1, "ln1",
							  RE + "<ol>" + RE, false, null, 
							  AGAIN, PUSH);

		_automaton.defineTransition(statecell, stateex, "ex",
							  RE + "<ex>" + RE, false, null, 
							  AGAIN, PUSH);
		_automaton.defineTransition(statecell, statedl1, "dl1",
							  RE + "<dl>" + RE, false, null, 
							  AGAIN, PUSH);
		// test
		_automaton.defineTransition(statecell, stateh1, "h1",
				              RE + "<h1><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(statecell, stateh2, "h2",
				              RE + "<h2><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(statecell, stateh3, "h3",
	              			  RE + "<h3><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(statecell, stateh4, "h4",
	              			  RE + "<h4><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(statecell, stateh5, "h5",
	              			  RE + "<h5><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);
		_automaton.defineTransition(statecell, stateh6, "h6",
	              			  RE + "<h6><ht>", true, "</ht>" + RE, 
							  NOAGAIN, PUSH);

		// transitions from state stateex
		_automaton.defineTransition(stateex, stateex, "ex",
		 					  "<xl>", true, "</xl>" + RE, 
							  NOAGAIN, NOPUSH);

		_automaton.defineTransition(stateex, null, null,
		 					  "</ex>", false, null, 
							  AGAIN, NOPUSH);

		// transitions from state statedl1

		_automaton.defineTransition(statedl1, statedl1, "dl1",
		 					  "<df>", true, "</df>" + RE, 
							  NOAGAIN, NOPUSH);

		_automaton.defineTransition(statedl1, null, null,
		 					  "</dl>", false, null, 
							  AGAIN, NOPUSH);
	}

	public void initRtfAbstractStyleSheet(RtfAbstractStylesheet assh)
	{
		// Microsoft standard paragraph styles 

		assh.defineParagraphStyle("ti",   "document title");
		assh.defineParagraphStyle("h1",   "Section title, level 1");
		assh.defineParagraphStyle("h2",   "Section title, level 2");
		assh.defineParagraphStyle("h3",   "Section title, level 3");
		assh.defineParagraphStyle("h4",   "Section title, level 4");
		assh.defineParagraphStyle("h5",   "Section title, level 5");
		assh.defineParagraphStyle("h6",   "Section title, level 6");
		assh.defineParagraphStyle("p",    "Normal paragraph");
		assh.defineParagraphStyle("lb1",  "Unordered list item");
		assh.defineParagraphStyle("lb2",  "Unordered list item, level 2");
		assh.defineParagraphStyle("lb3",  "Unordered list item, level 3");
		assh.defineParagraphStyle("ln1",  "Ordered list item");
		assh.defineParagraphStyle("ln2",  "Ordered list item, level 2");
		assh.defineParagraphStyle("ln3",  "Ordered list item, level 3");
		assh.defineParagraphStyle("lc1",  "Continued list item");
		assh.defineParagraphStyle("lc2",  "Continued list item, level 2");
		assh.defineParagraphStyle("lc3",  "Continued list item, level 3");
		assh.defineParagraphStyle("att",  "Attention");
		assh.defineParagraphStyle("not",  "Note");

		if (! Configuration.getProperty("enable.meta").equals("")) {
			assh.defineParagraphStyle("meta",  "Meta");
		}

		// extended paragraph styles

		assh.defineParagraphStyle("dl1",  "Definition List");
		assh.defineParagraphStyle("ex",   "Exemple (block)");
		assh.defineParagraphStyle("bl1",  "block type 1");
		assh.defineParagraphStyle("bl2",  "block type 2");
		assh.defineParagraphStyle("bl3",  "block type 3");
		assh.defineParagraphStyle("bl4",  "block type 4");
		assh.defineParagraphStyle("bl5",  "block type 5");
		assh.defineParagraphStyle("bl6",  "block type 6");
		assh.defineParagraphStyle("bl7",  "block type 7");
		assh.defineParagraphStyle("bl8",  "block type 8");
		assh.defineParagraphStyle("bl9",  "block type 9");

		// character styles

		assh.defineCharacterStyle("cs",  "Default character style");

		assh.defineCharacterStyle("em",	"Emphasis");
		assh.defineCharacterStyle("sg",	"Strong");
		assh.defineCharacterStyle("pn",	"Product Name");
		assh.defineCharacterStyle("jg",	"Jargon");
		assh.defineCharacterStyle("tm",	"Trade mark");
		assh.defineCharacterStyle("kw",	"Keyword");
		assh.defineCharacterStyle("ei",	"Exemple in-line");
		assh.defineCharacterStyle("i1",	"Inline element 1");
		assh.defineCharacterStyle("i2",	"Inline element 2");
		assh.defineCharacterStyle("i3",	"Inline element 3");
		assh.defineCharacterStyle("i4",	"Inline element 4");
		assh.defineCharacterStyle("i5",	"Inline element 5");
		assh.defineCharacterStyle("i6",	"Inline element 6");
		assh.defineCharacterStyle("i7",	"Inline element 7");
		assh.defineCharacterStyle("i8",	"Inline element 8");
		assh.defineCharacterStyle("i9",	"Inline element 9");

		assh.setDefaultStyle("p");
	}
}
